/*
 * findFont.c --
 *
 *      Routines for locating font files.
 *
 * Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>
 * See file COPYING for conditions on use and distribution.
 */

#define WITH_KPATHSEA 1
#if WITH_KPATHSEA
#include <stdio.h>		/* for FILE */
#include "kpathsea/proginit.h"
#include "kpathsea/tex-glyph.h"
#endif

#include "dviInt.h"

#ifndef lint
static char rcsid[] VAR_UNUSED = "$Id: findFont.c,v 1.3 1999/06/13 23:22:27 lingnau Exp $";
#endif /* lint */

int dvi_tfm_files_only = 0;

/*
 * ------------------------------------------------------------------------
 *
 * Dvi_FindFontFile --
 *

 *      Try to find a file implementing a particular font. The font in
 *      question may have any of a number of types, but currently only
 *      PK and TFM files are supported; the TFM files are used if there
 *      is no PK file available. `nameLen' and `name' specify the name
 *      of the font in question, `resPtr' is the resolution of the font
 *      in dots per inch.
 *
 *      This procedure uses the (LGPL'ed) Kpathsearch library by Karl
 *      Berry. There is some provision for using different means, but
 *      why bother?
 *
 * Results:
 *      The result is a pointer to the file for that particular font
 *      or a null pointer if no appropriate file could be found. `*resPtr'
 *      is the resolution in dpi of the font (which may differ from the
 *      one that was passed in due to rounding errors), and `*typePtr' is
 *      the type of file that was actually located.
 *
 * ------------------------------------------------------------------------
 */

char *
Dvi_FindFontFile(nameLen, name, resPtr, typePtr)
    unsigned int nameLen;
    char *name;
    unsigned int *resPtr;
    Dvi_FontType *typePtr;
{
    char *theName = DviSaveStrN(name, (size_t)nameLen);
    char *fontName;

#if WITH_KPATHSEA
    kpse_glyph_file_type fontRet;

    if (!dvi_tfm_files_only) {
	fontName = kpse_find_vf(theName);
	if (fontName) {
	    ckfree(theName);
	    *typePtr = dvi_font_vf;
	    return fontName;
	}

        fontName = kpse_find_pk(theName, *resPtr, &fontRet);
        if (fontName) {
            ckfree(theName);
            *resPtr = fontRet.dpi;
            *typePtr = dvi_font_pk;
            return fontName;
        }
    }

    fontName = kpse_find_tfm(theName);
    if (fontName) {
        ckfree(theName);
        *typePtr = dvi_font_tfm;
        return fontName;
    }
#endif /* WITH_KPATHSEA */
    
    ckfree(theName);
    return (char *)0;
}
