namespace eval cleanup {
    variable cleanup

    # Define the cleanup data structure
    set cleanup(dialog) ""

    switch $tkWorld(ostype) {
	windows {
	    set cleanup(font.message) {helvetica 10}
	    option add *Cleanup.borderwidth 1
	    option add *Cleanup.relief flat
	}
	default {
	    set cleanup(font.message) {helvetica 12}
	    option add *Cleanup.borderwidth 2
	    option add *Cleanup.relief raised
	}
    }

    # Create the images to use for the cleanup dialog.
    for {set x 1} {$x < 9} {incr x} {
	set cleanup(image_$x) [image create photo \
		-file [file join $tkWorld(image_dir) \
		cleanup cleanup$x.gif]]
    }
}

# cleanup::create --
#
#   Method to create a Cleanup exit dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cleanup::create { } {
    global tkWorld
    variable cleanup

    wm withdraw .
    set w [toplevel .cleanup -class Cleanup]
    set cleanup(dialog) $w

    wm overrideredirect .cleanup 1

    # Determine where to place the message popup. Notice the use
    # of .cleanup instead of $w due to the callback in the global space.
    after idle {
	update idletasks

	set xmax [winfo screenwidth .cleanup]
	set ymax [winfo screenheight .cleanup]
	
	set x0 [expr ($xmax - [winfo reqwidth .cleanup])/2]
	set y0 [expr ($ymax - [winfo reqheight .cleanup])/2]

	wm geometry .cleanup "+$x0+$y0"
    }

    # Create the elements of the Cleanup.
    label $w.head \
	    -bg #696969 \
	    -height 1
    label $w.icon \
	    -image $cleanup(image_1)
    label $w.message \
	    -text "Please wait while tkWorld exits..." \
	    -font $cleanup(font.message)

    # Build the cleanup dialog with the clock image.
    grid $w.head \
	    -row 0 \
	    -column 0 \
	    -columnspan 2 \
	    -padx 2 \
	    -pady 2 \
	    -sticky news
    grid $w.icon \
	    -row 1 \
	    -column 0 \
	    -padx 5 \
	    -pady 5 \
	    -sticky news
    grid $w.message \
	    -row 1 \
	    -column 1 \
	    -padx 10 \
	    -pady 5 \
	    -sticky news

    for {set i 1} {$i < 3} {incr i} {
	for {set j 1} {$j < 9} {incr j} {
	    after 100 
	    update idletasks
	    $w.icon configure -image $cleanup(image_$j)
	}
    }

    update idletasks
}

# cleanup::close  --
#
#   Method to close the cleanup dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cleanup::close { } {
    variable cleanup

    destroy $cleanup(dialog)
}