#include "ttfprint.h"
#include <getopt.h>
#include <math.h>
#include <memory.h>
#include <time.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/wait.h>

#define DYNADICT -1 	/* Font dictionary Size */

/* Command line options definition */
			/* One Pixel is 1/72 inch */
#define PAPER 	1	/* Paper type */
#define PX	2	/* Pixels in X coordinate */
#define PY	3	/* Pixels in Y coordinate */
#define LM 	4	/* Left Margin*/
#define RM	5	/* Right Margin */
#define TM	6	/* Top Margin */
#define BM 	7	/* Bottom Margin */
#define FS	8	/* Font Size */
#define CS	9	/* Character Space */
#define LS	10	/* Line Space */
#define FD	11	/* Font dictionary size */
#define WRAP	12	/* Wrap a long line to next line */
#define FN	13	/* Font name */
#define CX	14	/* Characters per line */
#define CY	15	/* Lines per page */
#define LAND	16	/* Print in landscape */
#define DNFS	17	/* Document name font size */
#define DNCS	18	/* Document name character size */
#define DNT	19	/* Document name in top of page */
#define DNB	20	/* Document name in bottom of page */
#define DUP	21	/* Duplex print */
#define MF	22	/* Manual Feed */
#define TRAY	23	/* Print from tray ? */
#define OUTBIN	24	/* Output Bin */
#define PGNO	25	/* Print page no or not */
#define LOG	26	/* Log input data */
#define LOGPS	27	/* Log generated ps file */
#define TEMP	28	/* Preserve temporary file */
#define COPY	29	/* Number of copies to print */
#define HDR	30	/* Header file (obsolete) */
#define TPL	31	/* Template file (obsolete) */

/* End of Options definition */

/* Paper Type definition */
#define A0 0
#define A1 1
#define A2 2
#define A3 3
#define A4 4
#define A5 5
#define A6 6
#define B0 7
#define B1 8
#define B2 9
#define B3 10
#define B4 11
#define B5 12
#define HALF 13
#define LEGAL 14
#define LETTER 15
#define USER 16
/* End of Paper Type definition */

void ttf2ps();

struct paper	/* Paper type geometry definition (in Pixel)*/
  {
  char paper_type[10];
  int xcoor;
  int ycoor;
  };


/* Paper size definition the unit is 1/72 inch */  
struct paper paper_array[]=
	{
	{"A0",2380,3368},
	{"A1",1684,2380},
	{"A2",1190,1684},
	{"A3",842,1191},
	{"A4",595,842},
	{"A5",421,595},
	{"A6",297,421},
	{"B0",2836,4008},
	{"B1",2004,2836},
	{"B2",1418,2004},
	{"B3",1002,1418},
	{"B4",729,1032},
	{"B5",516,729},
	{"half",396,612},
	{"legal",612,1008},
	{"letter",612,792},
	{"user",0,0},
	{"",0,0}
	};
#define PAPERS 16  
  

/*Global Variables for page description */
PRECISION tm=40;	/* top margin 		*/
PRECISION bm=35;	/* bottom margin 	*/
PRECISION lm=40;	/* left margin 		*/
PRECISION rm=40;	/* right margin 	*/
PRECISION fs=10.5;	/* font size 		*/
PRECISION cs=1;		/* character space 	*/
PRECISION ls=1;		/* line space 		*/
PRECISION dnfs=0;	/* Doc Name font size	*/
PRECISION dncs=2;	/* Doc Name Char space  */
char dnb[50];		/* Doc Name at bottom  	*/
char dnt[50];		/* Doc Name at top	*/
int cpl;		/* char per line 	*/
int lpp;		/* line per page 	*/
int pt=A4;		/* paper type		*/
int px;			/* paper width (in dot) */
int py;			/* paper width (in dot) */
int cx=0;		/* char per line	*/
int cy=0;		/* line per page	*/
int font_dict=200;	/* number font dict	*/
int dupp=-1;		/* duplex printing	*/
BOOL land=FALSE;	/* Landscape		*/
BOOL wrap=TRUE;		/* wrap or not 		*/
BOOL mf=-1;		/* ManualFeed		*/
int tray=-1;		/* Select Tray		*/
int outbin=-1;		/* Set output bin	*/
BOOL pgno=TRUE;		/* Print page no or not */
BOOL logdata=FALSE;	/* Save log data	*/
BOOL ftemp=FALSE;	/* Preserve temporary file or not */
BOOL logps=FALSE;	/* Save ps log data	*/
int total_tplpage=0;	/* total template page */
int copy=1;		/* number of copies	*/
char hdr[30]="@!~";	/* Header eps file	*/
char mphdr[30]="@!~";	/* Mulitpage header eps file */
/*char tpl[30]="@!~";	 Template EPS file 	*/
struct fax_num *fax_nr = NULL; /* Fax number list 	*/
struct fax_num *fax_spool = NULL; /* Fax spool list	*/
struct fax_num *tmp_faxlist;
struct email *email = NULL;	/* Return Email		*/
struct comment *comm = NULL; 	/* comment */
struct err_cmd *err_cmd;	/* Error command */
char name[50]="@!~";	/* Job name */
char fax_id[100]="";	/* Fax id string */
char fax_fn[50];	/* G3 Fax file 		*/
pid_t ttpid;
pid_t cldpid;
int cld_status;

/*End global Variables for page description */

static struct option long_option[]=
	{
	{"paper",1,0,PAPER},
	{"px",1,0,PX},
	{"py",1,0,PY},
	{"lm",1,0,LM},
	{"rm",1,0,RM},
	{"tm",1,0,TM},
	{"bm",1,0,BM},
	{"fs",1,0,FS},
	{"cs",1,0,CS},
	{"ls",1,0,LS},
	{"fd",1,0,FD},
	{"wrap",0,0,WRAP},
	{"fn",1,0,FN},
	{"cx",1,0,CX},
	{"cy",1,0,CY},
	{"land",0,0,LAND},
	{"dnfs",1,0,DNFS},
	{"dncs",1,0,DNCS},
	{"dnt",1,0,DNT},
	{"dnb",1,0,DNB},
	{"dup",1,0,DUP},
	{"mf",0,0,MF},
	{"tray",1,0,TRAY},
	{"outbin",1,0,OUTBIN},
	{"pgno",0,0,PGNO},
	{"log",0,0,LOG},
	{"logps",0,0,LOGPS},
	{"temp",0,0,TEMP},
	{"copy",1,0,COPY},
	{"hdr",1,0,HDR},
	{"tpl",1,0,TPL},
	{0,0,0,0}
	};


extern void prescan();
void StartDoc();
extern void print_file();
extern void template();
void usage();
void q_prog();

struct font_data *fl_head,*fl_tail,*fl_current;
			/* font dictionary pool link list */
			
struct tpl_pagedata *tpl_page[TPL_PAGE];

char fixpsf_buffer[20480];
char *psf_buffer;	/* Postscript description of font */ 
FILE *ttf_file;		/* TTF font file */
FILE *out_file;		/* Output file */
FILE *log_file;		/* Input log file */
FILE *ps_file;		/* Generated Postscript file */
FILE *tpl_file;		/* Template postscript file */
FILE *inf,*tempfile;	/* Input File & output file */


char font_fn[70];	/* TTF font name */ 
char temp_fn[40];	/* Temporary file name */
char log_fn[100];	/* Input log file name */
char ps_fn[100];	/* Generated Postscript file name */
char cur_font_fn[30];

#ifdef SYSCC
char font_sub_fn[15]="mm";
#else
char font_sub_fn[15]="moe_sung";	
			/* Default font sub name */
#endif

char *hdr_path;		/* The path of header file */
char *tpl_path;		/* The path of Template file */
char *log_path;		/* The path of log file and ps file */
char *font_path;	/* The path of TTF font file */


char *arg[MAX_FAXPAGE+5];
char argg[MAX_FAXPAGE][30];
char arg1[30];
char arg2[30];
char arg3[30];
char *arg_np;

int  font_count=0;
long total_cchar=0;
unsigned int page_count;

char tm_str[50];	/* Time stamp string (print on left bottom of every page  */

struct font_data fontpool[FONTNUM];
			/* Font spool of all font used  */
  char tf_str[2][8] = {"False","True"};
  			/* True & False string */

void main(int argc,char **argv)
  {
  PRECISION cxfs,cyfs; 	/* the char size computed due to cx and cy */
  int temp;
  
  time_t curtime;	/* The time file is proceed */
  struct tm *loctime;
  
  int i;
  int c,option_index;
  
  
  fl_head = NULL;
  fl_tail = NULL;
  
  ttpid= getpid();
  
  option_index=0;
  dupp=-1;


/* getting the environment variable & setting the correct path */

  if ((font_path = getenv ("TTF_PATH")) == NULL)
    font_path = "/usr/lib/ttf";
  
  if ((log_path = getenv ("TTP_LOG")) == NULL)
    log_path =  "/var/spool/ttprint";
    
  if ((hdr_path = getenv ("HDR_PATH")) == NULL)
    hdr_path = "/usr/lib/ttfprint/hdr";
    
  if ((tpl_path = getenv ("TPL_PATH")) == NULL)
    tpl_path = "/usr/lib/ttfprint/tpl";
      
  
/* Setting up default value */
  px=paper_array[A4].xcoor; 	/* Default paper size is A4 */
  py=paper_array[A4].ycoor;
  
/* Parse the Command line argument */
  while ((c=getopt_long(argc,argv,"",long_option,&option_index)) != -1) 
    {
    if (!((c==WRAP) || (c==LAND) || (c==MF) ||(c ==PGNO)|| (c==LOG) || (c==LOGPS) ||(c==TEMP)) && !(optarg))
      usage();
    switch(c)
      {
      case PAPER	:       for (i=0;i<PAPERS;i++)
      				  {
      				  if (!strcasecmp(optarg,paper_array[i].paper_type))
      				    {
      				    pt = i;
      				    px = paper_array[i].xcoor;
      				    py = paper_array[i].ycoor;
      				    break;
      				    }
      				  }
      				if (i == PAPERS)
      				  {
      				  printf ("\n\a No paper size %s \n",optarg);
      				  q_prog(E_NO_PAPER,"");
      				  }
      				break;  
      case PX		:	px = atoi(optarg);
      				pt = USER;
      				break;
      case PY		:	py = atoi(optarg);
      				pt = USER;
      				break;
      case LM		:	lm = atof(optarg);
      				break;
      case RM		:	rm = atof(optarg);
      				break;
      case TM		:	tm = atof(optarg);
      				break;
      case BM		:	bm = atof(optarg);
      				break;
      case FS		:	fs = atof(optarg);
      				break;
      case CS		:	cs = atof(optarg);
      				break;
      case LS		:	ls = atof(optarg);
      				break;
      case FD		:	font_dict = atoi(optarg);
      				break;
      case WRAP		:	wrap=FALSE;
      				break;
      case FN		:	strcpy(font_sub_fn,optarg);
      				break;
      case CX		: 	cx = atoi(optarg);
      				break;
      case CY		:	cy = atoi(optarg);
      				break;
      case LAND		:       land=TRUE;
      				break;
      case DNFS		:	dnfs = atof(optarg);
      				break;	
      case DNCS		:	dncs = atof(optarg);
      				break;
      case DNT		:	strcpy(dnt,optarg);
      				break;
      case DNB		:	strcpy(dnb,optarg);
      				break;
      case DUP		:	dupp = atoi(optarg);
      				break;
      case MF		:	mf = TRUE;
      				break;
      case TRAY		:	tray = atoi(optarg);
      				break;
      case OUTBIN	:	outbin = atoi(optarg);
      				break;
      case PGNO		:	pgno=FALSE;
      				break;
      case LOG		:	logdata=TRUE;
      				break;
      case LOGPS	:	logps=TRUE;
      				break;
      case TEMP		:	ftemp=TRUE;
      				break;
      case COPY		:	copy = atoi(optarg);
      				break;
      case HDR		:	strcpy (hdr,optarg);
             		  	lm = HDR_LM;
            		  	rm = HDR_RM;
            		  	cs = HDR_CS;
            		  	ls = HDR_LS;
            		  	bm = HDR_BM;
            		  	tm = HDR_TM;
            		  	cx = HDR_CX;
            		  	cy = HDR_CY;
            		  	pgno = HDR_PGNO;
            		  	pt = 4;
            		  	px = 595;
            		  	py = 842;
            		  	wrap = TRUE;
            		  	dupp = HDR_DUP;
      				break;
      case TPL		: 	
      				break;
      default		:	usage();
      }
    }
    
/* generate the time stamp string */
  curtime = time (NULL);
  loctime = localtime(&curtime);
  strftime (tm_str,30,"%Y/%m/%d %a %H:%M",loctime);
  
/* Opening all of input and output files */  

  if (optind < argc)
    {
    inf = fopen (argv[optind],"rb");
    out_file = fopen ("cp.out","w+");
    }
  else
    {
    inf = stdin;
    out_file = stdout;
    }
  
  sprintf(temp_fn,"/tmp/ttp%d.tmp",ttpid);
  sprintf(log_fn,"%s/ttp%d.log",log_path,ttpid);
  
  tempfile = fopen (temp_fn,"w+");
  if (logdata ==TRUE)
    log_file = fopen (log_fn,"w+");
  
  if (inf == NULL)
    {
    printf ("Error opening input file \n");
    q_prog(E_NO_INF,argv[optind]);
    }
  if (tempfile == NULL)
    {
    printf ("Error opening temp file \n");
    q_prog(E_NO_TMPF,temp_fn);
    }



  if (out_file == NULL)
    {
    printf ("Error opening out_file \n");
    q_prog (E_NO_OUTF,"cp.out");
    }
  if (logdata == TRUE)
    if (log_file == NULL)
      {
      printf ("Error opening log file \n");
      q_prog(E_NO_LOGF,log_fn);
      }
      
  /* prescan the input data */

#ifdef DEBUG
  printf ("prescan-\n");
#endif
  prescan(inf,tempfile); 
#ifdef DEBUG
  printf ("prescan+\n");
#endif

  if ((fax_nr != NULL) || (fax_spool != NULL))
    {
    logps = TRUE;
    sprintf(ps_fn,"/tmp/fax%d.ps",ttpid);
    }
  else if (logps == TRUE)
    sprintf(ps_fn,"%s/ttp%d.ps",log_path,ttpid);
    
  if (logps == TRUE)
    if ((ps_file = fopen (ps_fn,"w")) == NULL )
      {
      printf ("Error opening ps log file %s\n",ps_fn);
      q_prog(E_NO_PSF,ps_fn);
      }

  if (land==TRUE)
    {
    temp=px;
    px=py;
    py=temp;
    }
  
  /* Calculate the correct font size and cpl, lpp to use */ 
  
  if ((cx !=0) && (cy != 0))
    {
    cxfs = ((px - lm - rm)/cx -cs)*2;
    cyfs = (py - tm - bm)/cy -ls;
    if (cxfs > cyfs)
      {
      fs = cyfs;
      cs = cs + (cxfs-cyfs)/2;
      }
    else 
      {
      fs = cxfs;
      ls = ls + (cyfs - cxfs);
      }
/*    cpl = cx-1;*/
    cpl = cx;
    lpp = cy;
    }
  else if ((cx!=0) && (cy ==0))
    {
    fs = ((px-lm -rm)/cx -cs)*2;
    cpl = cx;
    lpp = (int)((float)py -tm -bm)/(fs+ls);
    }
  else if ((cx ==0) &&(cy !=0))
    {
    fs = (py -tm -bm)/cy -ls;
/*    cpl = (int)(((float)px - lm -rm)*2)/(fs+cs*2) -1;*/
    cpl = (int) (((float)px - lm -rm)*2)/(fs+cs*2);
    lpp = cy;
    }  
  else
    {
/*    cpl = (int)(((float)px - lm - rm) * 2) / (fs+cs*2) -1;*/
    cpl = (int)(((float)px - lm - rm) *2)/(fs+cs*2);
    lpp = (int)((float)py - tm - bm) / (fs+ls);
    }
   
  sprintf (font_fn,"%s/%s.ttf",font_path,font_sub_fn);
  ttf_file = fopen (font_fn,"rb");

  if (ttf_file==NULL)
    {
    printf ("Error opening ttf font file %s\n",font_fn);
    q_prog(E_NO_FONTF,font_fn);
    }
  strcpy (cur_font_fn,font_sub_fn);

  if (dnfs==0)
    dnfs = fs*1.2;	/* The default Document name font size */
   
#ifdef DEBUG
  printf ("StartDoc-\n");
#endif
  StartDoc(out_file); 	/* generate  the preamble */
#ifdef DEBUG
  printf ("StartDoc+\n"); 
#endif
  
#ifdef DEBUG
  printf ("template-\n");
#endif DEBUG
  template();
#ifdef DEBUG
  printf ("template+\n");
#endif DEBUG 
  
  
  sprintf (font_fn,"%s/%s.ttf",font_path,font_sub_fn);
  ttf_file = fopen (font_fn,"rb");

  if (ttf_file==NULL)
    {
    printf ("Error opening ttf font file %s\n",font_fn);
    q_prog(E_NO_FONTF,font_fn);
    }
  
  print_file(tempfile,out_file);	/* generate the postscript definition */
#ifdef DEBUG
  printf ("print_file+\n");
#endif
  
  fprintf (out_file,"\n%%%%Trailer\n%%%%EOF\n\n");

/* if the input file is not stdin print out some summary information */

/*
  if (inf != stdin)
    {
    if (fl_head==NULL)
      i=0;
    else
      i = fl_head->count;
    printf ("Pixel in X    : %d		Pixel in Y     : %d\n\
Left Margin   : %.2f		Right Margin   : %.2f\n\
Top Margin    : %.2f		Bottom Margin  : %.2f\n\
Paper type    : %s		Font Size      : %.2f\n\
Char Space    : %.3f		Line Space     : %.3f\n\
Font Type     : %s		Font File      : %s\n\
Input File    : %s	Temp File      : %s\n\
Total Font    : %d		Dict Font      : %d\n\
Total C char  : %d		Max Font count : %d\n\
Chars in X    : %d		Chars in Y     : %d\n\
Char per line : %d		Line per Page  : %d\n\
Total Page    : %d		Wrap           : %s\n\
Doc Name FS   : %.2f		Doc Name CS    : %.2f\n\
Doc Name Top  : %s	Doc Name Bottom: %s\n\
Print Time    : %s\n\
Landscape     : %s		Duplex 	       : %d\n\
Tray	      : %d		pgno	       : %s\n\
Temp	      : %s		log	       : %s\n\
log ps	      : %s		logpath	       : %s\n\
font path     : %s		copies	       : %d\n\
template page : %d\n",px,py,lm,rm,tm,bm,paper_array[pt].paper_type,\
fs,cs,ls,font_sub_fn,font_fn,argv[optind],temp_fn,font_count,\
font_dict,(int)total_cchar,i,cx,cy,cpl+1,lpp,page_count,\
tf_str[wrap],dnfs,dncs,dnt,dnb,tm_str,tf_str[land],dupp,tray,tf_str[pgno],\
tf_str[ftemp],tf_str[logdata],tf_str[logps],log_path,font_path,copy,total_tplpage);
    } 
 */   
 
  fclose (tempfile);

  if (ftemp == FALSE)
    unlink (temp_fn);	/* remove the tempfile */
    
  if ((fax_nr != NULL) || (fax_spool != NULL))
    {
    fclose (ps_file);
    sprintf (fax_fn,"/tmp/fax%dn",ttpid);

    cld_status = 0;
    cldpid=vfork();
    if (cldpid==0)
      {
      arg[0] = "gs";
      arg[1] = "-sDEVICE=faxg3";
      arg[2] = "-dNOPAUSE";
      arg[3] = "-sPAPERSIZE=a4";
      arg[4] = "-q";
      sprintf (arg1,"-sOutputFile=%s%%d.g3",fax_fn);
      arg[5] = arg1;
      arg[6] = ps_fn;
      arg[7] = "-c";
      arg[8] = "quit";
      arg[9] = NULL;
      if (execv ("/usr/bin/gs",arg) == -1)
	exit (-1);
/*        exec_err = 1;
        q_prog(E_EXEC,"gs"); */
      }
    else if (cldpid != -1)
      wait (&cld_status);
    else
      {
      printf ("Can't fork new process!\n");
      q_prog(E_FORK,"g3fax");
      }
      
    if ((cld_status >>8) == 255)
      q_prog(E_EXEC,"gs"); 
      
    for (i = 0;i< (total_tplpage+page_count);i++)
      sprintf (argg[i],"%s%d.g3",fax_fn,i+1);

    tmp_faxlist = fax_spool;
    
    arg[0]="faxspool";
    arg[1]="-h";
    arg[2]="-";
    arg[3]="-C";
    arg[4]="-";
    if (email !=NULL)
      {
      arg[5]="-f";
      arg[6]=email->addr;
      for (i = 0;i< (total_tplpage+page_count);i++)
        arg[8+i] = argg[i];
      arg[8+i] = NULL;
      }
    else 
      {
      for (i = 0;i< (total_tplpage+page_count);i++)
        arg[6+i] = argg[i];
      arg[6+i] = NULL;
      }
      
    while (tmp_faxlist != NULL)
      {
      cld_status = 0;
      if (isdigit(tmp_faxlist->phone[0]))
        {
	cldpid=vfork();
	if (cldpid == 0)
	  {
	  if (email != NULL)
  	    arg[7] = tmp_faxlist->phone;
  	  else
  	    arg[5] = tmp_faxlist->phone;
	  if (execv ("/usr/local/bin/faxspool",arg) == -1)
	    exit(-1);
/*	    q_prog(E_EXEC,"faxspool");*/
	  }
	else if (cldpid != -1)
	  wait(&cld_status);
	else  
	  {
	  printf ("Can't fork new process!\n");
          q_prog(E_FORK,"faxspool");
	  }
        }
      if ((cld_status >> 8) == 255)
        q_prog(E_EXEC,"faxspool");
      
      tmp_faxlist=tmp_faxlist->next;
      }

    tmp_faxlist=fax_nr;
    
    arg[0] = "sendfax";
    for (i = 0;i< (total_tplpage+page_count);i++)
      arg[2+i] = argg[i];
    arg[2+i] = NULL;
    
    while (tmp_faxlist != NULL)
      {
      cld_status = 0;
      if (isdigit(tmp_faxlist->phone[0]))
        {
	cldpid=vfork();
	if (cldpid == 0)
	  {
	  arg[1] = tmp_faxlist->phone;
	  if (execv ("/usr/local/sbin/sendfax",arg) == -1)
	    exit(-1);
/*	    q_prog(E_EXEC,"sendfax");*/
	  }
	else if (cldpid != -1)
	  wait(&cld_status);
	else  
	  {
	  printf ("Can't fork new process!\n");
          q_prog(E_FORK,"sendfax");
	  }
        }
      tmp_faxlist->status = cld_status >> 8;
      if (tmp_faxlist->status == 255)
        q_prog(E_EXEC,"sendfax");
      tmp_faxlist=tmp_faxlist->next;
      }
    
    for (i = 0;i< (total_tplpage+page_count);i++)
      unlink(argg[i]);
    
    unlink (ps_fn);
    }
  q_prog (E_FREE,"");
  }  

void StartDoc(FILE *out_file)
  {
  int i;
  int font_len;
  char mf_str[50]=" ";		/* Manual Feed setpagedevice string */
  char tray_str[120]=" ";	/* Tray selection setpagedevice string */
  char dup_str[120]=" ";	/* Duplex print setpagedevice string */
  char outbin_str[120]=" ";	/* Output bin setpagedevice string */
  char land_str[120]=" ";	/* Landscape printing setpagedevice string */
  char copy_str[50]=" ";	/* More copies printing setpagedevice string */

/* Setting up page devices */
    
  if (mf==TRUE)
    strcpy (mf_str,"/ManualFeed true");  
  else if (mf == FALSE)
    strcpy (mf_str,"/ManualFeed false");
    
  if (tray != -1)
    sprintf (tray_str,"/MediaPosition %d",tray);
  else
    strcpy (tray_str," ");  
    
  if (land==TRUE)
    sprintf (land_str,"/DeferredMediaSelection true /PageSize [%d %d] /ImagingBBox [ 0 0 %d %d ] /Orientation 1",px,py,px,py);
  else
    sprintf (land_str,"/DeferredMediaSelection true /PageSize [%d %d] /ImagingBBox [ 0 0 %d %d ] /Orientation 0",px,py,px,py);
/*  sprintf (land_str," /DeferredMediaSelection true /PageSize [%d %d] /ImagingBBox null",px,py);*/
      
  if (dupp != -1)
    switch(dupp)
      {
      case 1	: if (land == TRUE)
      		    strcpy (dup_str,"/Duplex true /Tumble false");
      		  else
      		    strcpy (dup_str,"/Duplex true /Tumble true");
      		  break;
      case 2	: if (land == TRUE)
        	    strcpy (dup_str,"/Duplex true /Tumble true");
        	  else
        	    strcpy (dup_str,"/Duplex true /Tumble false");
      		  break;
      default 	: strcpy (dup_str,"/Duplex false");
      }
   
   
  switch(outbin)
    {
    case 1	: strcpy (outbin_str,"/OutputType (TOP OUTPUT BIN)");
    		  break;
    case 2	: strcpy (outbin_str,"/OutputType (LEFT OUTPUT BIN)");
    		  break;
    default 	: strcpy (outbin_str," ");
    		  break;
    } 

   sprintf (copy_str,"/NumCopies %d",copy);

/* printf device setup page */

   fprintf (out_file,"%%!PS-Adobe-3.0\n<< %s %s %s %s %s %s >> setpagedevice\n",dup_str,land_str,tray_str,mf_str,outbin_str,copy_str);
   if (logps == TRUE)
     fprintf (ps_file,"%%!PS-Adobe-3.0\n\
<< %s %s %s %s %s %s >> setpagedevice\n",dup_str,land_str,tray_str,mf_str,outbin_str,copy_str);

/* generate the preamble of postscipt definition */
 
  if ((fax_nr == NULL) && (fax_spool == NULL))
    strcpy (fax_id," ");
 
  fprintf (out_file,"\n\
/BeginEPSF {\n/b4_Inc_state save def\n\
/dict_count countdictstack def\n/op_count count 1 sub def\nuserdict begin\n\
/showpage {} def\n0 setgray 0 setlinecap\n1 setlinewidth 0 setlinejoin\n\
10 setmiterlimit [] 0 setdash newpath\n/languagelevel where\n{pop languagelevel\n\
1 ne\n{false setstrokeadjust false setoverprint\n} if\n} if\n} bind def\n\n\
/EndEPSF {\ncount op_count sub {pop} repeat\ncountdictstack dict_count sub {end} repeat\n\
b4_Inc_state restore\n} bind def\n\
/Courier findfont %.2f scalefont setfont\n\
/I {bind def} bind def\n\
/M {moveto} I\n\
/L {lineto} I\n\
/C {curveto} I\n\
/D {closepath fill grestore} I\n\
/S {ashow} I\n\
/B {%.4f %.4f scale newpath} I\n\
/N {gsave translate B} I\n\
/F {%.2f %.2f M gsave /Courier findfont 9 scalefont setfont (%s) show grestore} I\n\
/Q {show F %.2f %.2f M /Courier findfont 6 scalefont setfont (%s) show grestore showpage} I\n\
/P {%.2f %.2f M gsave /Courier-Bold findfont %.2f scalefont setfont %.1f 0 (%s) ashow \
%.2f %.2f M %.1f 0 (%s) ashow %.2f %.2f M /Courier-Bold findfont 10 scalefont setfont} I\n\
/O {grestore showpage} I\n",\
fs,(fs/1000),(fs/1000),20.0,py-12.0,fax_id,lm-5,bm-8,tm_str,(px-strlen(dnt)*(dnfs-dncs))/2,py-tm+dnfs/5,dnfs,dncs,dnt,\
(px-strlen(dnb)*(dnfs-dncs))/2,bm-dnfs-2,dncs,dnb,px-rm-5,bm-8);

   if (logps == TRUE)
     fprintf (ps_file,"\n\
/BeginEPSF {\n/b4_Inc_state save def\n\
/dict_count countdictstack def\n/op_count count 1 sub def\nuserdict begin\n\
/showpage {} def\n0 setgray 0 setlinecap\n1 setlinewidth 0 setlinejoin\n\
10 setmiterlimit [] 0 setdash newpath\n/languagelevel where\n{pop languagelevel\n\
1 ne\n{false setstrokeadjust false setoverprint\n} if\n} if\n} bind def\n\n\
/EndEPSF {\ncount op_count sub {pop} repeat\ncountdictstack dict_count sub {end} repeat\n\
b4_Inc_state restore\n} bind def\n\
/Courier findfont %.2f scalefont setfont\n\
/I {bind def} bind def\n\
/M {moveto} I\n\
/L {lineto} I\n\
/C {curveto} I\n\
/D {closepath fill grestore} I\n\
/S {ashow} I\n\
/B {%.4f %.4f scale newpath} I\n\
/N {gsave translate B} I\n\
/F {%.2f %.2f M gsave /Courier findfont 9 scalefont setfont (%s) show grestore} I\n\
/Q {show F %.2f %.2f M /Courier findfont 6 scalefont setfont (%s) show grestore showpage} I\n\
/P {%.2f %.2f M gsave /Courier-Bold findfont %.2f scalefont setfont %.1f 0 (%s) ashow \
%.2f %.2f M %.1f 0 (%s) ashow %.2f %.2f M /Courier-Bold findfont 10 scalefont setfont} I\n\
/O {grestore showpage} I\n",\
fs,(fs/1000),(fs/1000),20.0,py-12.0,fax_id,lm-5,bm-8,tm_str,(px-strlen(dnt)*(dnfs-dncs))/2,py-tm+dnfs/5,dnfs,dncs,dnt,\
(px-strlen(dnb)*(dnfs-dncs))/2,bm-dnfs-2,dncs,dnb,px-rm-5,bm-8);

  if (fax_nr || fax_spool)
    {
    fprintf (out_file,"/Courier-Bold findfont %.2f scalefont setfont\n",fs);
    if (logps == TRUE)
      fprintf (ps_file,"/Courier-Bold findfont %.2f scalefont setfont\n",fs);
    }

  psf_buffer=fixpsf_buffer;

/* Get Postscript description of font in dictionary */

  fl_current = fl_head;
  if (font_dict == DYNADICT)
    font_dict = font_count / 3;
  
  i = 0;
  
  while (fl_current != NULL)
    {
    if (i < font_dict)
      {
      ttf2ps(fl_current->code);
      fprintf(out_file,"/g%03x {%s} I\n\n",fl_current->seq,psf_buffer);
      if (logps == TRUE)
        fprintf(ps_file,"/g%03x {%s} I\n\n",fl_current->seq,psf_buffer);
      fl_current->dict = TRUE;
      i ++;
      }
    else
      {
      if(fl_current->count == 1)
        {
        break;
        }
      if ((psf_buffer = (char *) malloc(20480)) == NULL)
        {
        printf ("\n\a\aError allocate font outline for font seq %d %c%c\n",\
fl_current->seq,fl_current->code[0],fl_current->code[1]);
	q_prog (E_MALLOC,"psf_buffer");
        }
      ttf2ps(fl_current->code);
      font_len = strlen(psf_buffer);
      if ((psf_buffer =(char *) realloc(psf_buffer,font_len+2)) == NULL)
        {
        printf ("\n\a\aError reallocate font outline for font seq %d %c%c\n",\
fl_current->seq,fl_current->code[0],fl_current->code[1]);
	q_prog (E_REALLOC,"psf_buffer");
        }
      fl_current->outline = psf_buffer; 
      }
    fl_current = fl_current->next;
    }
   
  font_dict = i;
  
  fprintf (out_file,"%%EndSetup\n");
  if (logps == TRUE)
    fprintf (ps_file,"%%EndSetup\n");
  
  
  }
  
void usage()
  {
  printf ("This is function usage();\n");
  }
  
  
void q_prog(int err, char *str)
  {
  char str_err[300];
  char outfn[50];
  FILE *outf;

  sprintf (outfn,"/tmp/ttp%d.out",ttpid);
  
  if (strcmp (name,"@!~") == 0)
    strcpy (name,"(no name)");
  
  if ((outf = fopen (outfn,"w+")) == NULL)
    {
    printf ("Error opening result output file!!\n");
    exit(-32768);
    }
  switch (err)
    {
    case E_NO_PAPER 	: sprintf (str_err,"\nError : No specified paper type -- %s\n\n",str); 
    			  break;
    case E_NO_TMPF  	: sprintf (str_err,"\nError : Can't open temporary file -- %s\n\n",str);
    			  break;
    case E_NO_INF   	: sprintf (str_err,"\nError : Can't open input file -- %s\n\n",str);
    			  break;
    case E_NO_OUTF  	: sprintf (str_err,"\nError : Can't open output file -- %s\n\n",str);
    			  break; 
    case E_NO_LOGF	: sprintf (str_err,"\nError : Can't open data log file -- %s\n\n",str);
    			  break;
    case E_NO_PSF	: sprintf (str_err,"\nError : Can't open ps log file -- %s\n\n",str);
    			  break;
    case E_NO_FONTF	: sprintf (str_err,"\nError : Can't open TTF font file -- %s\n\n",str);
    			  break;
    case E_NO_TPLF	: sprintf (str_err,"\nError : Can't open template file -- %s\n\n",str);
    			  break;
    case E_NO_HDRF	: sprintf (str_err,"\nError : Can't open header file -- %s\n\n",str);
    			  break;
    case E_NO_MPHDRF	: sprintf (str_err,"\nError : Can't open multi-page header file -- %s\n\n",str);
    			  break;
    case E_NO_FD	: sprintf (str_err,"\nError : Run out of font dictionary! (call programmer)\n\n");
    			  break;
    case E_MALLOC	: sprintf (str_err,"\nError : Can't allocate more memory for %s!\n\n",str);
    			  break;
    case E_REALLOC	: sprintf (str_err,"\nError : Can't reallocate memory!\n\n");
    			  break;
    case E_TTF2PS	: sprintf (str_err,"\nError : Error in module ttf2ps!\n\n");
    		   	  break;
    case E_TPLPG	: sprintf (str_err,"\nError : Too many templte page!\n\n");
    			  break;
    case E_G3FAX	: sprintf (str_err,"\nError : Can't generate G3 fax file !\n\n");
    			  break;
    case E_FAXSPOOL	: sprintf (str_err,"\nError : Can't spool fax !\n\n");
    			  break;
    case E_SENDFAX	: sprintf (str_err,"\nError : Can't send fax!\n\n");
    			  break;
    case E_FORK		: sprintf (str_err,"\nError : Can't fork a new process for \"%s\" !\n\n",str);
    			  break;
    case E_EXEC		: sprintf (str_err,"\nError : Can't execute image for \"%s\" !\n\n",str);
    	  		  break;
    default		: sprintf (str_err,"\nUnknown Error!\n\n");
    			  break;
    }
    
  if (err == E_FREE)
    {
    if ((fax_nr == NULL) && (fax_spool == NULL))
      {
      fprintf (outf,"\n\nThis message is automatic generated by ttfprint\n\n
Your Job \"%s\" is sucessfully printed (or generated).\n\n",name);
      
      while (comm != NULL)
        {
        fprintf (outf,"comment : %s",comm->string);
        comm = comm->next;
        }
      
      fprintf (outf,"\n\n*********\n\n\
The following list the statistics of your job.\n");
      
      fprintf (outf,"Pixels in X    : %d		Pixels in Y     : %d\n\
Left Margin   : %.2f		Right Margin   : %.2f\n\
Top Margin    : %.2f		Bottom Margin  : %.2f\n\
Paper type    : %s		Font Size      : %.2f\n\
Char Space    : %.3f		Line Space     : %.3f\n\
Font Type     : %s	Font File      : %s\n\
Input File    : %s	Temp File      : %s\n\
Total Font    : %d		Dict Font      : %d\n\
Total C char  : %d		Max Font count : %d\n\
Chars in X    : %d		Chars in Y     : %d\n\
Char per line : %d		Line per Page  : %d\n\
Total Page    : %d		Wrap           : %s\n\
Doc Name FS   : %.2f		Doc Name CS    : %.2f\n\
Doc Name Top  : %s	Doc Name Bottom: %s\n\
Print Time    : %s\n\
Landscape     : %s		Duplex 	       : %d\n\
Tray	      : %d		pgno	       : %s\n\
Temp	      : %s		log	       : %s\n\
log ps	      : %s		logpath	       : %s\n\
font path     : %s		copies	       : %d\n\
template page : %d\n",px,py,lm,rm,tm,bm,paper_array[pt].paper_type,\
fs,cs,ls,font_sub_fn,font_fn,temp_fn,temp_fn,font_count,\
font_dict,(int)total_cchar,0,cx,cy,cpl+1,lpp,page_count,\
tf_str[wrap],dnfs,dncs,dnt,dnb,tm_str,tf_str[land],dupp,tray,tf_str[pgno],\
tf_str[ftemp],tf_str[logdata],tf_str[logps],log_path,font_path,copy,total_tplpage);
      
      } 
    else
      {
      fprintf (outf,"\n\nThis message is automatic generated by ttfprint.\n\n");
      
      while (comm != NULL)
        {
        fprintf (outf,"comment : %s",comm->string);
        comm = comm->next;
        }
      
      fprintf (outf,"\n\nThe result of your fax job \"%s\" is listed bellow\n\
**********\n\n",name);      

      tmp_faxlist = fax_nr;
      while (tmp_faxlist != NULL)
        {
        switch (fax_nr->status)
          {
          case FAX_SUCESS 	: fprintf (outf," %24s : Fax transmitted sucessfully.\n",tmp_faxlist->phone);
          			  break;
          case FAX_COMMAND	: fprintf (outf,"*%24s : Fax error on command line.\n",tmp_faxlist->phone);
          			  break;
          case FAX_DEVICE	: fprintf (outf,"*%24s : Can't open fax device.\n",tmp_faxlist->phone);
          			  break;
          case FAX_INIT		: fprintf (outf,"*%24s : Can't initialize fax modem.\n",tmp_faxlist->phone);
          			  break;
          case FAX_BUSY		: fprintf (outf,"*%24s : The fax is not answer or busy.\n",tmp_faxlist->phone);
          			  break;
          case FAX_DIALTONE	: fprintf (outf,"*%24s : No dial tone on your phone.\n",tmp_faxlist->phone);
          			  break;
          case FAX_CARRIER	: fprintf (outf,"*%24s : NO CARRIER or ERROR  encontered.\n",tmp_faxlist->phone);
          			  break; 
          case FAX_XON		: fprintf (outf,"*%24s : Waiting for XON failed.\n",tmp_faxlist->phone);
          			  break;
          case FAX_TRANSMIT	: fprintf (outf,"*%24s : Not all pages transmitted.\n",tmp_faxlist->phone);
          			  break;
          default 		: fprintf (outf,"*%24s : Unknown Error encountered. Error code %d\n",tmp_faxlist->phone,tmp_faxlist->status);
          			  break;
          }
        tmp_faxlist = tmp_faxlist->next;
        }
      
      fprintf(outf,"\n\n#########\n\n");
       
      tmp_faxlist = fax_spool;
      while (tmp_faxlist != NULL)
        {
        fprintf (outf,"Spool fax to  %s\n",tmp_faxlist->phone);
        tmp_faxlist = tmp_faxlist->next;
        }
      
      }
    }
  else
    {
    fprintf (outf,"Your Job \"%s\" failed due to the following reason.\n",name);
    fprintf (outf,"\n%s\n\n",str_err);
    tmp_faxlist = fax_nr;
    while (tmp_faxlist != NULL)
      {
      fprintf (outf,"Fax number : %s\n",tmp_faxlist->phone);
      tmp_faxlist = tmp_faxlist->next;
      }
    fprintf (outf,"\n\n");
    tmp_faxlist = fax_spool;
    while (tmp_faxlist != NULL)
      {
      fprintf (outf,"Spool fax : %s\n",tmp_faxlist->phone);
      tmp_faxlist = tmp_faxlist->next;
      }
    }
  
  
  if (err_cmd)
    fprintf(outf,"\n###### The following is a list of invalid command found in Document\n\n");
  
  
  while (err_cmd)
    {
    fprintf (outf,"%s",err_cmd->command);
    err_cmd = err_cmd->next;
    }
  
  fprintf (outf,"\n\n******* End of Message ****\n");  
  
  
  fseek (outf,0,SEEK_SET);
  
  arg[0] = "mail";
  arg[1] = "-s";
  if (fax_nr || fax_spool)
    sprintf (arg1,"\"ttfprint fax job (%s) result\"",name);
  else if (err == E_FREE)
    sprintf (arg1,"\"ttfprint job (%s) success\"",name);
  else 
    sprintf (arg1,"\"ttfprint job (%s) failed\"",name);
    
  arg[2] = arg1;
  arg[3] = email->addr;
  arg[4] = NULL;
  
  while (email != NULL)
    {
    cldpid = fork();
    if (cldpid == 0)
      {
      arg[3] = email->addr;
      close(0);
      dup(fileno(outf));
      
      if (execv ("/bin/mail",arg) == -1)
        q_prog(E_EXEC,"mail");
      }
    else if (cldpid == -1)
      {
      printf ("Can't fork new process !\n");
      q_prog (E_FORK,"mail");
      }
    else
      wait (&cld_status);
  
    email = email->next;  
    }
  fclose (outf);
/*  unlink (outfn);*/
    
  exit (-err);
  }