<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * Display mails
 *
 * CVS Info:  $Id: mail_show.php,v 1.7.2.1 2003/05/15 16:59:59 gokohnert Exp $
 * $Author: gokohnert $
 *
 * @modulegroup mailbox
 * @module mail_show
 * @package mailbox
 *
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('mailbox','show');
 loadmodule('mailbox');
 loadlayout();

 $enc[0] = "7Bit";
 $enc[1] = "8Bit";
 $enc[2] = "BINARY";
 $enc[3] = "BASE64";
 $enc[4] = "QUOTED PRINTABLE";
 $type[0] = "text";
 $type[1] = "multipart";
 $type[2] = "message";
 $type[3] = "application";
 $type[4] = "audio";
 $type[5] = "image";
 $type[6] = "video";
 $type[7] = "other";

 /**
  * show a mail
  */
 class mail_show extends layout {
   /**
    *
    */
   Function dump_para(&$arr,$name) {
     #echo "$name :". gettype($arr);
     while (list ($key,$val) = each ($arr)) {
       echo "<tr>\n";
       echo " <td><font size=\"-2\">D:". $key ."</font></td>\n";
      if ( is_Array($val) ) {
         echo " <td>". $name ." ARR</td>\n";
         echo "</tr>\n";
         reset($val);
         $this->dump_para($val,$name);
       } else
       if ( is_object($val) ) {
         echo " <td>". $name ." Obj</td>\n";
         echo "</tr>\n";
         $this->dump_para($val,$name);
       } else {
         echo " <td><font size=\"-2\">". $val ."</font></td>\n";
         echo "</tr>\n";
       }
     }
   }
   /**
    *
    */
   Function show_data($pnr,$type,$encode) {
     $b = imap_fetchbody($this->obj->mbox,$this->mno,$pnr,FT_PEEK | FT_UID );
     if ( $encode == 4 ) {
       $b = imap_qprint($b);
     }
     if ( $encode == 3 ) {
       $b = imap_base64($b);
     }
     return $b;
   }
   /**
    *
    */
   Function show_part(&$arr,$pnr = -1) {
     global $lang, $enc, $type, $header, $tutos;

     if ( !isset($arr->type) ) {
       $arr->type = "";
     }
     if ( !isset($arr->encoding) ) {
       $arr->encoding = "";
     }
     if ( ($arr->type == 1) ) {
       if ( $pnr == -1 ) {
        $pnr = 0;
       }
       echo "<tr>\n";
       echo " <th colspan=\"2\">". $pnr ." ". $type[$arr->type] ."/". $arr->subtype ."</th>\n";
       echo "</tr>\n";
       $sub = 1;
       while (list ($key,$val) = each ($arr->parts)) {
         if ( $pnr > 0 ) {
           $this->show_part($val,$pnr .".". $sub);
         } else {
           $this->show_part($val,$sub);
         }
         $sub++;
       }
       return;
     } else {
       if ( $pnr == -1 ) {
         $pnr = 1;
       }
     }

     $url = "mailbox/mail_show.php?id=". $this->obj->id ."&amp;path=". Base64_Encode($this->obj->addpath);
     $url= addUrlParameter($url,"mno=".$this->mno);
     $url= addUrlParameter($url,"t=".$arr->type);
     $url= addUrlParameter($url,"e=".$arr->encoding);
     $url= addUrlParameter($url,"s=".$arr->subtype);

     # Common Header
     echo "<tr><td colspan=\"2\"><hr noshade></td></tr>\n";

     echo "<tr>\n";
     echo " <th colspan=\"2\">\n";
     if ( $arr->type != 0 ) {
       echo "  ". $this->theme->getImage(paper,'list') ."&nbsp;";
     }
     echo $type[0 + $arr->type] ."/". $arr->subtype ." ". $arr->encoding ."</th>\n";
     echo "</tr>\n";
     if ( $arr->ifdescription ) {
       echo "<tr>\n";
       echo $this->showfield($lang['Description']);
       echo $this->showdata($arr->description);
       echo "</tr>\n";
     }
     if ( $arr->bytes > 0 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['MailSize']);
       echo $this->showdata($arr->bytes ." Bytes");
       echo "</tr>\n";
     }

     if ( $arr->ifdparameters ) {
       while (list ($key,$val) = each ($arr->dparameters)) {
         if ( strtolower($val->attribute) == "filename" ) {
           echo "<tr>\n";
           echo $this->showfield($lang['MailAttachmentName']);
           $x =  imap_mime_header_decode($val->value);
           echo $this->showdata($x[0]->text);
           echo "</tr>\n";
           $fname = $x[0]->text;
           $url= addUrlParameter($url,"fn=".UrlEncode($fname));
		 }
       }
	 }
     if ( $arr->ifparameters ) {
       while (list ($key,$val) = each ($arr->parameters)) {
         if ( strtolower($val->attribute) == "name" ) {
           echo "<tr>\n";
           echo $this->showfield($lang['MailAttachmentName']);
           $x =  imap_mime_header_decode($val->value);
           echo $this->showdata($x[0]->text);
           echo "</tr>\n";
           $fname = $x[0]->text;
           $url= addUrlParameter($url,"fn=".UrlEncode($fname));
		 }
       }
     }

     # Texttypes
     if ( ($arr->type == 0) ) {
       $url= addUrlParameter($url,"part=".$pnr);
       if ( $arr->ifparameters ) {
#         $this->dump_para($arr->parameters,"PARA");
       }
       echo "<tr>\n";
       if ( $arr->subtype == "HTML" ) {
         echo " <td colspan=\"2\">\n";
         echo "". makelink($url ."&amp;format=show", $lang['MailAttachmentShow'],$lang['MailAttachmentShow']);
         echo " </td>\n";
       } else {
         echo " <td colspan=\"2\" class=\"pre\">\n";
         echo "<pre>". urlReplace($this->show_data($pnr,0,$arr->encoding)) . "</pre>";
         echo " </td>\n";
       }
       echo "</tr>\n";
     } else if ( ($arr->type == 2) ) {
       # Message
       $b = $this->show_data($pnr,0,$arr->encoding);
       echo "<tr>\n";
       echo " <td colspan=\"2\" class=\"pre\">\n";
       echo " <pre>". $b . "</pre>";
       echo " </td>\n";
       echo "</tr>\n";
     } else if ( ($arr->type == 3) ) {
       # Application
       $url= addUrlParameter($url,"part=".$pnr);
       if ( $arr->ifid ) {
         echo "<tr>\n";
         echo $this->showfield("ID");
         echo $this->showdata($arr->id);
         echo "</tr>\n";
       }
       if ( $arr->ifdisposition ) {
         echo "<tr>\n";
         echo $this->showfield("Disposition");
         echo $this->showdata($arr->disposition);
         echo "</tr>\n";
       }
       if ( $arr->ifparameters ) {
#         $this->dump_para($arr->parameters,"PARA");
       }

       echo "<tr>\n";
       echo " <td colspan=\"2\">\n";
       echo "". makelink($url ."&format=show", $lang['MailAttachmentShow'],$lang['MailAttachmentShow']);
       echo "&nbsp;/&nbsp;";
       echo "". makelink($url ."&format=download", $lang['MailAttachmentDownload'],$lang['MailAttachmentDownload']);
       echo " </td>\n";
       echo "</tr>\n";
     } else if ( ($arr->type == 5) || ($arr->type == 6) ) {
       # Image
       $url= addUrlParameter($url,"part=".$pnr);
       if ( $arr->ifparameters ) {
#         $this->dump_para($arr->parameters,"PARA");
       }
       echo "<tr>\n";
       echo " <td colspan=\"2\">\n";
       echo "". makelink($url ."&amp;format=show", $lang['MailAttachmentShow'],$lang['MailAttachmentShow']);
       echo "&nbsp;/&nbsp;";
       echo "". makelink($url ."&amp;format=download", $lang['MailAttachmentDownload'],$lang['MailAttachmentDownload']);
       echo " </td>\n";
       echo "</tr>\n";
     } else {
       /* Unknown part */
       echo "<tr>\n";
       echo $this->showfield("Unknown");
       echo $this->showdata($arr->encodig);
       echo "</tr>\n";
     }
   }
   /**
    * show only part
    */
   Function info_show() {
     global $tutos,$type;

     $ctype = strtolower($type[$this->t] ."/". strtolower($_GET['s']));
     # Show without decoration
     $b = $this->show_data($_GET['part'],$this->t,$_GET['e']);
     Header("Expires: 0");
     Header("Pragma: no-cache");
     if ( ($ctype == "application/msword") || ($ctype == "application/doc") ) {
       if ( is_executable($tutos[wvHtml])) {
         $fd = fopen("../tmp/xx.doc","w+") ;
         fputs ($fd,$b);
         fclose($fd);
         @passthru($tutos[wvHtml] ." --dir ../tmp ../tmp/xx.doc");
       }
     } else if ( $ctype == "image/gif" ) {
       Header("Content-type: " . $ctype);
       echo $b;
     } else if ( $ctype == "image/jpeg" ) {
       Header("Content-type: " . $ctype);
       echo $b;
     } else if ( $ctype == "text/html" ) {
       Header("Content-type: " . $ctype);
       echo $b;
     } else {
       Header("Content-type: text/plain");
       echo $b;
     }

   }
   /**
    * download only part
    */
   Function info_download() {
     global $type;

     # Show without decoration
     $ctype = strtolower($type[$this->t] ."/". strtolower($_GET['s']));

     Header("Expires: 0");
     Header("Pragma: no-cache");
     Header("Content-type: ". $ctype);
     Header("Content-Disposition: attachment; filename=\"". $_GET['fn'] ."\"");
     Header("Content-Description: Upload from TUTOS" );
     $b = $this->show_data($_GET['part'],$this->t,$_GET['e']);
     echo $b;
   }
   /**
    *
    */
   Function info() {
     global $lang,$tutos;
 
	 if ( $this->format == "show" ) {
       $this->info_show();
       return;
	 }
	 if ( $this->format == "download" ) {
       $this->info_download();
       return;
	 }
     $hdr = imap_headerinfo($this->obj->mbox,imap_msgno($this->obj->mbox,$this->mno) );
     $d = new DateTime();
     $d->setDateTimeTS($hdr->udate);

     echo $this->DataTableStart();

     echo "<tr>\n";
     echo " <th colspan=\"2\">Mail</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['MailDate']);
     if ( $hdr->date ) {
       echo $this->showdata($hdr->date);
     } else {
       echo $this->showdata($d->getDateTime());
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['MailFrom']);
     echo " <td>\n";
     $pre = "";
     @reset($hdr->from);
     while (list ($key,$val) = @each ($hdr->from)) {
       echo $pre;
       if (isset($val->personal)) {
          $s = imap_mime_header_decode($val->personal);
          echo  $s[0]->text;
	   } else {
         $val->personal = "";
	   }
       $em =  $val->mailbox ."@". $val->host;
       echo "&nbsp;&lt;". AsEmail($em, $em,$val->personal) ."&gt;" ;
       $pre = "<br>\n";
     }
     echo " </td>\n";
     echo "</tr>\n";

     if ( count($hdr->to) ) {
       @reset($hdr->to);
       echo "<tr>\n";
       echo $this->showfield($lang['MailTo']);
       echo " <td>\n";
       $pre = "";
       while (list ($key,$val) = @each ($hdr->to)) {
         echo $pre;
         if (isset($val->personal)) {
           $s = imap_mime_header_decode($val->personal);
           echo  $s[0]->text;
         } else {
           $val->personal = "";
         }
         $em =  $val->mailbox ."@". $val->host;
         echo "&nbsp;&lt;". AsEmail($em, $em,$val->personal) ."&gt;" ;
         $pre = "<br>\n";
       }
       echo " </td>\n";
       echo "</tr>\n";
     }

     if ( isset($hdr->cc) && (count($hdr->cc) >0) ) {
       @reset($hdr->cc);
       echo "<tr>\n";
       echo $this->showfield($lang['MailCc']);
       echo " <td>\n";
       $pre = "";
       while (list ($key,$val) = @each ($hdr->cc)) {
         echo $pre;
         if (isset($val->personal)) {
           $s = imap_mime_header_decode($val->personal);
           echo  $s[0]->text;
         } else {
           $val->personal = "";
         }
         $em =  $val->mailbox ."@". $val->host;
         echo "&nbsp;&lt;". AsEmail($em, $em,$val->personal) ."&gt;" ;
         $pre = "<br>\n";
       }
       echo " </td>\n";
       echo "</tr>\n";
     }

	 if (isset($hdr->subject)) {
       echo "<tr>\n";
       $s = imap_mime_header_decode($hdr->subject);
       echo $this->showfield($lang['MailSubject']);
       echo " <td>\n";
       if ( isset($s[0]) ) {
         echo $s[0]->text;
       }
       echo "&nbsp;</td>\n";
       echo "</tr>\n";
	 }

     $url = "mailbox/mail_show.php";
     $url = addSessionKey($url);
     $url = addUrlParameter($url,"id=". $this->obj->id );
     $url = addUrlParameter($url,"mno=". $this->mno );
     $url = addUrlParameter($url,"path=". Base64_Encode($this->obj->addpath) );

     if ( $this->header == 0 ) {
       $url = addUrlParameter($url,"header=1");
       echo "<tr>\n";
       echo " <td colspan=\"2\" align=\"right\">". makelink($url,$lang['MailShowHeaders']) ."</td>\n";
       echo "</tr>\n";
     } else {
       $url = addUrlParameter($url,"header=0");
       echo "<tr>\n";
       echo " <td colspan=\"2\" align=\"right\">". makelink($url,$lang['MailHideHeaders']) ."</td>\n";
       echo "</tr>\n";
       # Header
       $b = imap_fetchheader($this->obj->mbox,$this->mno,FT_PEEK | FT_UID);
       echo "<tr>\n";
       echo " <th colspan=\"2\">". $lang['MailHeaders'] ."</th>\n";
       echo "</tr>\n";
       echo "<tr>\n";
       echo " <td colspan=\"2\" class=\"pre\"><font size=\"-1\">\n";
       echo "<pre>". $b . "</pre>";
       echo " </font></td>\n";
       echo "</tr>\n";
     }
#   $this->dump_para($hdr,"HEADER");

     $this->show_part(imap_fetchstructure($this->obj->mbox,$this->mno, FT_UID));

     $e = imap_errors();
     if ( $e ) {
       $this->dump_para($e,"ERROR");
     }
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang,$msg;

     $this->name = $lang['MailboxDetail'];
     $this->obj = new mailbox($this->dbconn);
     $this->obj->read($_GET['id']);
     if ( isset($_GET['path']) ) {
       $this->path = Base64_Decode($_GET['path']);
       $this->obj->setPath($this->path);
     } else {
       $this->path = "";
     }
     if ( isset($_GET['mno']) ) {
       $this->mno = $_GET['mno'];
     } else {
       $this->stop = true;
     }
     if ( isset($_GET['header']) ) {
       $this->header = $_GET['header'];
     } else {
       $this->header = 0;
     }
     if ( !isset($_GET['t']) ) {
       $this->t = 0 ;
     } else {
       $this->t = $_GET['t'] ;
     }
     $x = sprintf("mpw%d",$this->obj->id);
     if ( isset($_POST['mbpw']) ) {
       $this->obj->pw = $_POST['mbpw'];
#       session_register($x);
       $_SESSION[$x] = $this->obj->pw;
     } else if ( isset($_SESSION[$x]) ) {
       $this->obj->pw = $_SESSION[$x];
     }


     if ( $this->obj->id < 1 ) {
       $this->stop = true;
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # Open the box
     if ( ($this->stop == false) ) {
       if (false == $this->obj->open()) {
         $this->stop = true;
       }
     }

     # MENU
     $url = $this->obj->getUrl();
     if ( $this->obj->addpath != "" ) {
       $url= addUrlParameter($url,"path=".Base64_Encode($this->obj->addpath));
     }
     $x = array( url => $url,
                 text => $lang['MailboxOverview'],
                 info => $lang['MailboxOverview'],
                 confirm => false,
                 category => array("mailbox","show","obj")
               );
     $this->addMenu($x);


     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $url = $this->obj->getUrl();
       $u= addUrlParameter($url,"del=".$this->mno);
       $x = array( url => $u,
                   text => $lang['Delete'],
                   info => $lang['MailDeleteI'],
                   confirm => true,
                   category => array("mailbox","del","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new mail_show($current_user);
 $l->display();
 $l->obj->close();
 $dbconn->Close();
?>
