<p>Help files may contain both HTML and PHP tags since they are displayed
by use of an include() statement.</p>

<p>Here are a few general tips about writing help files:</p>

<p><b>1)</b> Set your debug level to 10 in to see the filenames of missing
help files.</p>

<p><b>2)</b> Whenever referring to text displayed by TWIG, be sure to use 
$TWIGphrase[] instead of simply writing the text.  This way the help
system will display the appropriate text even if some of the $TWIGphrase[]
strings have been modified.  The same principle applies to image
files.</p>

<p><b>3)</b> Use TWIGlink() in the help files to link to other topics or
subtopics.  This makes it very easy to navigate the <?php echo $TWIGphrase["Help"] ?>
system to find related topics.  Do not link to anything outside the help
system, however.</p>

<p><b>4)</b>  If a value for $topic is not passed to the <?php echo $TWIGphrase["Help"] ?> system
then $topic will be set to $context["action"].  This is to facilitate the
easy use of TWIGlink().  For instance, to link to general help on the
<?php echo $TWIGphrase["mail"] ?> system, you could add the following
PHP code to your help file:
<pre> echo TWIGlink( "Help on " .  $TWIGphrase["mail"], "help", "mail");</pre>
The following code would create a link to this file:
<pre> echo TWIGlink( "Writing Help Files", "help", "help", "subtopic=writing");</pre>

<p><b>5)</b> The subtopic lists contained in $submenu[] are specific to
each language and need not be the same across all supported languages.
While, from a development standpoint, there are certain advantages of
having them the same across all languages, there will be no adverse
effects if you add or remove subtopics from one language or another to
suit the needs of your specific site.  Likewise, it is not necessary
to make $TWIGphrase[] entries for subtopic descriptions.</p>
