#include <iostream>
#include "ArrayInfo.hh"
#include "VHDLData.hh"
#include "Types.hh"
#include "STDTypes.hh"
using std::cerr;
using std::endl;

void 
VHDLData::assignSlice(const VHDLData* D, const ArrayInfo* a1, const ArrayInfo *a2) {
  cerr << "Error: Default assignSlice called! Arguments: ";
  D->print(cerr);
  cerr << " " << a1 << endl;
  cerr << " " << a2 << endl;
  abort();
} 

void 
VHDLData::assignSlice(const VHDLData* D, const ArrayInfo* a1) {
  cerr << "Error: Default assignSlice called! Arguments: ";
  D->print(cerr);
  cerr << " " << a1 << endl;
  abort();
} 
  
VHDLData & 
VHDLData::operator=(const VHDLData& data) {
  cerr << "Error: VHDLData::operator = called!! continuing anyway" 
       << endl;
  return (VHDLData &) data;
}

int
VHDLData::savantwrite( ostringstream & ) const {
  // Control will drop here only if the type is OTHER_TYPE
  // Don't know what to do with data of that type of as of now
  // do nothing. But display a message saying that this function
  // is begin called just as a reminder.

  cerr << "WARNING:savantwrite of VHDLData called" << endl;

  return NORMAL_RETURN;
}

int
VHDLData::savantwrite(AccessType &) const
{
  cerr << "WARNING:savantwrite of VHDLData called" << endl;

  return NORMAL_RETURN;
}

int
VHDLData::savantread(AccessType &)
{
  cerr << "WARNING:savantread of VHDLData called" << endl;

  return NORMAL_RETURN;
}

int
VHDLData::savantread(char *)
{
  cerr << "WARNING:savantread of VHDLData called" << endl;

  return NORMAL_RETURN;
}
  
VHDLData*
VHDLData::clone() const
{
  // Control normally will not drop here.
  // Display warning and get out doing nothing.

  cerr << "WARNING:clone of VHDLData called" << endl;

  return NULL; // Make compiler happy
}

ostream &
operator << (ostream &os, const VHDLData &data) {
  data.print(os);
  return os;
}

ostream&
operator<<(ostream &os, const VHDLData::UniversalType type) {
  switch(type) {
  case VHDLData::UNIVERSAL_INTEGER:
    os << "UniversalInteger";
    break;
  case VHDLData::UNIVERSAL_REAL:
    os << "UniversalReal";
    break;
  case VHDLData::UNIVERSAL_CHARACTER:
    os << "UniversalCharacter";
    break;
  case VHDLData::UNIVERSAL_BOOLEAN:
    os << "UniversalBoolean";
    break;
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    os << "UniversalLongLongInteger";
    break;
  case VHDLData::SEVERITY_LEVEL:
    os << "SeverityLevel";
    break;
  case VHDLData::FILE_OPEN_KIND:
    os << "FileOpenKind";
    break;
  case VHDLData::FILE_OPEN_STATUS:
    os << "FileOpenStatus";
    break;
  case VHDLData::ACCESS_VARIABLE:
    os << "AccessVariable";
    break;
  case VHDLData::STRING_BASE:
    os << "StringBase";
    break;
  case VHDLData::OTHER_TYPE:
    os << "OtherType";
    break;
  default:
    os << "[ERROR TYPE!!] ";
    break;
  }

  return os;
}
      
void extractToDelimiter(char *source, int delimiter, char *destination){
  int  counter = 0, destinationPos = 0;
  char found = 0;
  char inQuotes = 0;
  
  while ((!found) && (*(source + counter) != '\0')) {
    if (inQuotes) {
      // We are currently searching withing a string. Wait for another quote
      if (*(source + counter) == '\\') {
	// Ignore this and use the next character as the actual one
	counter++;
	*(destination + destinationPos++) = *(source + counter);
      }
      else {
	if (*(source + counter) == '\"') {
	  inQuotes = 0;
	}
      }
    }
    else {
      if (*(source + counter) == (char) delimiter) {
	found = 1;
      }
      else {
	if (*(source + counter) == '\"') {
	  // Okay. Opening of a quote here
	  inQuotes = 1;
	}
	else {
	  *(destination + destinationPos++) = *(source + counter);
	}
      }
    }
    counter++;
  }

  // Now we should have got something. Finish the destination string
  // and delete the stuff from the source.

  strcpy(source, (source + counter));
  *(destination + destinationPos) = '\0';
}

const EnumerationType &
VHDLData::vhdlEqual( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this == rhs );
}

const EnumerationType &
VHDLData::vhdlNotEqual( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this != rhs );
}

const EnumerationType &
VHDLData::vhdlGreaterThan( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this > rhs );
}

const EnumerationType &
VHDLData::vhdlGreaterThanEqual( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this >= rhs );
}

const EnumerationType &
VHDLData::vhdlLessThan( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this < rhs );
}

const EnumerationType &
VHDLData::vhdlLessThanEqual( const RValue &rhs ) const {
  return EnumerationType::toBoolean( *this <= rhs );
}

