/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef SOURCE_H
#define SOURCE_H

#include "types.h"

SourceLine *SOURCE_new( char *opcode, char par[][MAX_PARAM_LEN] );
void SOURCE_add_line( SourceLine *n );
void SOURCE_load( FILE *file );
void SOURCE_set_label(SourceLine *s, Label *l);
Label *SOURCE_get_label(SourceLine *s);
void SOURCE_set_function(SourceLine *s, Function *f);
Function *SOURCE_get_function(SourceLine *s);
SourceLine *SOURCE_start();
SourceLine *SOURCE_end();
SourceLine *SOURCE_next(SourceLine *l);
SourceLine *SOURCE_prev(SourceLine *l);
int SOURCE_is_opcode(SourceLine *l, char *opcode);
int SOURCE_is_parm(SourceLine *l, char *parm, int n);
char *SOURCE_get_opcode(SourceLine *l);
char *SOURCE_get_parm(SourceLine *l, int n);
int SOURCE_get_parm_count(SourceLine *l);

#endif

