/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "utils.h"

void fatal( char *fmt, ... )
{
	va_list ap;
	va_start(ap,fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr,"\n");
	exit(1);
}

void trim( char *string )
{
	int s;
	s = strlen(string);
	while ( s>0 && (string[s-1]=='\n' || string[s-1]=='\r' || string[s-1]==' ') )
		string[--s]='\0';
}

char *freadline( char *buffer, int maxlen, FILE *file )
{
	char *r;
	r = fgets(buffer,maxlen,file);
	if (!r) 
		fatal( "Unexpected EOF!" );
	trim(buffer);
	//printf( ">%s<\n", buffer );
	return r;
}

int atoi32(char *in)
{
	int res = 0;
	int i;
	for (i=0; in[i]; i++)
	{
		int v;
		res *= 16;
		if (in[i]>='0' && in[i]<='9') v = in[i] - '0';
		else if (in[i]>='a' && in[i]<='f') v = in[i] - 'a' + 10;
		else if (in[i]>='A' && in[i]<='F') v = in[i] - 'A' + 10;
		else return 0;
		res += v;
	}
	return res;
}


