#!/usr/bin/python

import shelve, os

def _opendb():
    global _db
    files = ('/usr/lib/python2.3/unihandb.db', '/usr/local/lib/python2.3/unihandb.db', 'unihandb.db')
    db = None
    for f in files:
        if os.path.exists(f):
            db = shelve.open(f, 'r')
            break
    if not db:
        raise "Cannot open unihandb.db. Does it exist?"
    _db = db
    return db


_db = None

def get_properties(char):
    if not _db:
        _opendb()
    key = repr(ord(char))
    if _db.has_key(key):
        return _db[key]
    else:
        return {}

def get_allchars():
    if not _db:
        _opendb()
    return [unichr(int(x)) for x in _db.keys()]
    
if __name__=='__main__':
    print len(get_allchars())
    print get_properties(u'a')
    print get_properties(u'\u3435')
    
