/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_TRANSFORMABLE_IMAGE_VIEW
#define _H_TRANSFORMABLE_IMAGE_VIEW

#include <Foundation/NSString.h>
#include <Foundation/NSGeometry.h>
#include <AppKit/NSEvent.h>
#include <AppKit/NSImageView.h>


// Notifications sent by the ImageView
extern NSString* N_SelectionChanged;
extern NSString* N_SelectionRemoved;
extern NSString* N_ScrollingRequested;

// Keys for the user information dictionary
// may be associated with notifications
extern NSString* UserInfoKeySelection;
extern NSString* UserInfoKeyScrollAmount;


@interface ExtendedImageView : NSImageView
{
   NSRect  selection;
   NSPoint selectionStart;
   BOOL    drawSelection;
}

- (id) initWithFrame: (NSRect)frame;
- (void) dealloc;

- (void) setSelection: (NSRect)aSelection;
- (void) removeSelection;

- (void) drawRect: (NSRect)aRect;

- (void) mouseDown: (NSEvent*)event;
- (void) mouseDragged: (NSEvent*)event;
- (void) mouseUp: (NSEvent*)event;

@end

#endif
