/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "PrefsController.h"
#include "AppController.h"
#include "ViewPDF.h"

#include <Foundation/NSDictionary.h>
#include <Foundation/NSUserDefaults.h>
#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>
#include <AppKit/NSTextField.h>
#include <AppKit/NSButton.h>

/*
 * Non-Public methods.
 */
@interface PrefsController(Private)
@end


/*
 * Controller for the ViewPDF preferences.
 */
@implementation PrefsController

- (id) init
{
   if ((self = [super init]))
   {
      // ...
   }
   
   return self;
}



- (void) dealloc
{
   [super dealloc];
}


- (void) awakeFromNib
{
   [self setupPrefs: nil];
}


- (id) window
{
   return window;
}


- (void) windowWillClose: (NSNotification*)aNotification
{
   [self applyPrefs: nil];
}


- (void) applyPrefs: (id)sender
{
   //NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];

   // save preferences
}


- (void) setupPrefs: (id)sender
{
   //NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];

   [[AppController sharedController] setPrefsController: self];
}


@end
