/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SYMBOLBAR_H
#define SYMBOLBAR_H

#include <qtoolbar.h>

#include <ToolButton.h>

#include <qmap.h>
#include <qlist.h>
#include <qstringlist.h>
#include <qapplication.h>

class QComboBox;
class QPixmap;
class Component;

class SymbolBar : public QToolBar
{
  Q_OBJECT;
public:
  SymbolBar(const QString & label, QMainWindow*);
  virtual ~SymbolBar();

  static SymbolBar* instance(); 

  void initialize();
  void newComponentCatagorySelected(const QString& catagory);
  void resetSymbols();

  QString getSelectedSymbolName();

private:
  void registerComponent(const Component& component);
  void createCatagoryBox();

private slots:
  void symbolClicked( ToolButton* button );

private:
  static SymbolBar* instance_;

  QString selectedSymbolName_;

  QList<ToolButton> buttonList_;
  QMap<QString, QStringList> catagoryMap_;
  QMap<QString, const QPixmap*> iconMap_;
};

#endif
