#ifndef SCHEDULING_MANAGER_FACTORY_H
#define SCHEDULING_MANAGER_FACTORY_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "Configurer.h"

class Event;
class TimeWarpSimulationManager;
class SimulationObject;
class SchedulingManager;
class TimeWarpEventSetFactory;

/** The SchedulingManagerFactory class.
    
This is the class interface for the various scheduler
implementations that are possible in the Simulation kernel. The
specific implementation is hidden from the other
components of the simulation kernel by the aggregation of the
scheduler implemetations in this class interface ( factory
pattern).  All scheduler implementations must be derived from the
SchedulingManager abstract base class.

*/
class SchedulingManagerFactory : virtual public Configurer {
public:
   
  /**@name Public Class Methods of SchedulingManagerFactory. */
  //@{

  /** Constructor.

  @param simMgr Handle to the simulation manager.
  */
  SchedulingManagerFactory();
  
  /// Destructor.
  virtual ~SchedulingManagerFactory();

  /** Configure the scheduler.

  @param configurationMap Set of configuration options.
  */
  Configurable *allocate( SimulationConfiguration &configuration,
			  Configurable *parent ) const;

  static const SchedulingManagerFactory *instance();
   
  //@} // End of SchedulingManagerFactory Public Class Methods

protected:
   
  /**@name Protected Class Attributes of SchedulingManagerFactory. */
  //@{

  //@} // End of Protected Class Attributes of SchedulingManagerFactory 
};

#endif

