// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: SinkObject.cpp
// 
//---------------------------------------------------------------------------

#include "SinkObject.h"
using std::cerr;
using std::endl;

SinkObject::SinkObject(const VTime& starttime):startTime(starttime),sinkFinished(false){
}

SinkObject::~SinkObject(){
}

bool
SinkObject::amIDone(){
  if(!sinkFinished){
    return false;
  }
  else {
    return true;
  }
}
void
SinkObject::iAmFinished(){
  sinkFinished = true;
}

const int* 
SinkObject::getFanins(){
  cerr << "Error: SinkObject::getFanins called\n";
  return NULL;
}

void
SinkObject::sendEvent(const Event* event){
  cerr << "Error: SinkObject::sendEvent called\n";
  cerr << "Event is " << event << endl;
}





