#include "OutputManagerTest.h"
#include "warped/OutputManager.h"
#include "warped/IntVTime.h"

OutputManagerTest::OutputManagerTest(){}

void
OutputManagerTest::testConstructor( OutputManager *toTest ){
  CPPUNIT_ASSERT( toTest != 0 );
}

void
OutputManagerTest::doDefaultInsert( OutputManager *insertInto ){
  CPPUNIT_ASSERT( insertInto != 0 );
  vector<Event *> &defaultEvents = getDefaultEvents();
  for( vector<Event *>::iterator i = defaultEvents.begin();
       i < defaultEvents.end();
       i++ ){
    insertInto->insert( *i );
  }
}

void
OutputManagerTest::testInsert( OutputManager *toTest ){
  CPPUNIT_ASSERT( toTest != 0 );
  doDefaultInsert( toTest );
  CPPUNIT_ASSERT( getNumElements( toTest, getDefaultSender() ) == getDefaultEvents().size() );
}

void
OutputManagerTest::testGarbageCollect( OutputManager *toTest ){
  CPPUNIT_ASSERT( toTest != 0 );
  doDefaultInsert( toTest );
  CPPUNIT_ASSERT( getNumElements( toTest, getDefaultSender() ) == getDefaultEvents().size() );
  toTest->garbageCollect( IntVTime( 1 ), getSimObj1() );
  CPPUNIT_ASSERT( getNumElements( toTest, getDefaultSender() ) == 0 );
}
