
$feature_depends{'webalizer'} = [ 'web' ];

sub require_webalizer
{
return if ($require_webalizer++);
&foreign_require("webalizer", "webalizer-lib.pl");
%wconfig = &foreign_config("webalizer");
}

# setup_webalizer(&domain)
# Setup the Webalizer module for this domain, and create a Cron job to run it
sub setup_webalizer
{
&$first_print($text{'setup_webalizer'});
&require_webalizer();

local $alog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'});
if (!$alog) {
	&$second_print($text{'setup_nolog'});
	return;
	}

# Create directory for stats
local $tmpl = &get_template($_[0]->{'template'});
local $hdir = &public_html_dir($_[0]);
local $stats;
if ($tmpl->{'web_stats_hdir'}) {
	$stats = "$_[0]->{'home'}/$tmpl->{'web_stats_hdir'}";
	}
elsif ($tmpl->{'web_stats_dir'}) {
	$stats = "$hdir/$tmpl->{'web_stats_dir'}";
	}
else {
	$stats = "$hdir/stats";
	}
if (!-d $stats) {
	&system_logged("mkdir '$stats' 2>/dev/null");
	&system_logged("chmod 755 '$stats'");
	&system_logged("chown $_[0]->{'uid'}:$_[0]->{'ugid'} '$stats'");
	}

# Set up config for log in Webalizer module
local $lcn = &webalizer::log_config_name($alog);
&lock_file($lcn);
local $cfile = &webalizer::config_file_name($alog);
&lock_file($cfile);
if (!-r $lcn) {
	$lconf = { 'dir' => $stats,
		   'sched' => 1,
		   'type' => 0,
		   'over' => 0,
		   'clear' => 0,
		   'user' => $_[0]->{'user'},
		   'mins' => int(rand()*60),
		   'hours' => 0,
		   'days' => '*',
		   'months' => '*',
		   'weekdays' => '*' };
	&webalizer::save_log_config($alog, $lconf);

	# Create a custom webalizer.conf for the site
	# Copy webalizer.conf into place for site, and update
	system("cp $wconfig{'webalizer_conf'} $cfile");
	local $wconf = &webalizer::get_config($alog);
	&webalizer::save_directive($wconf, "HistoryName", "$stats/webalizer.hist");
	&webalizer::save_directive($wconf, "IncrementalName", "$stats/webalizer.current");
	&webalizer::save_directive($wconf, "Incremental", "yes");
	&webalizer::save_directive($wconf, "LogFile", $alog);
	&webalizer::save_directive($wconf, "HostName", $_[0]->{'dom'});
	&webalizer::save_directive($wconf, "HideReferrer", "*.$_[0]->{'dom'}");
	&flush_file_lines();
	&system_logged("chown $_[0]->{'user'}:$_[0]->{'group'} $cfile");
	}
else {
	# Already exists .. but update
	$lconf = &webalizer::get_log_config($alog);
	$lconf->{'dir'} = $stats;
	&webalizer::save_log_config($alog, $lconf);
	local $wconf = &webalizer::get_config($alog);
	&webalizer::save_directive($wconf, "HistoryName", "$stats/webalizer.hist");
	&webalizer::save_directive($wconf, "IncrementalName", "$stats/webalizer.current");
	&flush_file_lines();
	}
&unlock_file($lcn);
&unlock_file($cfile);

&foreign_require("cron", "cron-lib.pl");
local ($job) = grep { $_->{'command'} eq "$webalizer::cron_cmd $alog" }
		    &cron::list_cron_jobs();
if (!$job) {
	# Create a Cron job to process the log
	&setup_webalizer_cron($lconf, $alog);
	}
&$second_print($text{'setup_done'});
}

# setup_webalizer_cron(&lconf, access-log)
sub setup_webalizer_cron
{
local ($lconf, $alog) = @_;
local $job = { 'user' => 'root',
	       'active' => 1,
	       'mins' => $lconf->{'mins'},
	       'hours' => $lconf->{'hours'},
	       'days' => $lconf->{'days'},
	       'months' => $lconf->{'months'},
	       'weekdays' => $lconf->{'weekdays'},
	       'special' => $lconf->{'special'},
	       'command' => "$webalizer::cron_cmd $alog" };
if (!-r $webalizer::cron_cmd) {
	&lock_file($webalizer::cron_cmd);
	&cron::create_wrapper($webalizer::cron_cmd,
			      "webalizer", "webalizer.pl");
	&unlock_file($webalizer::cron_cmd);
	}
&lock_file(&cron::cron_file($job));
&cron::create_cron_job($job);
&unlock_file(&cron::cron_file($job));
}

# modify_webalizer(&domain, &olddomain)
sub modify_webalizer
{
&require_webalizer();
local $alog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'});
if ($_[0]->{'home'} ne $_[1]->{'home'}) {
	# Update Webalizer configuration to use new log file
	&$first_print($text{'save_webalizerlog'});
	local $oldalog = $alog;
	$oldalog =~ s/$_[0]->{'home'}/$_[1]->{'home'}/;	# because it will
							# have been renamed
	local $oldcfile = &webalizer::config_file_name($oldalog);
	local $cfile = &webalizer::config_file_name($alog);
	&rename_logged($oldcfile, $cfile);
	local $oldlcn = &webalizer::log_config_name($oldalog);
	local $lcn = &webalizer::log_config_name($alog);
	&rename_logged($oldlcn, $lcn);
	&foreign_require("cron", "cron-lib.pl");
	local ($job) = grep { $_->{'command'} eq "$webalizer::cron_cmd $oldalog" }
			    &cron::list_cron_jobs();
	if ($job) {
		$job->{'command'} = "$webalizer::cron_cmd $alog";
		&cron::change_cron_job($job);
		}
	&$second_print($text{'setup_done'});
	}
if ($_[0]->{'dom'} ne $_[1]->{'dom'}) {
	# Update hostname in Webalizer configuration
	&$first_print($text{'save_webalizer'});
	local $cfile = &webalizer::config_file_name($alog);
	&lock_file($cfile);
	local $wconf = &webalizer::get_config($alog);
	&webalizer::save_directive($wconf, "HostName", $_[0]->{'dom'});
	&flush_file_lines();
	&unlock_file($cfile);
	&$second_print($text{'setup_done'});
	}
if ($_[0]->{'user'} ne $_[1]->{'user'}) {
	# Update Unix user Webliazer is run as
	&$first_print($text{'save_webalizeruser'});
	local $lcn = &webalizer::log_config_name($alog);
	&lock_file($lcn);
	local $lconf = &webalizer::get_log_config($alog);
	$lconf->{'user'} = $_[0]->{'user'};
	&webalizer::save_log_config($alog, $lconf);
	&unlock_file($lcn);
	&$second_print($text{'setup_done'});
	}
}

# delete_webalizer(&domain)
# Delete the Webalizer config files and Cron job
sub delete_webalizer
{
&$first_print($text{'delete_webalizer'});
&require_webalizer();
local $alog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'});
if (!$alog) {
	&$second_print($text{'delete_webalizerno'});
	return;
	}

# Delete config files
#local $lfile = &webalizer::log_config_name($alog);
#unlink($lfile);
#local $cfile = &webalizer::config_file_name($alog);
#unlink($cfile);
 
# Turn off cron job for webalizer config
&foreign_require("cron", "cron-lib.pl");
local ($job) = grep { $_->{'command'} eq "$webalizer::cron_cmd $alog" }
		    &cron::list_cron_jobs();
if ($job) {
	&lock_file(&cron::cron_file($job));
	&cron::delete_cron_job($job);
	&unlock_file(&cron::cron_file($job));
        }
&$second_print($text{'setup_done'});
}

# check_webalizer_clash()
# Does nothing, because the web clash check is all that is needed
sub check_webalizer_clash
{
return 0;
}

sub enable_webalizer
{
# Does nothing yet
}

sub disable_webalizer
{
# Does nothing yet
}

# backup_webalizer(&domain, file)
# Saves the server's Webalizer config file, module config file and schedule
sub backup_webalizer
{
&$first_print($text{'backup_webalizercp'});
&require_webalizer();
local $alog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'});
if (!$alog) {
	&$second_print($text{'setup_nolog'});
	return 0;
	}
else {
	local $lcn = &webalizer::log_config_name($alog);
	system("cp ".quotemeta($lcn)." ".quotemeta($_[1]));

	local $cfile = &webalizer::config_file_name($alog);
	system("cp ".quotemeta($cfile)." ".quotemeta($_[1])."_conf");
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# restore_webalizer(&domain, file)
# Copies back the server's Webalizer config files, and re-sets up the Cron job
sub restore_webalizer
{
&$first_print($text{'restore_webalizercp'});
&require_webalizer();
local $alog = &get_apache_log($_[0]->{'dom'}, $_[0]->{'web_port'});
if (!$alog) {
	&$second_print($text{'setup_nolog'});
	return 0;
	}
else {
	local $lcn = &webalizer::log_config_name($alog);
	&lock_file($lcn);
	system("cp ".quotemeta($_[1])." ".quotemeta($lcn));
	&unlock_file($lcn);

	local $cfile = &webalizer::config_file_name($alog);
	&lock_file($cfile);
	system("cp ".quotemeta($_[1])."_conf"." ".quotemeta($cfile));
	&unlock_file($cfile);

	&foreign_require("cron", "cron-lib.pl");
	local ($job) = grep { $_->{'command'} eq "$webalizer::cron_cmd $alog" }
			    &cron::list_cron_jobs();
	if ($job) {
		&lock_file(&cron::cron_file($job));
		&cron::delete_cron_job($job);
		}
	local $lcn = &webalizer::log_config_name($alog);
	local $lconf;
	if (!-r $lcn) {
		&lock_file($lcn);
		$lconf = { 'dir' => $stats,
		   'sched' => 1,
		   'type' => 0,
		   'over' => 0,
		   'clear' => 0,
		   'user' => $_[0]->{'user'},
		   'mins' => int(rand()*60),
		   'hours' => 0,
		   'days' => '*',
		   'months' => '*',
		   'weekdays' => '*' };
		&webalizer::save_log_config($alog, $lconf);
		&unlock_file($lcn);
		}
	else {
		$lconf = &webalizer::get_log_config($alog);
		}
	&setup_webalizer_cron($lconf, $alog);
	&$second_print($text{'setup_done'});
	return 1;
	}
}

1;

