/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _FIXED_DIALOG_H
#define _FIXED_DIALOG_H

#include <wftk/dialog.h>

namespace wftk {

/**
 * A dialog that all but ignores its child's packing preferences.
 */
class FixedDialog : public Dialog
{
 public:
  /**
   * Constructor
   *
   *\param child_area A wftk::Rect that holds the dialog's child
   */
  explicit FixedDialog(const Rect& child_area) : child_area_(child_area) {}

 protected:
  /// ignore child's preferences
  virtual void setPackingInfo() {Widget::setPackingInfo();}
  /// and pack it where we want it
  virtual void handleResize(Uint16 w, Uint16 h);

 private:
  Rect child_area_;
};

} // namespace wftk

#endif // !_DIALOG
