/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.CharacterSet;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.UnicodeCharacterSet;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLEmitter
implements Emitter {
    protected Writer writer = null;
    protected CharacterSet characterSet = null;
    protected OutputDetails outputDetails;
    private String[] namespaces = new String[30];
    private int namespacesSize = 0;
    private int[] namespaceStack = new int[100];
    private int nsStackTop = 0;
    private int nsCount = 0;
    protected boolean empty = true;
    protected boolean escaping = true;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    static boolean[] specialInText = new boolean[128];
    static boolean[] specialInAtt;
    char[] attbuff1 = new char[256];
    private char[] charref = new char[10];

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setCharacterSet(CharacterSet characterSet) {
        this.characterSet = characterSet;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (this.characterSet == null) {
            this.characterSet = new UnicodeCharacterSet();
        }
        this.writeDeclaration();
        this.empty = true;
    }

    public void writeDeclaration() throws SAXException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String string;
            String string2;
            String string3 = this.outputDetails.getOmitDeclaration();
            if (string3 == null) {
                string3 = "no";
            }
            if ((string2 = this.outputDetails.getVersion()) == null) {
                string2 = "1.0";
            }
            if ((string = this.outputDetails.getEncoding()) == null) {
                string = "UTF-8";
            }
            if (!string.equalsIgnoreCase("UTF-8") && !string3.equals("yes-really")) {
                string3 = "no";
            }
            String string4 = this.outputDetails.getStandalone();
            if (string3.equals("no")) {
                this.writer.write("<?xml version=\"" + string2 + "\" " + "encoding=\"" + string + "\"" + (string4 != null ? " standalone=\"" + string4 + "\"" : "") + "?>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void writeDocType(String string, String string2, String string3) throws SAXException {
        try {
            this.writer.write("\n<!DOCTYPE " + string + "\n");
            if (string2 != null && string3 == null) {
                this.writer.write("  SYSTEM \"" + string2 + "\">\n");
            } else if (string2 == null && string3 != null) {
                this.writer.write("  PUBLIC \"" + string3 + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + string3 + "\" \"" + string2 + "\">\n");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (this.outputDetails.getCloseAfterUse()) {
                this.writer.close();
            } else {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        int n = this.namespacesSize - 2;
        while (n >= 0) {
            if (this.namespaces[n].equals(string)) {
                if (!this.namespaces[n + 1].equals(string2)) break;
                return;
            }
            n -= 2;
        }
        if (string.equals("") && string2.equals("")) {
            boolean bl = false;
            int n2 = this.namespacesSize - 2;
            while (n2 >= 0) {
                if (this.namespaces[n2].equals("") && !this.namespaces[n2 + 1].equals("")) {
                    bl = true;
                }
                n2 -= 2;
            }
            if (!bl) {
                return;
            }
        }
        if (this.namespacesSize + 2 >= this.namespaces.length) {
            String[] stringArray = new String[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, stringArray, 0, this.namespacesSize);
            this.namespaces = stringArray;
        }
        this.namespaces[this.namespacesSize++] = string;
        this.namespaces[this.namespacesSize++] = string2;
        ++this.nsCount;
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        if (name.getPrefix().equals("") && name.getURI().equals("")) {
            this.startPrefixMapping("", "");
        }
        String string = name.getDisplayName();
        try {
            Object object;
            if (this.empty) {
                String string2 = this.outputDetails.getDoctypeSystem();
                object = this.outputDetails.getDoctypePublic();
                if (string2 != null) {
                    this.writeDocType(string, string2, (String)object);
                }
                this.empty = false;
            }
            if (this.openStartTag) {
                this.closeStartTag(string, false);
            }
            this.writer.write(60);
            this.testCharacters(string);
            this.writer.write(string);
            int n = this.namespacesSize - this.nsCount * 2;
            while (n < this.namespacesSize) {
                this.writer.write(32);
                object = this.namespaces[n];
                String string3 = this.namespaces[n + 1];
                if (!string3.equals("http://www.w3.org/XML/1998/namespace")) {
                    if (((String)object).equals("")) {
                        this.writeAttribute(string, "xmlns", "CDATA", string3);
                    } else {
                        this.writeAttribute(string, "xmlns:" + (String)object, "CDATA", string3);
                    }
                }
                n += 2;
            }
            if (this.nsStackTop >= this.namespaceStack.length) {
                object = new int[this.nsStackTop * 2];
                System.arraycopy(this.namespaceStack, 0, object, 0, this.nsStackTop);
                this.namespaceStack = (int[])object;
            }
            this.namespaceStack[this.nsStackTop++] = this.nsCount;
            this.nsCount = 0;
            int n2 = 0;
            while (n2 < attributeCollection.getLength()) {
                this.writer.write(32);
                this.writeAttribute(string, attributeCollection.getExpandedName(n2).getDisplayName(), attributeCollection.getType(n2), attributeCollection.getValue(n2));
                ++n2;
            }
            this.openStartTag = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void closeStartTag(String string, boolean bl) throws SAXException {
        try {
            if (this.openStartTag) {
                if (bl) {
                    this.writer.write(this.emptyElementTagCloser(string));
                } else {
                    this.writer.write(62);
                }
                this.openStartTag = false;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected String emptyElementTagCloser(String string) {
        return "/>";
    }

    protected void writeAttribute(String string, String string2, String string3, String string4) throws SAXException {
        try {
            this.testCharacters(string2);
            this.writer.write(string2);
            this.writer.write("=\"");
            int n = string4.length();
            if (n > this.attbuff1.length) {
                this.attbuff1 = new char[n];
            }
            string4.getChars(0, n, this.attbuff1, 0);
            if (string3 == "NO-ESC") {
                this.writer.write(this.attbuff1, 0, n);
            } else {
                this.writeEscape(this.attbuff1, 0, n, true);
            }
            this.writer.write(34);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void testCharacters(String string) throws SAXException {
        int n = string.length() - 1;
        while (n >= 0) {
            if (!this.characterSet.inCharset(string.charAt(n))) {
                throw new SAXException("Invalid character in output name (" + string + ")");
            }
            --n;
        }
    }

    protected void testCharacters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n;
        while (n3 < n2) {
            if (!this.characterSet.inCharset(cArray[n3])) {
                throw new SAXException("Invalid character in output ( &#" + cArray[n3] + "; )");
            }
            ++n3;
        }
    }

    public void endElement(Name name) throws SAXException {
        try {
            if (this.openStartTag) {
                this.closeStartTag(name.getDisplayName(), true);
            } else {
                this.writer.write("</");
                this.writer.write(name.getDisplayName());
                this.writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.unwindNamespaces();
    }

    protected void unwindNamespaces() throws SAXException {
        if (this.nsStackTop-- == 0) {
            throw new SAXException("Attempt to output end tag with no matching start tag");
        }
        int n = this.namespaceStack[this.nsStackTop];
        this.namespacesSize -= n * 2;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.openStartTag) {
                this.closeStartTag("", false);
            }
            if (!this.escaping) {
                this.testCharacters(cArray, n, n2);
                this.writer.write(cArray, n, n2);
            } else {
                this.writeEscape(cArray, n, n2, false);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (this.openStartTag) {
                this.closeStartTag("", false);
            }
            this.writer.write("<?" + string + (string2.length() > 0 ? ' ' + string2 : "") + "?>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void writeEscape(char[] cArray, int n, int n2, boolean bl) throws IOException {
        int n3 = n;
        boolean[] blArray = bl ? specialInAtt : specialInText;
        while (n3 < n + n2) {
            boolean bl2;
            int n4 = n3;
            boolean bl3 = true;
            do {
                if (!bl3 || (bl3 = false) || !true) {
                    ++n4;
                }
                if (n4 >= n + n2) break;
                if (cArray[n4] < '\u0080') {
                    if (!blArray[cArray[n4]]) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = this.characterSet.inCharset(cArray[n4]);
            } while (bl2);
            this.writer.write(cArray, n3, n4 - n3);
            if (n4 >= n + n2) {
                return;
            }
            if (cArray[n4] > '\u007f') {
                int n5;
                if (cArray[n4] >= '\ud800' && cArray[n4] <= '\udbff') {
                    n5 = (cArray[n4] - 55296) * 1024 + (cArray[n4 + 1] - 56320) + 65536;
                    ++n4;
                } else {
                    n5 = cArray[n4];
                }
                this.outputCharacterReference(n5);
            } else if (cArray[n4] == '<') {
                this.writer.write("&lt;");
            } else if (cArray[n4] == '>') {
                this.writer.write("&gt;");
            } else if (cArray[n4] == '&') {
                this.writer.write("&amp;");
            } else if (cArray[n4] == '\"') {
                this.writer.write("&#34;");
            } else if (cArray[n4] == '\n') {
                this.writer.write("&#xA;");
            }
            n3 = ++n4;
        }
    }

    protected void outputCharacterReference(int n) throws IOException {
        int n2 = 0;
        this.charref[n2++] = 38;
        this.charref[n2++] = 35;
        String string = Integer.toString(n);
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            this.charref[n2++] = string.charAt(n4);
            ++n4;
        }
        this.charref[n2++] = 59;
        this.writer.write(this.charref, 0, n2);
    }

    public void setEscaping(boolean bl) {
        this.escaping = bl;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.openStartTag) {
                this.closeStartTag("", false);
            }
            this.writer.write("<!--");
            this.writer.write(cArray, n, n2);
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void setOutputDetails(OutputDetails outputDetails) {
        this.outputDetails = outputDetails;
    }

    static {
        int n = 0;
        while (n <= 127) {
            XMLEmitter.specialInText[n] = false;
            ++n;
        }
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        int n2 = 0;
        while (n2 <= 127) {
            XMLEmitter.specialInAtt[n2] = false;
            ++n2;
        }
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
    }
}

