/*
 * file chat.h - managing chat data for both client and server
 *
 * $Id: chat.h,v 1.6 2005/02/21 18:00:24 lodott Exp $
 *
 * Program XBLAST
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef XBLAST_CHAT_H
#define XBLAST_CHAT_H

#define CHAT_LINE_SIZE 40

#include "common.h"
#include "xblast.h"
#include "event.h"

/*
 * type declarations
 */
typedef struct _xb_chat XBChat;

typedef enum {
  XBCM_Public,
  XBCM_Team,
  XBCM_Private,
  XBCM_System,
} XBChatMode;

typedef enum {
  XBCS_Created,
  XBCS_Input,
  XBCS_Inactive,
  XBCS_Sent,
  XBCS_Received,
} XBChatStatus;

/*
 * global prototypes
 */

/* init */
extern void Chat_Clear();

/* start/stop chat handling */
extern void Chat_Listen(XBBool);
extern XBBool Chat_isListening();

/* create */
extern XBChat * Chat_Create();

/* modify */
extern void Chat_Set(XBChat *chat, unsigned char fh, unsigned char fp, unsigned char th, unsigned char tp, unsigned char how, const char *txt);

/* get */
extern void Chat_Receive(XBChat *);
extern XBChat * Chat_Pop();

/* packing/unpacking */
extern size_t Chat_PackData (XBChat *chat, char **data, unsigned *iob);
extern XBChat * Chat_UnpackData (const char* data, size_t len, unsigned iob);

/* chat input */
extern void Chat_Deactivate();
extern void Chat_ActivateInput(unsigned int local);
extern void Chat_StartInput(unsigned int local);
extern void Chat_SendInput(unsigned int local);
extern void Chat_CancelInput(unsigned  int local);
extern void Chat_Backspace();
extern XBBool Chat_AddAscii(char ascii);
extern void Chat_NextTarget(unsigned int local);

/* chat events */
extern void Chat_AddEventCode(unsigned local, XBEventCode ev);
extern XBEventCode Chat_GetCurrentCode();
extern unsigned char Chat_FindCode(XBEventCode);
extern XBBool Chat_Event(XBEventCode, XBEventData);

#endif
/*
 * end of file chat.h
 */
