//
// $Id: weight_R.pov,v 1.1 1999/03/27 07:28:18 xblast Exp $
// $Log: weight_R.pov,v $
// Revision 1.1  1999/03/27 07:28:18  xblast
// Initial revision
//
//
#include "BLGeneric.inc"

#declare weightPart1 =
intersection {
  superellipsoid {
    <0.33,0.33>
    matrix <1.00, 0.00, 0.00,
            0.33, 1.00, 0.50
	    0.00, 0.00, 1.00,
	    0.00, 0.00, 0.00>	     
  }
  plane { x,0.01}
  plane { z,0.01}
}

#declare weightPart2 =
intersection {
  superellipsoid {
    <0.33,0.33>
    matrix <1.00, 0.00, 0.00,
            0.50, 1.00, 0.33
	    0.00, 0.00, 1.00,
	    0.00, 0.00, 0.00>	     
  }
  plane { x,0.01}
  plane { z,0.01}
}


difference {
  union {
    #declare winkel=0
    #while (winkel < 360)
      object {weightPart1 rotate y*winkel}
      object {weightPart2 rotate y*(winkel+90)}
      #declare winkel=winkel+180
    #end
    translate <0,1,0>
    scale <1.667,0.833,1.5>
    translate <0,0,-0.333>
    pigment {color Green}
    finish {myShiny}
  }
  text {
    ttf "arialbd.ttf"
    "100 t"
    1, 0
    matrix <1, 0, 0,
            0, 1, 0.50,
            0, 0, 1,
            0, 0, 0>
    scale 1.0
    translate <-1,0.5,-2.2>
    pigment {color Red}
  }
  scale <1,0.5,1>
}

torus {
  0.475, 0.175
  sturm
  rotate x*90
  translate <0,0.79167,-0.1667>
  pigment {color Red}
  finish {myShiny}
}

