
/*
	Copyright (C) 1995	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include <stdio.h>
#include <stdarg.h> 
#include <sys/types.h>
#include <string.h>
#include "xi.h"

extern void SORTFUNC(void *base, size_t nmemb, size_t size,
              int (*compar)(const void *, const void *));


FILE *fr, *fw;
int lineno;

void p_err(char *fmt,...)
{
  va_list args;

  va_start(args, fmt);
  vfprintf(stderr, fmt, args);
  va_end(args);
  fprintf(stderr,"\n");
  exit(-1);
}

char *skip_spc(char *s)
{
	while ((*s==' ' || *s=='\t') && *s) s++;
	return s;
}

char *to_spc(char *s)
{
	while (*s!=' ' && *s!='\t' && *s) s++;
	return s;
}

void del_nl_spc(char *s)
{
	char *t;

	int len=strlen(s);
	if (!*s) return;
	t=s+len-1;
	while ( (*t=='\n' || *t==' ' || *t=='\t' )&& s<t) t--;
	*(t+1)=0;
}


void get_line(u_char *tt)
{
	while (!feof(fr)) {
		fgets(tt,128,fr);
		lineno++;
		if (tt[0]=='#') continue;
		else break;
	}
}

void cmd_arg(u_char *s, u_char **cmd, u_char **arg)
{
	char *t;

	get_line(s);
	if (!*s) { *cmd=*arg=s; return; }

	s=skip_spc(s);
	t=to_spc(s);
	*cmd=s;
	if (!(*t)) {
		*arg=t;
		return;
	}
	*t=0;
	t++;
	t=skip_spc(t);
	del_nl_spc(t);
	*arg=t;
}

int sequ(char *s, char *t)
{
	return (!strcmp(s,t));
}

#define mtolower(ch) (ch>='A'&&ch<='Z'?ch+0x20:ch)

typedef struct {
        u_char pin_eng[7];
        u_char pin_pho[3];
} PIN_PHO;

PIN_PHO pp[5000];

char *ph_pho[]={
"  tuvwxyz{|}~", /* 5 */
"  ",                                     /* 2 */
"  ",                 /* 4 */
"  "                                    /* 3 */
};

void set_pin( u_char *a, u_char *b)
{

  int i;
  char *j;
  u_char c[3];

  bzero( a , 3 );

  c[2] = 0;

  while ( *b ) {

     c[0] = *b++;
     c[1] = *b++;

     for( i = 0; i <= 3; i++ ) {

	if ( ( j = strstr( ph_pho[i], c ) ) ) {

	  a[i] = ( j - ph_pho[i] ) >> 1;

	}
     }

  }

}

int qcmp( a, b )
  PIN_PHO *a, *b;
{

  if ( !strcmp( a->pin_eng, b->pin_eng ) ) {
	printf("Error: \"%s\" is duplicated!!!\n", a->pin_eng);
	exit(1);
  }
  return strcmp( a->pin_eng, b->pin_eng);

}

void main(int argc, char **argv)
{
  int chno = 0;
  char tt[128];
  u_char *cmd, *arg;

  if ( argc != 2 ) {
	printf("\npin2tsin ----- transfer Roman to Phonetic\n");
	printf("\n       Usage: pin2tsin file\n\n");
	exit(1);
	}

  if ((fr=fopen(argv[1],"r"))==NULL ) 
	p_err("Cannot open \n");

  while ( !feof(fr) ) {
      cmd_arg(tt, &cmd, &arg);
      if (!(*cmd) || !(*arg) ) {
	   continue;
      }

      strcpy( pp[chno].pin_eng, cmd );

      set_pin( pp[chno].pin_pho, arg );

      chno++;

  }

  SORTFUNC(pp,chno,sizeof(PIN_PHO),qcmp);


  if ( ( fw = fopen( "tsin_pin.map" , "w" ) ) == NULL ) {
	p_err("can not create file");
  }

  fwrite( &chno, 4, 1, fw );
  fwrite( pp, 10, chno, fw);

  fclose( fw );
  fclose( fr );

}
