
#ifndef __FILE_SPEC_LIST_H__
#define __FILE_SPEC_LIST_H__

#include "CEgFileSpec.h"
#include "AbstractStrList.h"

// Designed to represent a list of file specs.
class FileSpecList : public AbstractStrList {

public:
	FileSpecList( XStrListOptsT inOption, bool inIgnoreExtensions = false );
	virtual ~FileSpecList();

	// Makes a private copy of the given spec and inserts it into this list.  The number
	// returned is what element the spec now is in this list (1-based indexing)
	long			AddCopy( const CEgFileSpec& inSpec );
	void			AddCopies( const FileSpecList& inList );

	// Get access to the certain spec
	const CEgFileSpec*	FetchSpec( int inIndex ) const										{ return (CEgFileSpec*) mItems.Fetch( inIndex );	}

	// Fills this list with ever file spec in the given folder
	void			ScanFolder( CEgFileSpec& inFolder );

	// Fills this list with ever folder spec that's in the given folder
	void			SubScanFolder( CEgFileSpec& inFolder );

	// See AbstractStrAccess.h
	virtual const UtilStr*	Fetch( long inIndex ) const;

protected:
	bool			mIgnoreExtns;

	static int		sSpecComparitor( const void* inA, const void* inB, const void* inThis );

	virtual void		DeleteItem( void* inPtr )											{ delete (CEgFileSpec*) inPtr;						}
};

#endif // __FILE_SPEC_LIST_H__
