/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SDL_HANDLERS_H__
#define __SDL_HANDLERS_H__

#include <glib.h>

#include "singit/sound_precalcs.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

gboolean sdl_handler_init(void);

void sdl_handler_finish(void);

void sdl_handler_key_down(void *pEvent);

void sdl_handler_resize(void *pEvent);

void sdl_handler_active(void *pEvent);


void displayer_sdl_render();

void displayer_sdl_render_pcm(gint16 pcm_data[2][512], SingitSoundPrecalcs *ssp);

void displayer_sdl_render_freq(gint16 freq_data[2][256], SingitSoundPrecalcs *ssp);

void displayer_sdl_draw_text();

void displayer_sdl_new_song_signal(gchar *title, gchar* artist);

void displayer_sdl_set_active_song_line(gchar *line);

SDL_Color getPaletteColor(const gint index);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __SDL_HANDLERS_H__
