/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_PLUGIN_H__
#define __DISPLAYER_PLUGIN_H__

#include <glib.h>

#include <singit/song.h>
#include <singit/sound_precalcs.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _DisplayerPlugin
{
	// * Filled in by SingIt plugin *
	void *handle;             // Set to NULL
	char *filename;           // Set to NULL
	int   singit_session;     // Set to 0
	int   xmms_session;       // Set to 0

	// * Call this with a pointer to your plugin struct to disable the plugin *
	void (*disable)(struct _DisplayerPlugin *); // Set to NULL

	const char *description;  // * The description that is shown in the preferences box *

	void (*init)(void);    // * Called when the displayer enabled *
	void (*finish)(void);  // * Called before the plugin is disabled *

	// * Called when the global plugin configuration has been updated *
	void (*update)(void);

	// * Called when the song has / lyrics have changed
	void (*set_song)(SingitSong*);

	// * Called by the main thread with the current song and time *
	void (*set_time)(guint, GList *);

	void (*about)(void);           // * Show the plugin about box *
	void (*configure)(void);       // * Show the plugin configure box *

	void (*playback_start)(void);  // * Called when playback starts *
	void (*playback_stop)(void);   // * Called when playback stops *

	// * Render the PCM data, don't do anything time consuming in here - directly from xmms *
	void (*render_pcm)(gint16 pcm_data[2][512], SingitSoundPrecalcs *ssp);
	// * Render the freq data, don't do anything time consuming in here - directly from xmms *
	void (*render_freq)(gint16 freq_data[2][256], SingitSoundPrecalcs *ssp);
}
DisplayerPlugin;

void enable_plugin(gint plugin);

// This macro defines the entry point for the libloader
// It _must_ be used after the DisplayerPlugin struct definition
#define DIPSPLAYER_SYMBOL(libname, plugin_struct) \
	DisplayerPlugin* libname##_LTX_get_dplugin_info(void); \
	DisplayerPlugin* libname##_LTX_get_dplugin_info(void) \
	{ \
		return &plugin_struct; \
	}

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DISPLAYER_PLUGIN_H__
