/* $Header: /fridge/cvs/xscorch/sgtk/sgtk.h,v 1.23 2004/02/26 06:34:55 justins Exp $ */
/*

   xscorch - sgtk.h           Copyright(c) 2000-2003 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Generic GTK header


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, version 2 of the License ONLY.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sgtk_h_included
#define __sgtk_h_included


/* This file implies xscorch.h. */
#include <xscorch.h>


#if GTK12_ENABLED
   /* Coercion macros and types */
   #define  GTK_CLASS_TYPE(klass)   ((klass)->type)
   #define  G_OBJECT(obj)           (GTK_OBJECT((obj)))
   #define  GType                   GtkType

   /* GObject interface */   
   #define  g_object_new(type, x)   (gtk_type_new((type)))
   #define  g_object_get_data       gtk_object_get_data
   #define  g_object_set_data       gtk_object_set_data
   #define  g_object_unref          gtk_object_unref

   /* GSignal interface */
   #define  g_signal_emit_by_name   gtk_signal_emit_by_name
   #define  g_signal_stop_emission_by_name \
                                    gtk_signal_emit_stop_by_name

   /* GDK interface changes */
   #define  gdk_drawable_get_size   gdk_window_get_size
   #define  gdk_draw_drawable       gdk_draw_pixmap

   /* GTK widget changes */
   #define  gtk_widget_set_size_request \
                                    gtk_widget_set_usize
   #define  gtk_spin_button_get_value \
                                    gtk_spin_button_get_value_as_float
#else /* GTK 2.0 */
   #ifndef __ALLOW_DEPRECATED_GDK__
      /* For reasons beyond my comprehension, they deprecated this in 2.0 */
      #define gdk_color_black(cmap, color) \
         do {                              \
            (color)->red   = 0;            \
            (color)->green = 0;            \
            (color)->blue  = 0;            \
            gdk_colormap_alloc_color((cmap), (color), FALSE, TRUE); \
         } while(0)
   #endif /* __ALLOW_DEPRECATED_GDK__ undefined? */
#endif /* GTK 1.2? */


/* Debugging constants */
#define  SC_GTK_DEBUG_GTK              0
#define  SC_GTK_DEBUG_PAINT            0


/* Disable deprecated GTK 2.0 interfaces, if applicable */
#if GTK20_ENABLED && !defined(__ALLOW_DEPRECATED_GTK__)
   #define  GTK_DISABLE_DEPRECATED
#endif
#if GTK20_ENABLED && !defined(__ALLOW_DEPRECATED_GDK__)
   #define  GDK_DISABLE_DEPRECATED
#endif


#endif /* __sgtk_h_included */

