/**
 * A client-side 802.1x implementation supporting EAP
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Chris Hessing & Terry Simons
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * EAPSIM Header
 *
 * File: eapaka.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

/*******************************************************************
 *
 * The development of the EAP/AKA support was funded by Internet
 * Foundation Austria (http://www.nic.at/ipa)
 *
 *******************************************************************/

#ifndef _EAP_AKA_H_
#define _EAP_AKA_H_

#define EAP_TYPE_AKA   23

#ifdef EAP_SIM_ENABLE

// These are defined in section 8 of Arkko-12
// EAP-AKA Subtype values.
#define AKA_CHALLENGE             1
#define AKA_AUTHENTICATION_REJECT 2
#define AKA_SYNC_FAILURE          4
#define AKA_IDENTITY              5
#define AKA_NOTIFICATION         12
#define AKA_REAUTHENTICATION     13
#define AKA_CLIENT_ERROR         14

// EAP-AKA Subtype Attribute values
#define AT_RAND               1
#define AT_AUTN               2
#define AT_RES                3
#define AT_AUTS               4
#define AT_PADDING            6
#define AT_PERMANENT_ID_REQ  10
#define AT_MAC               11
#define AT_NOTIFICATION      12
#define AT_ANY_ID_REQ        13
#define AT_IDENTITY          14
#define AT_FULLAUTH_ID_REQ   17
#define AT_COUNTER           19
#define AT_COUNTER_TOO_SMALL 20
#define AT_NONCE_S           21
#define AT_CLIENT_ERROR_CODE 22

#define AT_IV               129
#define AT_ENCR_DATA        130
#define AT_NEXT_PSEUDONYM   132
#define AT_NEXT_REAUTH_ID   133
#define AT_CHECKCODE        134
#define AT_RESULT_IND       135

// These are values that can be returned by AT_NOTIFICATION
// These are defined in 7.19.
#define GENERAL_FAILURE_POST_AUTH       0
#define GENERAL_FAILURE_PRE_AUTH    16384
#define USER_AUTHENTICATED          32768
#define USER_DENIED                  1026
#define USER_NO_SUBSCRIPTION         1031

struct aka_eaptypedata {
  int numrands;
  char *nonce_mt;
  char random_num[16];
  char autn[16];
  char K_encr[16], K_aut[16], msk[8], emsk[8];
  char *keyingMaterial;
  SCARDCONTEXT scntx;
  SCARDHANDLE shdl;
  char card_mode;
  char *readers;
};  

// Get the IMSI as the username.
int eapaka_get_username(struct interface_data *);

// Initalizes Function for EAPOL package
int eapaka_setup(struct generic_eap_data *);

// Function to handle packets and manage state.
int eapaka_process(struct generic_eap_data *, u_char *, int, u_char *, int *);

// Return keying material.
int eapaka_get_keys(struct interface_data *);

//Clean up after ourselves.
int eapaka_cleanup(struct generic_eap_data *);

int eapaka_failed(struct generic_eap_data *);

#endif
#endif
