/*
	       Message values for YIFF Configuration Wizard
 */

#ifndef YCMESSAGES_H
#define YCMESSAGES_H


/*
 *	On welcome page:
 */

#define YC_MESG_NAR_WELCOME1	"\
All configuration\n\
values for YIFF can\n\
be set up using\n\
this program."

#define YC_MESG_NAR_WELCOME2	"\
You can use this\n\
program at any time\n\
to reconfigure the\n\
YIFF Sound Server\n\
easilly and\n\
effectivly."


/* Big heading size 1 welcome title. */
#define YC_MESG_WELCOME1	"\
Configuration Wizard"

#define YC_MESG_WELCOME1_ALT	"\
Welcome to the\n\
YIFF Configuration Wizard"

/* Details about this program. */
#define YC_MESG_WELCOME2	"\
This program will help you set up the configuration files\n\
that YIFF depends on to run properly. Make sure that you\n\
have the YIFF Sound Server properly installed before using\n\
this program to configure it."

/* Where to learn more about this program. */
#define YC_MESG_WELCOME3	"\
To learn more about configuring the YIFF Sound Server,\n\
please visit the official YIFF home page at:"

/* URL of the official YIFF home page mentioned in the previous
 * message.
 */
#define YC_MESG_WELCOME4	"http://wolfpack.twu.net/YIFF"

/* Getting started. */
#define YC_MESG_WELCOME5	"\
Click on 'Next' to begin configuring the YIFF Sound Server or\n\
'Exit' to exit the YIFF Configuration Wizard."


/*
 *	On locations page:
 */

#define YC_MESG_NAR_LOCATIONS1		"\
You may specify\n\
alternative path\n\
values if you have\n\
any YIFF compoent\n\
installed in a\n\
different location."

#define YC_MESG_NAR_LOCATIONS2		"\
Unchecking\n\
'start YIFF' will\n\
let you continue\n\
configuring without\n\
starting/connecting\n\
to the Y server,\n\
helpful if you are\n\
having problems\n\
with the Y server"


#define YC_MESG_LOCATIONS1		"Locations"
#define YC_MESG_LOCATIONS2		"\
These values specify the locations of various resources which\n\
the YIFF Sound Server needs to interact with in order to run\n\
properly."

#define YC_PROMPT_LABEL_CONFIGURATION_FILE	"Configuration File:"
#define YC_TIP_MESG_CONFIGURATION_FILE		"\
Full path to the YIFF Sound Server configuration \
file. Default value is \"/usr/etc/yiffrc\""

#define YC_PROMPT_LABEL_YIFF_PROGRAM		"YIFF Program:"
#define YC_TIP_MESG_YIFF_PROGRAM		"\
Full path to the YIFF Sound Server program \
file. Default value is \"/usr/sbin/yiff\""

#define YC_PROMPT_LABEL_DSP_DEVICE		"DSP Device:"
#define YC_TIP_MESG_DSP_DEVICE			"\
Digital Sample Device (DSP) that you want YIFF to \
use for this configuration. Alternative values can \
be \"/dev/dsp2\", \"/dev/dsp3\", \"/dev/audio\", etc. Use \
\"/dev/dsp\" if you are not sure"

#define YC_PROMPT_LABEL_MIXER_DEVICE		"Mixer Device:"
#define YC_TIP_MESG_MIXER_DEVICE		"\
Mixer Device that you want YIFF to use for this \
configuration. If you have no mixer then leave \
this value blank"

#define YC_PROMPT_LABEL_ADDRESS			"Address:"
#define YC_TIP_MESG_ADDRESS			"\
Address YIFF Configuration Wizard will use to connect \
to the YIFF Sound Server. Default value would be \
\"localhost\" or \"127.0.0.1\""

#define YC_PROMPT_LABEL_PORT			"Port:"
#define YC_TIP_MESG_PORT			"\
Port number that the YIFF Sound Server will be \
listening on and Y client programs to connect to. \
Default value is \"9433\""

#define YC_CHECK_LABEL_YIFF_START		"Start YIFF"
#define YC_TIP_MESG_YIFF_START			"\
Uncheck this if you do not want YIFF running \
during this configuration. Otherwise YIFF \
will be started (as needed) when you click on \"Next\""


/*
 *	On Y Audio Modes page:
 */
#define YC_MESG_NAR_YMODES1	"\
Y client programs\n\
depend on properly\n\
defined Y Audio\n\
Modes for correct\n\
Audio settings."

#define YC_MESG_NAR_YMODES2	"\
If you hear rapid\n\
'clicks' or gaps\n\
then reduce the\n\
cycle interval."

#define YC_MESG_NAR_YMODES3	"\
A cycle interval\n\
too small will cause\n\
gradual overflowing\n\
and delays in new\n\
sound playing."


#define YC_LIST_lABEL_YMODES		"Preset Y Audio Modes"

#define YC_COMBO_LABEL_SAMPLE_RATE	"Sample Rate:"
#define YC_TIP_MESG_SAMPLE_RATE		"\
Sample rate in Hz, this specifies the number of \
DSP samples to play per cycle"

#define YC_COMBO_LABEL_FRAGMENT_SIZE	"Fragment Size:"
#define YC_TIP_MESG_FRAGMENT_SIZE	"\
Sound buffer length in bytes, needs to be a 2^n value"

#define YC_TIP_MESG_CHANNELS1		"\
Set number of channels to 1 (mono)"
#define YC_TIP_MESG_CHANNELS2		"\
Set number of channels to 2 (stereo)"

#define YC_TIP_MESG_SAMPLE_SIZE8	"\
Set size of each sample to 8 bits (1 byte)"
#define YC_TIP_MESG_SAMPLE_SIZE16	"\
Set size of each sample to 16 bits (2 bytes)"

#define YC_SPIN_LABEL_CYCLE		"Cycle:"
#define YC_TIP_MESG_CYCLE		"\
Cycle interval in microseconds (us), reduce \
value if you hear 'clicks' or increase if too \
much delay playing a new sound object. Use \
'calculate' to find initial trial value. Cycle \
is automatically updated on the Y server, no \
need to click on 'apply'"

#define YC_BUTTON_LABEL_CALCULATE_CYCLE	"Calculate"
#define YC_TIP_MESG_CYCLE_CALCULATE	"\
Calculates theoretical cycle interval and updates \
the cycle value. Calculated cycle value may need \
to be manually adjusted"

#define YC_BUTTON_LABEL_APPLY_TO_YIFF	"Apply Values To Y Server"
#define YC_TIP_MESG_APPLY_TO_YIFF	"\
Applies current Y Audio Mode values to Y Sound \
Server. Note cycle value is always applied when \
it is changes."

#define YC_BUTTON_LABEL_PLAY		"Play"
#define YC_TIP_MESG_PLAY		"\
Map file browser to select a DSP sound object to be played. \
Playing sound helps contrast 'gaps', 'clicks' and delays \
when trying to fine tune the best possible cycle interval."


/*
 *	On timings page:
 */
#define YC_MESG_TIMINGS1		"Timings"
#define YC_MESG_TIMINGS2		"\
These values specify the intervals at which the YIFF\n\
Sound Server should update/refresh/reclaim its managed\n\
resources."

#define YC_SPIN_LABEL_REFRESH_INT	"Refresh Interval:"
#define YC_TIP_MESG_REFRESH_INT		"\
Refresh interval in microseconds (us), this is the \
interval in which the Y Sound is (re)synced and other \
resources are reclaimed and refreshed. Default \
value is \"30000000\" (30 seconds)"


/*
 *	On MIDI page:
 */
#define YC_MESG_NAR_MIDI1		"\
Try each MIDI\n\
player in a\n\
separate prompt\n\
right now to\n\
find out which\n\
one works. Make\n\
sure that the\n\
Y server is not\n\
currently playing\n\
any MIDI."


#define YC_MESG_MIDI1			"MIDI"
#define YC_MESG_MIDI2			"\
YIFF uses common OSS and ALSA implmentations of MIDI which\n\
are still experimental and under development. For that an\n\
external MIDI player program specific to OSS or ALSA is\n\
used to play MIDI sound objects."
#define YC_MESG_MIDI3			"\
OSS users should use \"/usr/bin/drvmidi\" or \"/usr/bin/playmidi\"\n\
and ALSA users should use \"/usr/bin/pmidi\"."

#define YC_PROMPT_LABEL_MIDI_PLAY_CMD	"MIDI Play Command:"
#define YC_TIP_MESG_MIDI_PLAY_CMD	"\
Command used to run the MIDI player for OSS or ALSA \
Include any required arguments, the token string \"%f\" will \
be replaced with the full path to the MIDI sound object"

#define YC_PROMPT_LABEL_ALSA_MIDI_PORT	"ALSA MIDI Port:"
#define YC_TIP_MESG_ALSA_MIDI_PORT	"\
ALSA MIDI device port number (only required if using \
a ALSA and an ALSA specific MIDI player program). Default \
value is \"0\""


/*
 *	On Y Sound Paths page:
 */
#define YC_MESG_NAR_YSOUNDPATHS1	"\
Paths are searched\n\
through from first\n\
to last."

#define YC_MESG_NAR_YSOUNDPATHS2	"\
You can shift the\n\
order in which path\n\
is searched for\n\
with the up and\n\
down arrow buttons."



#define YC_MESG_YSOUNDPATHS1		"Y Sound Paths"
#define YC_MESG_YSOUNDPATHS2		"\
The Y server will search through each path specified in\n\
this list when given a relative path of a sound object to\n\
be played."


/*
 *	On confermation page:
 */
#define YC_MESG_NAR_CONFERM1		"\
If you see any\n\
mistakes you can\n\
always go 'Back'\n\
and fix them."

#define YC_MESG_CONFERMATION1		"Review Configuration"
#define YC_MESG_CONFERMATION2		"\
Take a moment to look over the values set below, these values\n\
will be saved to the YIFF Sound Server configuration file when\n\
you click on 'Finish'."

#define YC_CHECK_LABEL_CONFERMATION_VERBOSE	"Verbose Listing"
#define YC_TIP_MESG_CONFERMATION_VERBOSE	"\
Check this to display configuration parameters verbosly, \
or uncheck to display parameters as actual names \
saved to file"


#define YC_PROMPT_LABEL_START_SCRIPT	"Start Script:"
#define YC_TIP_MESG_START_SCRIPT	"\
YIFF start script that will be generated to easilly \
start the YIFF Sound Server, leave this value blank \
if you do not want a start script or you have written \
your own."


#endif	/* YCMESSAGES_H */
