#!/usr/bin/perl

# This script makes a bidi mirroring map.
# In order to run the script you need to get
#  http://www.unicode.org/Public/UNIDATA/BidiMirroring.txt
# as an input.

@full_date = localtime(time);
$year = $full_date[5] + 1900;
$mon = $full_date[4] + 1;
$mday = $full_date[3];
$date = sprintf ("%4d-%02d-%02d", $year, $mon, $mday);

print <<EOD;
#
# generated by $0 $date
# 
# from http://www.unicode.org/Public/UNIDATA/BidiMirroring.txt 
#

EOD

while (<>)
{
  next if not /^([0-9A-F]*); ([0-9A-F]*)( #.*)?/;
  $char = hex $1; $mirror = hex $2;
  next if ($char > 0xffff);
  printf ("0x%04X 0x%04X$/", $char, $mirror);
}

print "$/#END$/";
