






AC_DEFUN(ar_WITH_LIB_ZLIB,
[

AC_ARG_WITH(zlib-prefix, AC_HELP_STRING([--with-zlib-prefix],
	                                [ZLIB installation prefix]), 
	    [zlib_prefix="$withval"], [zlib_prefix=""])

ac_orig_LIBS="$LIBS" 
ac_orig_CPPFLAGS="$CPPFLAGS"

zlib_lib_prefix=""
zlib_inc_prefix=""

ZLIB_CFLAGS=""
ZLIB_LIBS=""

if test x$zlib_prefix != x ; then

  zlib_lib_prefix="$zlib_prefix/lib"
  ZLIB_LIBS="-L$zlib_lib_prefix"

  zlib_inc_prefix="$zlib_prefix/include"
  ZLIB_CFLAGS="-I$zlib_inc_prefix"

fi

ZLIB_LIBS="$ZLIB_LIBS "

CPPFLAGS="$ac_orig_CPPFLAGS $ZLIB_CFLAGS"
LIBS="$ac_orig_LIBS $ZLIB_LIBS"

AC_CHECK_HEADER(zlib.h, [header_found=1], [header_found=0])
if test "$header_found" = 1; then
  for lib in z; do
    AC_CHECK_LIB($lib, gzopen, [ZLIB_LIBS="$ZLIB_LIBS -l$lib"], [ZLIB_LIBS=""])
    if test -n "$ZLIB_LIBS"; then break; fi
  done
else
  ZLIB_LIBS=""
fi
if test "$ZLIB_LIBS" != ""; then
  ifelse($1,, true, $1)
else
  ifelse($2,, true, $2)
fi

LIBS="$ac_orig_LIBS"
CPPFLAGS="$ac_orig_CPPFLAGS"
])


AC_DEFUN(ar_WITH_LIB_GDBM,
[

AC_ARG_WITH(gdbm-prefix, AC_HELP_STRING([--with-gdbm-prefix],
	                                [GDBM installation prefix]), 
	    [gdbm_prefix="$withval"], [gdbm_prefix=""])

ac_orig_LIBS="$LIBS" 
ac_orig_CPPFLAGS="$CPPFLAGS"

gdbm_lib_prefix=""
gdbm_inc_prefix=""

GDBM_CFLAGS=""
GDBM_LIBS=""

if test x$gdbm_prefix != x ; then

  gdbm_lib_prefix="$gdbm_prefix/lib"
  GDBM_LIBS="-L$gdbm_lib_prefix"

  gdbm_inc_prefix="$gdbm_prefix/include"
  GDBM_CFLAGS="-I$gdbm_inc_prefix"

fi

GDBM_LIBS="$GDBM_LIBS "

CPPFLAGS="$ac_orig_CPPFLAGS $GDBM_CFLAGS"
LIBS="$ac_orig_LIBS $GDBM_LIBS"

AC_CHECK_HEADER(gdbm.h, [header_found=1], [header_found=0])
if test "$header_found" = 1; then
  for lib in gdbm; do
    AC_CHECK_LIB($lib, gdbm_open, [GDBM_LIBS="$GDBM_LIBS -l$lib"], [GDBM_LIBS=""])
    if test -n "$GDBM_LIBS"; then break; fi
  done
else
  GDBM_LIBS=""
fi
if test "$GDBM_LIBS" != ""; then
  ifelse($1,, true, $1)
else
  ifelse($2,, true, $2)
fi

LIBS="$ac_orig_LIBS"
CPPFLAGS="$ac_orig_CPPFLAGS"
])


AC_DEFUN(ar_WITH_LIB_NCURSES,
[

AC_ARG_WITH(ncurses-prefix, AC_HELP_STRING([--with-ncurses-prefix],
	                                [NCURSES installation prefix]), 
	    [ncurses_prefix="$withval"], [ncurses_prefix=""])

ac_orig_LIBS="$LIBS" 
ac_orig_CPPFLAGS="$CPPFLAGS"

ncurses_lib_prefix=""
ncurses_inc_prefix=""

NCURSES_CFLAGS=""
NCURSES_LIBS=""

if test x$ncurses_prefix != x ; then

  ncurses_lib_prefix="$ncurses_prefix/lib"
  NCURSES_LIBS="-L$ncurses_lib_prefix"

  ncurses_inc_prefix="$ncurses_prefix/include"
  NCURSES_CFLAGS="-I$ncurses_inc_prefix"

fi

NCURSES_LIBS="$NCURSES_LIBS "

CPPFLAGS="$ac_orig_CPPFLAGS $NCURSES_CFLAGS"
LIBS="$ac_orig_LIBS $NCURSES_LIBS"

AC_CHECK_HEADER(ncurses.h, [header_found=1], [header_found=0])
if test "$header_found" = 1; then
  for lib in ncurses curses; do
    AC_CHECK_LIB($lib, initscr, [NCURSES_LIBS="$NCURSES_LIBS -l$lib"], [NCURSES_LIBS=""])
    if test -n "$NCURSES_LIBS"; then break; fi
  done
else
  NCURSES_LIBS=""
fi
if test "$NCURSES_LIBS" != ""; then
  ifelse($1,, true, $1)
else
  ifelse($2,, true, $2)
fi

LIBS="$ac_orig_LIBS"
CPPFLAGS="$ac_orig_CPPFLAGS"
])


AC_DEFUN(ar_WITH_LIB_ID3LIB,
[

AC_ARG_WITH(id3lib-prefix, AC_HELP_STRING([--with-id3lib-prefix],
	                                [ID3LIB installation prefix]), 
	    [id3lib_prefix="$withval"], [id3lib_prefix=""])

ac_orig_LIBS="$LIBS" 
ac_orig_CPPFLAGS="$CPPFLAGS"

id3lib_lib_prefix=""
id3lib_inc_prefix=""

ID3LIB_CFLAGS=""
ID3LIB_LIBS=""

if test x$id3lib_prefix != x ; then

  id3lib_lib_prefix="$id3lib_prefix/lib"
  ID3LIB_LIBS="-L$id3lib_lib_prefix"

  id3lib_inc_prefix="$id3lib_prefix/include"
  ID3LIB_CFLAGS="-I$id3lib_inc_prefix"

fi

ID3LIB_LIBS="$ID3LIB_LIBS $ZLIB_LIBS"

CPPFLAGS="$ac_orig_CPPFLAGS $ID3LIB_CFLAGS"
LIBS="$ac_orig_LIBS $ID3LIB_LIBS"

AC_CHECK_HEADER(id3.h, [header_found=1], [header_found=0])
if test "$header_found" = 1; then
  for lib in id3; do
    AC_CHECK_LIB($lib, ID3Tag_AddFrame, [ID3LIB_LIBS="$ID3LIB_LIBS -l$lib"], [ID3LIB_LIBS=""])
    if test -n "$ID3LIB_LIBS"; then break; fi
  done
else
  ID3LIB_LIBS=""
fi
if test "$ID3LIB_LIBS" != ""; then
  ifelse($1,, true, $1)
else
  ifelse($2,, true, $2)
fi

LIBS="$ac_orig_LIBS"
CPPFLAGS="$ac_orig_CPPFLAGS"
])


AC_DEFUN(ar_WITH_LIB_MUSICBRAINZ,
[

AC_ARG_WITH(musicbrainz-prefix, AC_HELP_STRING([--with-musicbrainz-prefix],
	                                [MUSICBRAINZ installation prefix]), 
	    [musicbrainz_prefix="$withval"], [musicbrainz_prefix=""])

ac_orig_LIBS="$LIBS" 
ac_orig_CPPFLAGS="$CPPFLAGS"

musicbrainz_lib_prefix=""
musicbrainz_inc_prefix=""

MUSICBRAINZ_CFLAGS=""
MUSICBRAINZ_LIBS=""

if test x$musicbrainz_prefix != x ; then

  musicbrainz_lib_prefix="$musicbrainz_prefix/lib"
  MUSICBRAINZ_LIBS="-L$musicbrainz_lib_prefix"

  musicbrainz_inc_prefix="$musicbrainz_prefix/include"
  MUSICBRAINZ_CFLAGS="-I$musicbrainz_inc_prefix"

fi

MUSICBRAINZ_LIBS="$MUSICBRAINZ_LIBS $ZLIB_LIBS"

CPPFLAGS="$ac_orig_CPPFLAGS $MUSICBRAINZ_CFLAGS"
LIBS="$ac_orig_LIBS $MUSICBRAINZ_LIBS"

AC_CHECK_HEADER(musicbrainz/mb_c.h, [header_found=1], [header_found=0])
if test "$header_found" = 1; then
  for lib in musicbrainz; do
    AC_CHECK_LIB($lib, mb_GetVersion, [MUSICBRAINZ_LIBS="$MUSICBRAINZ_LIBS -l$lib"], [MUSICBRAINZ_LIBS=""])
    if test -n "$MUSICBRAINZ_LIBS"; then break; fi
  done
else
  MUSICBRAINZ_LIBS=""
fi
if test "$MUSICBRAINZ_LIBS" != ""; then
  ifelse($1,, true, $1)
else
  ifelse($2,, true, $2)
fi

LIBS="$ac_orig_LIBS"
CPPFLAGS="$ac_orig_CPPFLAGS"
])

