#import <Foundation/Foundation.h>
#import "PreferencesTestCase.h"
#import "Preferences.h"

@implementation PreferencesTestCase : TestCase

- (void)setUp
{
	NSUserDefaults *defaults;

	// zap all prefs
	defaults = [NSUserDefaults standardUserDefaults];
	[defaults removePersistentDomainForName:@"Zipper"];
	[defaults synchronize];
	// also remove all replacement preferences that might have been set from previous test cases
	[Preferences usePreferences:nil];
}

- (void)testUnsetPref
{
	// setUp zaps all existing prefs
	[self assertNil:[[NSUserDefaults standardUserDefaults] objectForKey:PREF_KEY_TAR]];
}

- (void)testFindInPath
{
	NSString *tar;
	
	// currently, all tests run in the same instance. This is unlike JUnit, however. In order
	// to get this desired behaviour we call setUp here for now.
	[self setUp];
	
	tar = [Preferences tarExecutable];
	[self assert:tar equals:@"/bin/tar"];
}

- (void)testReplacementPrefs
{
	NSDictionary *dict;
	NSString *dummyTar;

	// currently, all tests run in the same instance. This is unlike JUnit, however. In order
	// to get this desired behaviour we call setUp here for now.
	[self setUp];
		
	dummyTar = @"/foo/bar/baz/tar";
	dict = [NSDictionary dictionaryWithObject:dummyTar forKey:PREF_KEY_TAR];
	[Preferences usePreferences:dict];
	
	[self assert:[Preferences tarExecutable] equals:dummyTar];
}

- (void)testPrefsFromPlist
{
	// currently, all tests run in the same instance. This is unlike JUnit, however. In order
	// to get this desired behaviour we call setUp here for now.
	[self setUp];

	[self assert:[Preferences zipExecutable] equals:@"/plist/zip"];
}

@end
