##############################################################################
#
# Copyright (c) 2003 - Emergence by Design Inc. - All Rights Reserved
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  USA.
#
##############################################################################

from Shared.DC.ZRDB.DA import DA
from Shared.DC.ZRDB.Aqueduct import parse
try: from IOBTree import Bucket
except: Bucket=lambda:{}


class RoutableSqlMethod(DA):
    """
    
    This code is a modified version of some of the code found in:

      zope_instance/lib/python/Shared/DC/ZRDB/DA.py

    and, as such, the original code is Copyright (c) Zope Corporation (tm),
    and is covered by:

      the Zope Public License Version 2.0
            
    hereafter referred to as the ZPL2. A copy of the ZPL2 has been
    included with this product, in the form of a file called:

      LICENSE_ZPL2.txt

    located within the root of this product directory.
      
    """

    def __init__(self, id, title, arguments, template):
        self.id=str(id)
        self.manage_edit(title, arguments, template)

    def manage_edit(self,title,arguments,template,
                    SUBMIT='Change',sql_pref__cols='50', sql_pref__rows='20',
                    REQUEST=None):
        "a modified copy of lib/python/Shared/DC/ZRDB/DA.py"

        if self._size_changes.has_key(SUBMIT):
            return self._er(title,connection_id,arguments,template,
                            SUBMIT,sql_pref__cols,sql_pref__rows,REQUEST)

        if self.wl_isLocked():
            raise ResourceLockedError, 'SQL Method is locked via WebDAV'

        self.title=str(title)
        arguments=str(arguments)
        self.arguments_src=arguments
        self._arg=parse(arguments)
        template=str(template)
        self.src=template
        self.template=t=self.template_class(template)
        t.cook()
        self._v_cache={}, Bucket()
        if REQUEST:
            if SUBMIT=='Change and Test':
                return self.manage_testForm(REQUEST)
            message='ZSQL Method content changed'
            return self.manage_main(self, REQUEST, manage_tabs_message=message)
        return ''

