# Copyright (C) 1997-2001 by Dr. Dieter Maurer <dieter@hit.handshake.de>
# D-66386 St. Ingbert, Eichendorffstr. 23, Germany
#
#			All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and
# modified copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation.
# 
# Dieter Maurer DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL Dieter Maurer
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
# DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
"""Function auxiliaries"""

import types, string

# copied from Python header file
CO_OPTIMIZED = 0x0001
CO_NEWLOCALS = 0x0002
CO_VARARGS = 0x0004
CO_VARKEYWORDS = 0x0008

def func_props(f,detail='a',name=None):
  """returns a string describing the function, method or class *f*

  *detail* controls how much properties are included:
    ''		only the functions name
    'a'		includes the functions arguments
    'd'	        the functions first line of documentation
    'D'		includes the functions complete documentation
    several options can be concatenated"""
  (n,a,d)= func_prop_tuple(f)
  if name is None: name= n
  args= 'a' in detail and '(' + string.join(a,',') + ')' or ''
  doc= ''
  if d:
    if 'D' in detail: doc= '\n  ' + d
    elif 'd' in detail: doc= ': ' + d
  return name + args + doc


def func_prop_tuple(f):
  name=f.__name__
  doc=f.__doc__
  t=type(f)
  if t is types.MethodType: f= f.im_func
  elif t is types.ClassType:
    try:
      f= f.__init__.im_func
      if f.__doc__: doc=f.__doc__
    except: f= _emptyfunc
  c=f.func_code
  n=c.co_argcount
  a=list(c.co_varnames[:n])
  if f.func_defaults:
    i=n-len(f.func_defaults)
    for d in f.func_defaults:
      a[i]= a[i] + '=' + repr(d)
      i= i+1
  if c.co_flags & CO_VARARGS:
    a.append('*' + c.co_varnames[n])
    n= n+1
  if c.co_flags & CO_VARKEYWORDS:
    a.append('**' + c.co_varnames[n])
    n= n+1
  if t is types.ClassType: del(a[0])
  return (name, a, doc)
    
def _emptyfunc(self): pass    
