"""
$RCSfile: IXSLTProcessor.py,v $

This class encapsulates an XSLT Processor for use by ZopeXMLMethods.
IXSLTProcessor is the Interface implemented by a processor library.
Any processor can be used, as long as an adaptor class is written that
conforms to this interface.

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.0
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 03:45:47 $'[6:-2]
__version__ = '$Revision: 1.9 $'[10:-2]

# Zope Base Classes
from Interface import Base

################################################################
# IXSLTProcessor interface
################################################################

class IXSLTProcessor(Base):
    """

    ZopeXMLMethods XSLT Processor public interface

    """

    def transform(xmlString, xmlURL, xsltString, xsltURL,
                  transformObject = None, REQUEST = None): """

        Transforms the passed in XML into the required output (usually
        HTML) using the passed in XSLT.  Both the XML and XSLT strings
        should be well-formed.  Returns the output as a string.
        transformObject and REQUEST params may be used to acquire Zope
        content such as XSLT parameters and URN namespaces, if
        required.

        This method should never raise an exception.  Instead, it
        should write an error message to sys.stderr and return an
        empty string.  The idea is that web site users will at worst
        see an empty page.

        This method calls transformGuts to actually perform the
        transformation.

        """

    def addParam(paramMap, name, value):
        """

        This is a convenience function for producing the appropriate
        object to pass for the 'params' parameter in transformGuts.
        Pass in a python map plus the parameter name and value.  Since
        each processor has a unique way of creating its parameter map,
        this function abstracts that away so, for example, the unit
        tests can be generic.
        
        """
                      
    def transformGuts(xmlString, xmlURL, xsltString, xsltURL,
                      transformObject = None, params = None,
                      REQUEST = None):
        """
        
        This method actually performs the transformation.  If anything
        goes wrong, it raises an Exception.  This exception should be
        caught by transform() and turned into a message that gets sent
        to stderr by all implementations.  transformGuts is used
        primarily for the test harness.

        """

    def setDebugLevel(level):
        """

        Set debug level from 0 to 3.
        0 = silent
        3 = extra verbose
        Debug messages go to Zope server log.

        """
