##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class ZipAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    Zip file abstraction
    """
    
    icon_file = "zip.gif"
    small_icon_file = "zip_small.gif"
    content_types = ('application/zip',
                     'application/x-tar',
                     'application/sit',
                     'application/x-stuffit',
                     'application/x-gtar',
                     'application/gtar',
                     'application/tar',
                     'application/gz',
                     'application/tgz',
                     'application/x-zip-compressed',
                     'application/x-gzip',
                     'application/x-gzip-compressed',
                     'application/x-rar-compressed',
                    )
                    
    index_list = ()


    def isPreviewAvailable(self,):
        return 0


    def convertPreview(self,):
        return None


    def indexAttachment(self):
        """
        indexAttachment(self) => nothing
        No indexing is done on zip files
        """
        raise RuntimeError, "Unable to index this"


ZAttachmentRegistry.AttachmentRegistry.registerClass(ZipAttachment, globals())

