###################################################################################################
# zmsobject.py
#
# $Id: zmsobject.py,v 1.9 2004/02/24 19:57:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.9 $
#
# Implementation of class ZMSObject (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile, Persistent
from DateTime.DateTime import DateTime
from Acquisition import Implicit
from OFS.Folder import Folder
import AccessControl.Role
import urllib
import time
import string 
# Product Imports.
import zmscontainerobject
import _accessmanager
import _blobfields
import _cachemanager
import _copysupport
import _exportable 
import _globals
import _language
import _metacmdmanager
import _metapatternmanager
import _objattrs
import _objchildren
import _objinputs
import _objtypes
import _versionmanager
import _workflowmanager
import _xmllib
import _textformatmanager
import _zcatalogmanager
import _zmsattributecontainer
import _zmsglobals
import _zreferableitem


###################################################################################################
###################################################################################################
###
###   abstract class ZMSObject:
###
###   This is the abstract base class for all ZMS-Objects.
###
###################################################################################################
###################################################################################################
class ZMSObject(
        Folder,					# Folder.
	Persistent,                     	# Persistent. 
	Implicit,                       	# Acquisition. 
	AccessControl.Role.RoleManager, 	# Security manager. 
	_accessmanager.AccessableObject,	# Access manager.
	_language.Language,             	# Multilinguality.
	_versionmanager.VersionManager,		# Version manager.
	_copysupport.CopySupport,		# Copy Support (Paste Objects).
	_cachemanager.CacheableObject,		# Cacheable object.
	_metacmdmanager.MetacmdObject,	        # Meta-Commandable object.
	_metapatternmanager.MetapatternObject,	# Meta-Patternizable object.
	_exportable.Exportable,			# XML Export.
	_objattrs.ObjAttrs,			# Object-Attributes.
	_objchildren.ObjChildren,		# Object-Children.
	_objinputs.ObjInputs,			# Object-Inputs.
	_objtypes.ObjTypes,			# Object-Types.
        _textformatmanager.TextFormatObject,    # Text-Formats.
	_zcatalogmanager.ZCatalogItem,		# ZCatalog Item.
	_zmsglobals.ZMSGlobals,			# ZMS Global Functions and Definitions.
	_zreferableitem.ZReferableItem		# ZReferable Item.
	): 

    # Documentation string.
    __doc__ = """ZMS product module."""
    # Version string. 
    __version__ = '0.1' 
    
    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
		'manage_dtpref', 'manage_page_header', 'manage_page_footer', 'manage_tabs', 'manage_tabs_sub', 'manage_bodyTop', 
		'manage_UndoVersionForm', 'manage_UndoVersion', 
		'manage_changeTextProperties', 
		)
    __administratorPermissions__ = (
		)
    __viewPermissions__ = (
		'manage_menu',
		)
    __ac_permissions__=(
		('ZMS Administrator', __administratorPermissions__),
		('ZMS Author', __authorPermissions__),
		('View', __viewPermissions__),
		)

    # Properties.
    # -----------
    QUOT = chr(34)
    MISC_ZMS = '/misc_/zms/'
    banner_gif = '/misc_/zms/banner.gif'
    spacer_gif = '/misc_/zms/spacer.gif'

    # Templates.
    # ----------
    manage = HTMLFile('dtml/object/manage', globals())
    manage_workspace = HTMLFile('dtml/object/manage', globals()) # ZMI Manage
    manage_menu = HTMLFile('dtml/object/manage_menu', globals()) # ZMI Menu
    manage_wait = HTMLFile('dtml/object/manage_wait', globals()) # ZMI Wait
    manage_tabs = HTMLFile('dtml/object/manage_tabs', globals()) # ZMI Tabulators
    manage_tabs_sub = HTMLFile('dtml/object/manage_tabs_sub', globals()) # ZMI Tabulators (Sub)
    manage_bodyTop = HTMLFile('dtml/object/manage_bodytop', globals()) # ZMI bodyTop
    manage_page_header = HTMLFile('dtml/object/manage_page_header', globals()) # ZMI Page Header
    manage_page_footer = HTMLFile('dtml/object/manage_page_footer', globals()) # ZMI Page Footer
    f_recordset_grid = HTMLFile('dtml/object/f_recordset_grid', globals()) # ZMI RecordSet::Grid
    f_recordset_nav = HTMLFile('dtml/object/f_recordset_nav', globals()) # ZMI RecordSet::Navigation
    f_headline = HTMLFile('dtml/object/f_headline', globals()) # ZMI Headline
    f_breadcrumbs = HTMLFile('dtml/object/f_breadcrumbs', globals()) # ZMI Breadcrumbs
    f_css_sys = HTMLFile('dtml/object/f_css_sys', globals()) # CSS: Fixed System StyleSheet
    f_css_printhtml = HTMLFile('dtml/object/f_css_printhtml', globals()) # CSS: Fixed PrintHTML StyleSheet
    f_submitInputFields = HTMLFile('dtml/object/f_submitinputfields', globals())
    f_submitBtn = HTMLFile('dtml/object/f_submitbtn', globals())
    f_submitHrefForm = HTMLFile('dtml/object/f_submithrefform', globals())
    f_collectionBtn = HTMLFile('dtml/object/f_collectionbtn', globals())
    f_languages = HTMLFile('dtml/object/f_languages', globals())
    f_kalender = HTMLFile('dtml/object/f_kalender', globals()) 
    f_frame = HTMLFile('dtml/object/f_frame', globals()) 
    f_frame_top = HTMLFile('dtml/object/f_frame_top', globals()) 
    f_frame_bottom = HTMLFile('dtml/object/f_frame_bottom', globals()) 
    f_bo_area = HTMLFile('dtml/object/f_bo_area', globals()) 
    f_eo_area = HTMLFile('dtml/object/f_eo_area', globals()) 
    f_open_input_html = HTMLFile('dtml/object/f_open_input', globals()) 
    doi = HTMLFile('dtml/object/doi', globals()) 
    preview_html = HTMLFile('dtml/object/preview', globals()) 
    preview_top_html = HTMLFile('dtml/object/preview_top', globals()) 
    active_input_fields = '' # Deprecated
    version_input_fields = '' # Deprecated

    # JavaScript.
    # -----------
    comlib_js = HTMLFile('dtml/javascript/comlib', globals()) # Common Functions
    formlib_js = HTMLFile('dtml/javascript/formlib', globals()) # Form-Functions
    datelib_js = HTMLFile('dtml/javascript/datelib', globals()) # Date-Functions
    fieldlib_js = HTMLFile('dtml/javascript/fieldlib', globals()) # Input-Functions
    managelib_js = HTMLFile('dtml/javascript/managelib', globals()) # Manage-Functions


    ###############################################################################################
    #  ZMSObject.__init__: 
    #
    #  Constructor (initialise a new instance of ZMSObject).
    ###############################################################################################
    def __init__(self, id='', sort_id=0): 
      """ ZMSObject.__init__ """
      self.id = id
      self.sort_id = _globals.format_sort_id(sort_id)


    # ------------------------------------------------------------------------------------------
    #  ZMSObject.get_logo:
    # ------------------------------------------------------------------------------------------
    get_logo__roles__ = None
    def get_logo(self, REQUEST, RESPONSE):
      """ ZMS.get_logo """
      v = self.logo
      try:
        v = v.data
      except:
        v = v.index_html(REQUEST,RESPONSE)
      return v


    # ------------------------------------------------------------------------------------------
    #  ZMSObject.get_conf_blob:
    # ------------------------------------------------------------------------------------------
    get_conf_blob__roles__ = None
    def get_conf_blob(self, path, REQUEST, RESPONSE):
      """ ZMS.get_conf_blob """
      v = self.__get_attr_conf_dict__()
      try:
        for id in path.split('/'):
          if type(v) is type({}):
            v = v[id]
          elif type(v) is type([]):
            if id in v:
              v = v[v.index(id)+1]
            else:
              v = filter(lambda x: x.get('id',None)==id, v)[0]
        v = v.getData()
      except:
        masterId = self.getConfProperty('Portal.Master','')
	if len(masterId) > 0:
          masterHome = getattr(self.getHome(),masterId)
          masterDocElmnt = masterHome.objectValues(['ZMS'])[0]
	  v = masterDocElmnt.get_conf_blob(path, REQUEST, RESPONSE)
      return v


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.isMetaType:
    # -------------------------------------------------------------------------------------------------
    def isMetaType(self, meta_type, REQUEST={}):
      if meta_type is None:
        return 1
      if type(meta_type) is not type([]):
        meta_type = [meta_type]
      b = self.meta_type in meta_type
      if not b:
        if self.PAGES in meta_type:
          b = b or self.isPage()
        elif self.PAGEELEMENTS in meta_type:
          b = b or self.isPageElement()
      return b


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.isPage:
    # -------------------------------------------------------------------------------------------------
    def isPage(self): 
      return 0


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.isPageElement:
    # -------------------------------------------------------------------------------------------------
    def isPageElement(self): 
      return 0


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.isResource
    # -------------------------------------------------------------------------------------------------
    def isResource(self, REQUEST):
      return self.getObjProperty('attr_dc_type',REQUEST) == 'Resource'


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.isTranslated
    #
    #  Returns 1 if current object is translated to given language.
    # -------------------------------------------------------------------------------------------------
    def isTranslated(self, lang, REQUEST):
      req = {'lang':lang,'preview':REQUEST.get('preview','')}
      value = self.getObjProperty('change_uid',req)
      translated = value is not None and len(value) > 0
      return translated


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.isModifiedInParentLanguage
    #
    #  Returns 1 if current object is modified in parent language.
    # -------------------------------------------------------------------------------------------------
    def isModifiedInParentLanguage(self, lang, REQUEST):
      b = 0
      parent = self.getParentLanguage(lang)
      if parent is not None:
        req = {'lang':lang, 'preview':REQUEST.get('preview','') }
        change_dt_lang = self.getObjProperty('change_dt',req)
        req = {'lang':parent, 'preview':REQUEST.get('preview','') }
        change_dt_parent = self.getObjProperty('change_dt',req)
        try:
          b = _globals.compareDate(change_dt_lang, change_dt_parent) >= 0
        except:
          _globals.writeException(self,"[isModifiedInParentLanguage]: Unexpected exception: change_dt_lang=%s, change_dt_parent=%s!"%(str(change_dt_lang),str(change_dt_parent)))
      return b


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.isVisible:
    #
    #  Returns 1 if current object is visible.
    # ---------------------------------------------------------------------------------------------
    def isVisible(self, REQUEST):
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      visible = 1
      visible = visible and self.isTranslated(lang,REQUEST) # Object is translated.
      visible = visible and self.isCommitted(REQUEST) # Object has been committed.
      visible = visible and self.isActive(REQUEST) # Object is active.
      visible = visible or self.meta_type == 'ZMSCustom' and self.getType()=='ZMSRecordSet'
      return visible


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.get_size
    # ---------------------------------------------------------------------------------------------
    def get_size(self, REQUEST):
      size = 0
      obj_attrs = self.getObjAttrs() 
      for key in obj_attrs.keys():
        size = size + _globals.get_size(self.getObjProperty(key,REQUEST))
      return size


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getDCCoverage
    # ---------------------------------------------------------------------------------------------
    def getDCCoverage(self, REQUEST={}):
      key = 'attr_dc_coverage'
      obj = self.getObjVersion(REQUEST)
      value = getattr(obj,key,'') # Take a performant shortcut to get object-property.
      if value == '': value = 'global.'+self.getPrimaryLanguage()
      return value


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getDCDescription
    # ---------------------------------------------------------------------------------------------
    def getDCDescription(self, REQUEST):
      return self.getObjProperty('attr_dc_description',REQUEST)


    # -------------------------------------------------------------------------------------------------
    #  ZMSObject.getSelf:
    # -------------------------------------------------------------------------------------------------
    def getSelf(self, meta_type=None):
      ob = self
      if meta_type is not None and not ob.isMetaType(meta_type):
        parent = ob.getParentNode()
        if parent is not None:
          ob = parent.getSelf(meta_type)
      return ob


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.display_icon:
    # ---------------------------------------------------------------------------------------------
    def display_icon(self, REQUEST, meta_type=None):
      if meta_type is None:
        if self.isActive(REQUEST):
          return self.icon
        else:
          return self.icon_disabled
      else:
        if not self.dGlobalAttrs.has_key(meta_type):
          meta_type = 'ZMSCustom'
        return self.dGlobalAttrs[meta_type]['icon']


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.display_type:
    # ---------------------------------------------------------------------------------------------
    def display_type(self, REQUEST={}, meta_type=None):
      meta_type = _globals.nvl(meta_type,self.meta_type)
      try:
        if meta_type == 'ZMSCustom':
          meta_type = self.meta_id
        if meta_type in self.getMetaobjIds():
          return self.getMetaobj(meta_type)['name']
      except:
        pass
      return self.getLangStr("TYPE_%s"%meta_type.upper(),REQUEST.get('manage_lang','eng'))


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.breadcrumbs_obj_path:
    # ---------------------------------------------------------------------------------------------
    def breadcrumbs_obj_path(self):
      REQUEST = self.REQUEST
      # Handle This.
      rtn = []
      obj = self
      for lvl in range(self.getLevel()+1):
        obj_item = [obj]
        obj_item.extend(rtn)
        rtn = obj_item
        obj = obj.aq_parent
      # Handle Include recursively.
      if REQUEST.get('URL','').find('/manage') < 0:
        included = 0
        ob = self.getDocumentElement()
        inc = [ob]
        for id in REQUEST.get('ZMS_OBJECT_IDS',[]):
          ob = getattr(ob, id, None)
          if ob is None: break
	  if getattr(ob,'meta_type',None) in self.dGlobalAttrs.keys() and ob not in inc: 
            inc.append(ob)
          if ob.meta_type == 'ZMSLinkElement' and ob.isEmbedded(REQUEST):
            ref_obj = ob.getRefObj()
            if ref_obj is not None and ref_obj.isAnchestor(self):
              ob = ref_obj
              for id in self.absolute_url()[len(ref_obj.absolute_url()):].split('/')[:-1]:
                if len(id) > 0:
                  ob = getattr(ob, id, None)
		  if ob is None: break
                  if getattr(ob,'meta_type',None) in self.dGlobalAttrs.keys() and ob not in inc: 
                    inc.append(ob)
              rtn = inc
      # Handle Portal Master.
      if self.getConfProperty('Portal.Master',''):
        try:
          thisHome = self.getHome()
          masterHome = getattr(thisHome,self.getConfProperty('Portal.Master',''))
          masterDocElmnt = masterHome.objectValues(['ZMS'])[0]
          obj_item = masterDocElmnt.breadcrumbs_obj_path()
          obj_item.extend(rtn)
          rtn = obj_item
        except:
	  _globals.writeError(self,"[breadcrumbs_obj_path]: An unexpected error occured while handling portal master!")
      return rtn


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.absolute_obj_path:
    # ---------------------------------------------------------------------------------------------
    def absolute_obj_path(self):
      ob = self.getDocumentElement()
      return '%s/%s/'%(ob.aq_parent.id,self.absolute_url()[len(ob.aq_parent.absolute_url())+1:])


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.relative_obj_path:
    # ---------------------------------------------------------------------------------------------
    def relative_obj_path(self):
      return self.absolute_url()[len(self.getDocumentElement().absolute_url())+1:]


    """
    ###############################################################################################
    ###  
    ###  C o m m o n   F u n c t i o n s
    ### 
    ###############################################################################################
    """    
    
    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.recurse_updateVersion:
    #
    #	Update version.
    # ---------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST): 
      #++ print "[%s.recurse_updateVersion] %s"%(self.meta_type,self.absolute_url())
      message = ''
      
      # Process object.
      # [...]
      
      # ---------------------------------------------------------------------
      # 07.01.2003 Build <#110
      # Prepare for version management.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '110':
        if hasattr(self,'__work_version__'):
          req = {'lang':'*'}
          liveAttrCntnr = _zmsattributecontainer.manage_addZMSAttributeContainer(self)
          self.cloneObjAttrs(self,liveAttrCntnr,req)
          self.version_live_id = liveAttrCntnr.id
          workAttrCntnr = _zmsattributecontainer.manage_addZMSAttributeContainer(self)
          self.cloneObjAttrs(self.__work_version__,workAttrCntnr,req)
          self.version_work_id = workAttrCntnr.id
          try: delattr(self,'__work_version__')
          except: pass
      
      # ---------------------------------------------------------------------
      # 27.08.2002 Build #096
      # Correct type for DC.Coverage.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '096':
        key = 'attr_dc_coverage'
        default = 'proposal'
        if key in self.getObjAttrs().keys():
          for ob in self.getObjVersions():
            value = getattr(ob,'attr_dc_coverage',default)
            if type(value) is type([]):
              if len(value) > 0:
                value = value[0]
              else:
                value = default
              setattr(ob,'attr_dc_coverage',value)
              
      # ---------------------------------------------------------------------
      # 29.08.2002 Build #099
      # Correct Auto-Commit bug.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '099':
        if hasattr(self,'__work_version__'):
          if self.getAutocommit(): self.cloneObjAttrs(self.__work_version__,self,REQUEST)
          self.onChangeObj(REQUEST)

      # ---------------------------------------------------------------------
      # 28.02.2003 Build #114
      # DC.Coverage.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '114':
        for ob in self.getObjVersions():
          ob_coverage = str(getattr(ob,'attr_dc_coverage',''))
          if ob_coverage == 'obligation':
            for key in ['active','attr_active_start','attr_active_end']:
              req = {'lang':self.getPrimaryLanguage()}
              v = ob.getObjProperty(key,req)
              for lang in self.getLangIds():
                if lang != self.getPrimaryLanguage():
                  req = {'lang':lang}
                  ob.setObjProperty(key,v,lang)
          if ob_coverage.find('global.')<0 and ob_coverage.find('local.')<0:
            if ob_coverage in [None,'','proposal','obligation']: ob_coverage = 'global.'+self.getPrimaryLanguage()
            else: ob_coverage = 'global.'+ob_coverage
            setattr(ob,'attr_dc_coverage',ob_coverage)

      # ---------------------------------------------------------------------
      # 21.03.2003 Build #116
      # Change-UID.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '116':
        if self.getAutocommit():
          key = 'change_uid'
          for lang in self.getLangIds():
            req = {'lang':lang,'preview':'preview'}
            o_work = self.getObjVersion(req)
            v_work = o_work.getObjProperty(key,req)
            req = {'lang':lang}
            o_live = self.getObjVersion(req)
            v_live = o_live.getObjProperty(key,req)
            if v_work is not None and v_live is None:
              setattr(o_live,'%s_%s'%(key,lang),v_work)

      # ---------------------------------------------------------------------
      #  Synchronization.
      # ---------------------------------------------------------------------
      ##### Synchronizes DTML-Methods for Blob-fields ####
      _blobfields.synchronizeBlobFields(self)
      ##### Synchronizes references TO other objects ####
      self.synchronizeRefToObjs()  
      ##### Synchronizes references FROM other objects ####
      self.synchronizeRefByObjs()  
      
      # Return with message.
      return message


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.getDoiPath:
    # ---------------------------------------------------------------------------------------------
    def getDoiPath(self, REQUEST):
      rtn = ''
      # This.
      obj = self
      for lvl in range(self.getLevel()+1):
        if 'attr_dc_identifier_doi' in obj.getObjAttrs().keys():
          if len(rtn) > 0: rtn = '/' + rtn
          rtn = obj.getObjProperty('attr_dc_identifier_doi',REQUEST) + rtn
        obj = obj.aq_parent
      # Portal Master.
      if self.getConfProperty('Portal.Master',''):
        try:
          thisHome = self.getHome()
          masterHome = getattr(thisHome,self.getConfProperty('Portal.Master',''))
          masterDocElmnt = masterHome.objectValues(['ZMS'])[0]
          if len(rtn) > 0: rtn = '/' + rtn
          rtn = masterDocElmnt.getDoiPath(REQUEST) + rtn
        except:
          pass
      return rtn


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.findFilteredTreeNodes:
    # ---------------------------------------------------------------------------------------------
    def findFilteredTreeNodes(self, REQUEST, meta_types, values=[], order_by=None, order_dir='asc', max_len=None):
      nodes = []
      if len(values) > 0:
        append = 1
        append = append and self.isMetaType(meta_types)
        append = append and self.isVisible(REQUEST)
        obj_attrs = self.getObjAttrs()
        for i in range(len(values)/2):
          key = values[i*2]
          value = values[i*2+1]
          if key == 'getDoiPath':
            alias_path = self.getDoiPath(REQUEST)
            append = append and len(alias_path)>=len(value) and alias_path[-len(value):]==value
          elif key in obj_attrs.keys():
            v = self.getObjProperty(key,REQUEST)
            if type(v) is type([]):
              append = append and value in v
            else:
              append = append and value == v
          else:
            try:
              append = append and hasattr(self,key) and getattr(self,key)()==value
            except:
              try:
                append = append and hasattr(self,key) and getattr(self,key)(REQUEST)==value
              except:
                append = append and hasattr(self,key) and getattr(self,key)==value
        if append: 
          nodes.append(self)
        for child in self.getChildNodes(REQUEST):
          nodes.extend(child.findFilteredTreeNodes(REQUEST,meta_types,values))
      return nodes


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.findObjId:
    #
    #	Searches for Object identified by ID and returns the absolute URL of it.
    # ---------------------------------------------------------------------------------------------
    def findObjId(self, relative_obj_path, REQUEST={}):
      docElmnt = self.getDocumentElement()
      rtn = docElmnt
      if len(relative_obj_path) > 0:
        # Find object by ids given in object path.
        ids = relative_obj_path.split('/')
        for id in ids:
          rtn = getattr(rtn,id,None)
          if rtn is None: 
            rtn = _globals.findObjId(docElmnt,ids[-1])
            break
      # Return object.
      return rtn


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.getDeclId:
    #
    #	Returns declarative id.
    # ---------------------------------------------------------------------------------------------
    def getDeclId(self, REQUEST={}):
       declId = self.getObjProperty('attr_dc_identifier_url_node',REQUEST)
       if len(declId)==0:
         declId = self.getTitlealt(REQUEST)
       declId = self.id_quote(declId)
       return declId


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.getDeclUrl:
    #
    #	Returns declarative url.
    # ---------------------------------------------------------------------------------------------
    def getDeclUrl(self, REQUEST={}):
      if self.getConfProperty('ZMS.pathhandler',0) == 0 or REQUEST.get('ZMS_HTML_EXPORT',0) == 1:
        url = self.absolute_url()
      else:
        ob = self.getDocumentElement()
        url = ob.absolute_url()
	for id in self.absolute_url()[len(url):].split('/'):
          if len(id) > 0:
            ob = getattr(ob,id,None)
	    if ob is None: break
	    url += '/' + ob.getDeclId(REQUEST)
      return url


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.getHref2Html:
    #	ZMSObject.getHref2IndexHtml:
    #	ZMSObject.getHref2PrintHtml:
    #	ZMSObject.getHref2SitemapHtml:
    #
    #   "Sans-Document"-Navigation: reference to first ZMSContainerObject
    #	that contains visible page-elements.
    # ---------------------------------------------------------------------------------------------
    def getHref2Html(self, fct, REQUEST):
      if not self.isPage():
        parent = self.getParentNode()
        href = parent.getHref2Html(fct,REQUEST)
        href += '#' + self.id
      else:
        href = self.getDeclUrl(REQUEST) + '/'
	# Include recursively.
	included = 0
	ob = self.getDocumentElement()
	for id in REQUEST.get('ZMS_OBJECT_IDS',[]):
          ob = getattr(ob,id,None)
	  if ob is None: break
	  if ob.meta_type == 'ZMSLinkElement' and ob.isEmbedded(REQUEST):
            ref_obj = ob.getRefObj()
	    if ref_obj is not None and ref_obj.isAnchestor(self):
              href = ob.getDeclUrl(REQUEST) + self.getDeclUrl(REQUEST)[len(ref_obj.getDeclUrl(REQUEST)):] + '/'
              break
        # Assemble href.
        href += '%s_%s.html'%(fct,REQUEST['lang'])
        if REQUEST.get('preview','')=='preview': href=self.url_append_params(href,{'preview':'preview'})
      return href
      
    #++
    def getHref2SitemapHtml(self, REQUEST): 
      if not REQUEST.has_key('lang'): REQUEST.set('lang',self.getPrimaryLanguage())
      return self.getHref2Html('sitemap',REQUEST)
      
    #++
    def getHref2PrintHtml(self, REQUEST): 
      if not REQUEST.has_key('lang'): REQUEST.set('lang',self.getPrimaryLanguage())
      href = 'index_print_%s.html'%REQUEST['lang']
      qs = REQUEST.get('QUERY_STRING','')
      if len(qs)>0: href += '?' + qs
      if REQUEST.get('preview','')=='preview': href = self.url_append_params(href,{'preview':'preview'})
      return href
    
    #++
    def getHref2IndexHtml(self, REQUEST, deep=1): 
      if not REQUEST.has_key('lang'): REQUEST.set('lang',self.getPrimaryLanguage())

      #-- [ReqBuff]: Fetch buffered value from Http-Request.
      try:
        reqBuffId = 'getHref2IndexHtml_%i'%deep
        value = self.fetchReqBuff(reqBuffId,REQUEST)
        return value
      except:
        
        #-- Get value.
        ob = self
        if deep: ob = zmscontainerobject.getPageWithElements(self,REQUEST)
        value = ob.getHref2Html('index',REQUEST)
        
        #-- [ReqBuff]: Returns value and stores it in buffer of Http-Request.
        return self.storeReqBuff(reqBuffId,value,REQUEST)

    # DEPRECATED!
    def declHref2IndexHtml(self, REQUEST, deep=1): return self.getHref2IndexHtml(REQUEST, deep=1)


    """
    ###############################################################################################    
    ###  
    ###  Object-actions of management interface
    ### 
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.filtered_edit_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_edit_actions(self, path, REQUEST):
      rtn = []
      
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      auth_user = REQUEST['AUTHENTICATED_USER']
      
      #-- ACTIONS
      actions = []
      if self.getAutocommit() or \
         self.getPrimaryLanguage() == lang or \
         self.getDCCoverage(REQUEST).find('local.')==0:
        method = 'manage_deleteObjs'
        if self.getParentByLevel(1).meta_type == 'ZMSTrashcan': 
          method = 'manage_eraseObjs'
        actions.append((self.getLangStr('BTN_DELETE',manage_lang),method,[]))
        actions.append((self.getLangStr('BTN_CUT',manage_lang),'manage_cutObjects',[]))
        actions.append((self.getLangStr('BTN_COPY',manage_lang),'manage_copyObjects',[]))
        if self.cb_dataValid():
          actions.append((self.getLangStr('BTN_PASTE',manage_lang),'manage_pasteObjs',[]))
        actions.append((self.getLangStr('ACTION_MOVEUP',manage_lang),path + 'manage_moveObjUp',[]))
        actions.append((self.getLangStr('ACTION_MOVEDOWN',manage_lang),path + 'manage_moveObjDown',[]))
        
      #-- COMMANDS
      actions.extend(self.filtered_command_actions(path,REQUEST))
      if len(actions) > 0:
        rtn.append((self.getLangStr('ACTION_SELECT',manage_lang)%self.getLangStr('ATTR_ACTION',manage_lang),'',actions))
        
      # Return action list.
      return rtn

    
    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.filtered_command_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_command_actions(self, path, REQUEST):
      actions = []
      auth_user = REQUEST['AUTHENTICATED_USER']
      for metaCmdId in self.getMetaCmdIds():
        metaCmd = self.getMetaCmd(metaCmdId)
        hasMetaType = 0
        hasMetaType = hasMetaType or (self.meta_type in metaCmd['meta_types'])
        hasMetaType = hasMetaType or (self.meta_type == 'ZMSCustom' and self.meta_id in metaCmd['meta_types'])
        hasRole = 0
        hasRole = hasRole or len(self.intersection_list(self.getUserRoles(auth_user),metaCmd['roles'])) > 0
        hasRole = hasRole or auth_user.has_role('Manager')
        if hasMetaType and hasRole:
          actions.append((metaCmd['name'],path+'manage_executeMetacmd',[]))
      # Return action list.
      return actions

    
    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.filtered_workflow_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_workflow_actions(self, path, REQUEST):
      actions = []
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      if (self.meta_type == 'ZMSCustom' or not self.isPageElement()) and 'work_uid' in self.getObjAttrs().keys():
        wfStates = self.getWfStates(REQUEST)
        auth_user = REQUEST['AUTHENTICATED_USER']
        roles = self.getUserRoles(auth_user)
        for wfTransition in self.getWfTransitions():
          if len(wfTransition.get('to',[])) > 0 and \
             len(self.intersection_list(wfStates,wfTransition.get('from',[]))) > 0 and \
	     (len(self.intersection_list(roles,wfTransition.get('performer',[]))) > 0 or \
	      auth_user.has_permission('Manager',self)):
            actions.append((wfTransition['name'],path+'manage_wfTransition',[]))
      # Return action list.
      return actions


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.filtered_child_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_child_actions(self, REQUEST):
      rtn = []

      path = self.id + '/'      
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      auth_user = REQUEST['AUTHENTICATED_USER']
      
      #-- WORKFLOW
      actions = self.filtered_workflow_actions(path,REQUEST)
      if len(actions) > 0:
        rtn.append((self.getLangStr('ATTR_CHANGES',manage_lang),'',actions))
      
      #-- ACTIONS & COMMANDS
      rtn.extend(self.filtered_edit_actions(path,REQUEST))

      #-- INSERT
      rtn.extend(self.getParentNode().filtered_insert_actions(path,REQUEST))
        
      # Return action list.
      return rtn


    """
    ###############################################################################################
    ###  
    ###  Check In / Out
    ### 
    ###############################################################################################
    """

    # Management Interface.
    # ---------------------
    checkout_overtake_html = HTMLFile('dtml/object/checkout_overtake', globals()) 
    checkout = HTMLFile('dtml/object/checkout', globals()) 


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.isCheckedOut:
    # ---------------------------------------------------------------------------------------------
    def isCheckedOut(self, REQUEST):
      return _objattrs.hasobjattr(self,'co_dat_%s'%REQUEST['lang'])

    
    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.checkIn:
    # ---------------------------------------------------------------------------------------------
    def checkIn(self, REQUEST):
      if _objattrs.hasobjattr(self,'co_dat_%s'%REQUEST['lang']): delattr(self,'co_dat_%s'%REQUEST['lang'])
      if _objattrs.hasobjattr(self,'co_uid_%s'%REQUEST['lang']): delattr(self,'co_uid_%s'%REQUEST['lang'])


    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.checkOut:
    # ---------------------------------------------------------------------------------------------
    def checkOut(self, REQUEST):
      auth_user = REQUEST['AUTHENTICATED_USER']
      if not (self.getConfProperty('ZMS.demo')==1 and not auth_user.has_permission('ZMS Administrator',self)):
        setattr(self,'co_dat_%s'%REQUEST['lang'],time.time())
        setattr(self,'co_uid_%s'%REQUEST['lang'],str(auth_user))


    """
    ###############################################################################################
    ###  
    ###  Sitemap
    ### 
    ###############################################################################################
    """

    ###############################################################################################
    #  ZMSObject.manage_dtpref: 
    #
    #  De-/Activate Document-Template preference.
    ###############################################################################################
    def manage_dtpref(self, key, lang, manage_lang, REQUEST, RESPONSE):
      """ ZMSObject.manage_dtpref """
      v = 1
      if REQUEST.has_key(key):
        v = self.boolint(not string.atoi(REQUEST[key]))
      e=(DateTime('GMT')+365).rfc822()
      RESPONSE.setCookie(key,str(v),path='/',expires=e)
      return RESPONSE.redirect('manage?lang=%s&manage_lang=%s'%(lang,manage_lang))


    """
    ###############################################################################################    
    ###  
    ###  DOM-Methoden 
    ### 
    ###############################################################################################    
    """    

    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getLevel:
    #
    #  The hierarchical level of this node.
    # ---------------------------------------------------------------------------------------------
    def getLevel(self):
      level = 0
      parent = self.getParentNode()
      while parent is not None:
        level = level + 1
        parent = parent.getParentNode()
      return level


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.isAnchestor:
    #
    #  True if self is anchestor of given object.
    # ---------------------------------------------------------------------------------------------
    def isAnchestor(self, ob):
      return string.find(ob.absolute_url() + '/', self.absolute_url() + '/' ) == 0


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getParentByDepth:
    #
    #  The parent of this node by depth. 
    # ---------------------------------------------------------------------------------------------
    def getParentByDepth(self, deep):
      rtn = self
      for i in range(deep):
        rtn = rtn.getParentNode()
      return rtn


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getParentByLevel:
    #
    #  The parent of this node by level. 
    # ---------------------------------------------------------------------------------------------
    def getParentByLevel(self, level):
      rtn = self
      while rtn.getLevel() > level:
        rtn = rtn.getParentNode()
      return rtn


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getParentNode:
    #
    #  The parent of this node. 
    #  All nodes except the root object may have a parent.
    # ---------------------------------------------------------------------------------------------
    def getParentNode(self):
      return getattr(self, 'aq_parent', None)


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getTreeNodes:
    #
    #  Returns a NodeList that contains all children of this subtree in correct order.
    #  If none, this is a empty NodeList. 
    # ---------------------------------------------------------------------------------------------
    def getTreeNodes(self, REQUEST={}, meta_types=None):
      rtn = []
      for ob in self.getChildNodes(REQUEST):
        if ob.isMetaType(meta_types): rtn.append(ob)
        rtn.extend(ob.getTreeNodes(REQUEST,meta_types))
      return rtn      


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getChildNodes:
    #
    #  Returns a NodeList that contains all children of this node, 
    #  if none, this is a empty NodeList. 
    # ---------------------------------------------------------------------------------------------
    def getChildNodes(self, REQUEST={}, meta_types=None): 
      return []


    """
    ###############################################################################################    
    ###  
    ###  Sortier-Reihenfolge
    ### 
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.setSortId:
    #
    #	Sets Sort-ID (integer).
    # ---------------------------------------------------------------------------------------------
    def setSortId(self, sort_id): 
      for obj_vers in self.getObjVersions():
        setattr(obj_vers,'sort_id',_globals.format_sort_id(sort_id))

    # ---------------------------------------------------------------------------------------------
    #	ZMSObject.getSortId:
    #
    #	Returns Sort-ID (integer).
    # ---------------------------------------------------------------------------------------------
    def getSortId(self, REQUEST): 
      s = self.getObjProperty('sort_id',REQUEST)
      try:
        sort = string.atoi(s[len(_globals.id_prefix(s)):])
      except:
        sort = 0
      return sort


    ###############################################################################################    
    # ZMSObject.manage_moveObjUp:
    #
    # Moves an Object up in sort order.
    ###############################################################################################    
    def manage_moveObjUp(self, lang, manage_lang, REQUEST, RESPONSE): 
      """ ZMSObject.manage_moveObjUp """
      parent = self.getParentNode()
      sort_id = self.getSortId(REQUEST)
      # self.setObjStateModified(REQUEST)
      self.setSortId(sort_id - 15)
      parent.normalizeSortIds(_globals.id_prefix(self.id))
      ##### VersionManager ####
      self.onChangeObj(REQUEST)
      # Return with message.
      message = self.getLangStr('MSG_MOVEDOBJUP',manage_lang)%("<i>%s</i>"%self.display_type(REQUEST))
      RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(parent.absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    ###############################################################################################    
    # ZMSObject.manage_moveObjDown:
    #
    # Moves an Object down in sort order.
    ###############################################################################################    
    def manage_moveObjDown(self, lang, manage_lang, REQUEST, RESPONSE): 
      """ ZMSObject.manage_moveObjDown """
      parent = self.getParentNode()
      sort_id = self.getSortId(REQUEST)
      # self.setObjStateModified(REQUEST)
      self.setSortId(sort_id + 15)
      parent.normalizeSortIds(_globals.id_prefix(self.id))
      ##### VersionManager ####
      self.onChangeObj(REQUEST)
      # Return with message.
      message = self.getLangStr('MSG_MOVEDOBJDOWN',manage_lang)%("<i>%s</i>"%self.display_type(REQUEST))
      RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(parent.absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    """
    ###############################################################################################    
    #
    #   Darstellung
    #
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.getBodyContent:
    #
    #  HTML presentation in BodyContent. 
    # ---------------------------------------------------------------------------------------------
    def _getBodyContent(self, REQUEST, thumbnail=0): 
      return ''
    
    def getBodyContent(self, REQUEST):
      if self.isVisible(REQUEST):
        return '<a name="%s"></a>%s'%(self.id,self._getBodyContent(REQUEST))
      return ''


    # ---------------------------------------------------------------------------------------------
    #  ZMSObject.printHtml:
    #
    #  Renders print presentation of a ContainerObject.
    # ---------------------------------------------------------------------------------------------
    def printHtml(self, level, sectionize, sectionizer, REQUEST):
      return self._getBodyContent(REQUEST)


    """
    ###############################################################################################    
    #
    #   XML-BUILDER
    #
    ###############################################################################################    
    """
    
    ###############################################################################################
    # ZMSObject.xmlOnStartElement(self, dTagName, dAttrs, oCurrNodes, oRoot):
    # ZMSObject.xmlOnCharacterData(self, data, bInCData):
    # ZMSObject.xmlOnEndElement(self):
    # ZMSObject.xmlOnUnknownStartTag(self, sTagName, dTagAttrs)
    # ZMSObject.xmlOnUnknownEndTag(self, sTagName)
    # ZMSObject.xmlGetTagName(self):
    # ZMSObject.xmlGetParent(self):
    #
    # handler for XML-Builder (_builder.py)
    ###############################################################################################
    def xmlOnStartElement(self, sTagName, dTagAttrs, oParentNode, oRoot):
        _globals.writeLog("[%s.xmlOnStartElement]: sTagName=%s"%(self.meta_type,sTagName))
        
        self.dTagStack    = _globals.MyStack()
        self.dValueStack  = _globals.MyStack()
        
	#-- ATTRIBUTES
	for i in range(len(dTagAttrs)/2):
	  key = dTagAttrs[i*2]
	  if key != 'id':
  	    value = dTagAttrs[i*2+1]
	    #++ print "[%s.xmlOnStartElement]: %s=%s"%(self.meta_type,str(key),str(value))
	    setattr(self,key,value)
        
        # WORKAROUND! The member variable "aq_parent" does not contain the right parent object at 
        # this stage of the creation process (it will later on!). Therefore, we introduce a special
        # attribute containing the parent object, which will be used by xmlGetParent() (see below).
        self.oParent = oParentNode


    def xmlOnEndElement(self): 
        pass


    def xmlOnCharacterData(self, sData, bInCData):
        return _xmllib.xmlOnCharacterData(self,sData,bInCData)


    def xmlOnUnknownStartTag(self, sTagName, dTagAttrs):
        return _xmllib.xmlOnUnknownStartTag(self,sTagName,dTagAttrs)


    def xmlOnUnknownEndTag(self, sTagName):
        return _xmllib.xmlOnUnknownEndTag(self,sTagName)


    def xmlGetParent(self):
        return self.oParent


    def xmlGetTagName(self):
        return self.meta_type

###################################################################################################
