/*
 * Decompiled with CFR 0.152.
 */
package netscape.oji;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.EmptyStackException;
import java.util.Stack;

public class JNIUtils {
    private static StubSecurityManager stubManager = new StubSecurityManager();
    private static Object js2jInfoLock = new Object();
    private static Stack js2jInfo = new Stack();

    public static Object NewLocalRef(Object object) {
        return object;
    }

    public static Object GetCurrentThread() {
        return Thread.currentThread();
    }

    public static void checkClassAccess(Class clazz) {
        JNIUtils.checkClassAccess(clazz.getName());
    }

    public static void checkClassAccess(String name) {
        int i;
        int b;
        Class[] classContext = stubManager.getCurrentClassContext();
        if (!JNIUtils.inLiveConnect(classContext)) {
            return;
        }
        String pkg = name.replace('/', '.');
        if (pkg.startsWith("[") && (b = pkg.lastIndexOf(91) + 2) > 1 && b < pkg.length()) {
            pkg = pkg.substring(b);
        }
        if ((i = pkg.lastIndexOf(46)) != -1) {
            pkg = pkg.substring(0, i);
            System.getSecurityManager().checkPackageAccess(pkg);
        }
    }

    public static void fixProtectionDomains() {
        Certificate[] certs;
        Class[] classContext = stubManager.getCurrentClassContext();
        if (!JNIUtils.inLiveConnect(classContext)) {
            return;
        }
        int topPDClassOffset = JNIUtils.getTopPDClassOffset(classContext);
        if (topPDClassOffset == -1) {
            return;
        }
        Class topPDClass = classContext[topPDClassOffset];
        ProtectionDomain topPD = JNIUtils.getClassProtectionDomain(topPDClass);
        boolean topPDHasCerts = false;
        CodeSource cs = topPD.getCodeSource();
        if (cs != null && (certs = cs.getCertificates()) != null) {
            topPDHasCerts = true;
        }
        ProtectionDomain nextPDWithCerts = null;
        ProtectionDomain nextPDWithoutCerts = null;
        for (int i = 1; i <= topPDClassOffset; ++i) {
            ProtectionDomain pd = JNIUtils.getClassProtectionDomain(classContext[i - 1]);
            if (pd == null) continue;
            boolean hasCerts = false;
            cs = pd.getCodeSource();
            if (cs != null && (certs = cs.getCertificates()) != null) {
                hasCerts = true;
            }
            if (hasCerts) {
                nextPDWithCerts = pd;
                continue;
            }
            nextPDWithoutCerts = pd;
        }
        if (topPDHasCerts) {
            if (nextPDWithoutCerts != null) {
                JNIUtils.setClassProtectionDomain(topPDClass, nextPDWithoutCerts);
                topPD = nextPDWithoutCerts;
            }
        } else if (nextPDWithCerts != null && nextPDWithoutCerts == null) {
            JNIUtils.setClassProtectionDomain(topPDClass, nextPDWithCerts);
            topPD = nextPDWithCerts;
        }
    }

    protected static boolean inLiveConnect(Class[] classContext) {
        int elements = classContext.length;
        String topClassName = classContext[elements - 1].getName().replace('/', '.');
        if (topClassName.equals("netscape.oji.LiveConnectProxy")) {
            return true;
        }
        if (!topClassName.equals("java.awt.EventDispatchThread")) {
            return false;
        }
        for (int i = 1; i <= elements; ++i) {
            String className = classContext[i - 1].getName().replace('/', '.');
            if (!className.equals("netscape.oji.LiveConnectProxy")) continue;
            return true;
        }
        return false;
    }

    protected static int getTopPDClassOffset(Class[] classContext) {
        for (int i = classContext.length - 1; i >= 0; --i) {
            ProtectionDomain pd = JNIUtils.getClassProtectionDomain(classContext[i]);
            if (pd == null) continue;
            return i;
        }
        return -1;
    }

    private static native ProtectionDomain getClassProtectionDomain(Class var0);

    private static native void setClassProtectionDomain(Class var0, ProtectionDomain var1);

    public static Object GetCurrentClassLoader() {
        return stubManager.getCurrentClassLoader();
    }

    public static Object GetObjectClassLoader(Object object) {
        return object.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PushJS2JInfo(int pluginInstance) {
        Object object = js2jInfoLock;
        synchronized (object) {
            int[] newInfo = new int[]{0};
            try {
                newInfo = (int[])js2jInfo.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            if (pluginInstance != 0) {
                newInfo[0] = pluginInstance;
            }
            js2jInfo.push(newInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PopJS2JInfo() {
        Object object = js2jInfoLock;
        synchronized (object) {
            try {
                js2jInfo.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int CurrentJS2JPluginInstance() {
        Object object = js2jInfoLock;
        synchronized (object) {
            int[] currentInfo = new int[]{0};
            try {
                currentInfo = (int[])js2jInfo.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            return currentInfo[0];
        }
    }

    static class StubSecurityManager
    extends SecurityManager {
        StubSecurityManager() {
        }

        public ClassLoader getCurrentClassLoader() {
            ClassLoader retval = null;
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Class<?>[] classContext = this.getClassContext();
            for (int i = 1; i <= classContext.length; ++i) {
                ClassLoader loader = null;
                try {
                    loader = classContext[i - 1].getClassLoader();
                }
                catch (SecurityException ex) {
                    loader = this.currentClassLoader();
                }
                if (loader == null || systemLoader.equals(loader)) continue;
                retval = loader;
                break;
            }
            return retval;
        }

        public Class[] getCurrentClassContext() {
            return this.getClassContext();
        }
    }
}

