/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2004 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GET_FORECAST_H
#define GET_FORECAST_H

#include "http_client.h"

#include "forecast.h"
#include "weather_parser.h"

/**
	\class GetForecast
	Zajmuje si pobraniem strony WWW oraz wydobyciem z niej
	informacji pogodowych.
**/
class GetForecast : public QObject
{
	Q_OBJECT
	
	private:
		QString host_;
		QString url_;
		HttpClient httpClient_;
		QTextCodec* decoder_;
		
		Forecast forecast_;
		WeatherParser parser_;
		
		QTimer* timerTimeout_;
		int timeoutCount_;
		
		PlainConfigFile* wConfig_;
		void splitUrl(const QString& url, QString& host, QString& path) const;
	
	public:
		GetForecast();
		~GetForecast();

		/**
			\return true, jeli prognoza jest ju pobrana, false, jeli zacznie by pobierana.
					Po zakoczeniu wywoany jest sygna \see finished() lub \see error()
		**/
		bool downloadForecast(const QString& configFile, const QString& locID);

		const Forecast& getForecast() { return forecast_; }
		
		enum ErrorId
		{
			Parser,
			Connection
		};
	
	public slots:
		void downloadingFinished();
		void downloadingRedirected(QString link);
		void downloadingError();
		void connectionTimeout();
	
	signals:
		void finished();
		void error( GetForecast::ErrorId err, QString url );
};

#endif // GET_FORECAST_H
