/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "anonymous_check.h"
#include "powerkadu.h"

#include "config_dialog.h"
#include "powerkadu.h"
#include "chat_manager.h"
#include "kadu.h"
#include "userlist.h"
#include "debug.h"

AnonymousCheck::AnonymousCheck(QObject *parent, const char *name)
: QObject(parent, name)
{
	kdebugf();
	ConfigDialog::addVGroupBox("PowerKadu", "PowerKadu", QT_TRANSLATE_NOOP("@default", "Infos about anonymous"));
	ConfigDialog::addCheckBox("PowerKadu", "Infos about anonymous", 
			QT_TRANSLATE_NOOP("@default", "Automaticly display infos in chat window"),
			"request_infos_about_anonymous", true, 
			QT_TRANSLATE_NOOP("@default", "Automaticly searches public directory for\n"
						      "informations about anonymous interlocutors"));
	connect(chat_manager, SIGNAL( chatCreated(const UserGroup*)), this, SLOT( onNewChatSlot(const UserGroup*) ));
	connect(gadu, SIGNAL( newSearchResults(SearchResults&, int, int) ), 
		this, SLOT( onSearchFinishedSlot(SearchResults&, int, int) ));
	kdebugf2();
}

AnonymousCheck::~AnonymousCheck()
{
	kdebugf();
	ConfigDialog::removeControl("PowerKadu", "Automaticly display infos in chat window");
	ConfigDialog::removeControl("PowerKadu", "Infos about anonymous");
	kdebugf2();
}

void AnonymousCheck::onNewChatSlot(const UserGroup *group)
{
	kdebugf();
	if(config_file.readBoolEntry("PowerKadu", "request_infos_about_anonymous", true))
		for(UserGroup::const_iterator it = group->begin(); it != group->end(); ++it)
		{
			if(!userlist->contains("Gadu", (*it).ID("Gadu"), FalseForAnonymous))
			{
				kdebugm(KDEBUG_INFO, "Dodaj: %s\n", (*it).ID("Gadu").latin1());
				groups.insert((*it).altNick(), group);
				SearchRecord record;
				record.Uin = (*it).ID("Gadu");
				gadu->searchInPubdir(record);
			}
		}
	kdebugf2();
}

void AnonymousCheck::onSearchFinishedSlot(SearchResults& searchResults, int seq, int lastUin)
{
	kdebugf();
	if(config_file.readBoolEntry("PowerKadu", "request_infos_about_anonymous", true))
		for(SearchResults::iterator it = searchResults.begin(); it != searchResults.end(); ++it)
		{
			Chat *chat = chat_manager->findChat(groups[(*it).Uin]);
			groups.remove((*it).Uin);
			if(chat)
			{
				QString infoMsgData = tr("<b>Public directory search result:</b><br>") +
						      tr("<b>Uin:</b> ") + (*it).Uin + "<br>" +
						      tr("<b>First name:</b> ") + (*it).First + "<br>" +
						      tr("<b>Nick:</b> ") + (*it).Nick + "<br>" +
						      tr("<b>Birth year:</b> ") + (*it).Born + "<br>" +
						      tr("<b>City:</b> ") + (*it).City;
				powerKadu->showPkMsg(chat, infoMsgData);
			}
		}
	kdebugf2();
}
