#ifndef GADU_IMAGES_MANAGER_H
#define GADU_IMAGES_MANAGER_H

#include <qcolor.h>
#include <qdatetime.h>
#include <qstring.h>
#include <qvaluelist.h>

#include "gadu.h"
#include "html_document.h"

class GaduImagesManager
{
	private:
		struct ImageToSend
		{
			uint32_t size;
			uint32_t crc32;
			QString file_name;
			QDateTime lastSent;
			char *data;
			ImageToSend();
		};
		QMap<QPair<uint32_t, uint32_t>, ImageToSend> ImagesToSend;//size,crc32 -> 

		struct SavedImage
		{
			uint32_t size;
			uint32_t crc32;
			QString file_name;
			SavedImage();
		};
		QValueList<SavedImage> SavedImages;

	public:
		GaduImagesManager();
		static void setBackgroundsForAnimatedImages(HtmlDocument &doc, const QColor &col);
		
		static QString loadingImageHtml(UinType uin, uint32_t size, uint32_t crc32);
		static QString imageHtml(const QString& file_name);
		void addImageToSend(const QString& file_name, uint32_t& size, uint32_t& crc32);
		void sendImage(UinType uin, uint32_t size, uint32_t crc32);

		/**
			Szuka zakolejkowanego obrazka i zwraca jego nazw pliku
			Zwraca cig pusty, jeli obrazek nie zosta w tej sesji
			zakolejkowany do wysania.
		**/
		QString getImageToSendFileName(uint32_t size, uint32_t crc32);

		/**
			Zapisuje obrazek w katalogu .gg/images.
			Zwraca pen ciek do zapisanego obrazka.
		**/
		QString saveImage(UinType sender, uint32_t size, uint32_t crc32, const QString& filename, const char* data);

		/**
			Szuka zapisanego obrazka i zwraca jego nazw pliku
			wraz ze ciek. Zwraca cig pusty, jeli obrazek
			nie zosta w tej sesji zapisany.
		**/
		QString getSavedImageFileName(uint32_t size, uint32_t crc32);

		QString replaceLoadingImages(const QString& text, UinType sender, uint32_t size, uint32_t crc32);
};

extern GaduImagesManager gadu_images_manager;

#endif
