#ifndef PENDING_MSGS_H
#define PENDING_MSGS_H

#include <qstring.h>
#include <qvaluelist.h>
#include <time.h>
#include "usergroup.h"

/**
	Klasa ta reprezentuje kolejk wiadomoci oczekujcych na odczytanie.
	Wiadomoci takie mog by przechowywane w tej klasie nawet pomidzy kolejnymi
	uruchomieniami Kadu.
	\class PendingMsgs
	\brief Kolejka oczekujcych wiadomoci.
**/
class PendingMsgs : public QObject
{
	Q_OBJECT

	public:
		/**
			Struktura reprezentujca wiadomo oczekujc w kolejce.
			\struct Element
			\brief Wiadomo oczekujc w kolejce.
		**/
		struct Element
		{
			UserListElements users; /*!< Lista uytkownikw, ktrzy nadesali t wiadomo. */
			QString proto; /*!< Nazwa protokou. */
			QString msg; /*!< Tre wiadomoci. */
			int msgclass; /*!< Klasa wiadomoci. */
			time_t time; /*!< Czas, w ktrym nadano wiadomo. */
			Element();
		};

	private:
		typedef QValueList<Element> PendingMsgsList;
		PendingMsgsList msgs;

	public:
		/**
			\fn PendingMsgs(QObject *parent=0, const char *name=0)
			Standardowy konstruktor.
			\param parent rodzic kontrolki. Domylnie 0.
			\param name nazwa kontrolki. Domylnie 0.
		**/
		PendingMsgs(QObject *parent = 0, const char *name = 0);

		/**
			\fn bool pendingMsgs(UserListElement user) const
			Sprawdza, czy w kolejce s jakie oczekujce wiadomoci dla podanego uytkownika.
			\param user uytkownik, dla ktrego naley sprawdzi kolejk.
			\return warto logiczn informujc czy w kolejce jest jaka wiadomo czy nie.
		**/
		bool pendingMsgs(UserListElement user) const;

		/**
			\fn bool pendingMsgs() const
			Sprawdza, czy w jakiejkolwiek kolejce s oczekujce wiadomoci.
			\return warto logiczn informujc czy s jaka wiadomoci czy nie.
		**/
		bool pendingMsgs() const;

		/**
			\fn int count() const
			Liczy wszystkie wiadomoci oczekujce w kolejkach.
			\return liczba oczekujcych wiadomoci.
		**/
		int count() const;

		/**
			\fn Element &operator[](int index)
			\return wiadomo z kolejki, o podanym indeksie.
		**/
		Element &operator[](int index);

	public slots:
		/**
			\fn void openMessages()
			Wywouje metod ChatManager::openPendingMsgs.
		**/
		void openMessages();

		/**
			\fn void deleteMsg(int index)
			Usuwa z kolejki wiadomo o danym indeksie.
			\param index indeks wiadomoci do usunicia.
		**/
		void deleteMsg(int index);

		/**
			\fn void addMsg(QString protocolName, UserListElements users, QString msg, int msgclass, time_t time)
			Dodaje now wiadomo do kolejki.
			\param protocolName nazwa protokou
			\param users lista uytkownikw, ktre przysay wiadomo.
			\param msg tre wiadomoci.
			\param msgclass klasa wiadomoci.
			\param time czas nadesania wiadomoci.
		**/
		void addMsg(QString protocolName, UserListElements users, QString msg, int msgclass, time_t time);

		/**
			\fn bool loadFromFile()
			Wczytuje kolejk wiadomoci z pliku. Metoda ta wywoywana jest przy starcie
			Kadu.
		**/
		bool loadFromFile();

		/**
			\fn bool loadFromFile()
			Zapisuje kolejk wiadomoci do pliku. Metoda ta wywoywana jest przy zamykaniu
			Kadu.
		**/
		void writeToFile();

	signals:
		/**
			\fn void messageFromUserAdded(UserListElement user)
			Sygna ten emitowany jest, gdy nowa wiadomo zostaa dodana do kolejki.
		**/
		void messageFromUserAdded(UserListElement user);

		/**
			\fn void messageFromUserDeleted(UserListElement user)
			Sygna ten emitowany jest, gdy wiadomo od uytkownika user zostaa usunita z kolejki.
		**/
		void messageFromUserDeleted(UserListElement user);
};

extern PendingMsgs pending;

#endif
