/***************************************************************************

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***************************************************************************/


#include <qcheckbox.h>
#include <qspinbox.h>
/**
	GUI
	wszystkie metody, ktre ustawiaj GUI
**/

void Waiting::createGUI(void)
{
// okrela na jakiej pozycji znajdzie si nowy element w menu kontekstowym
	PosInMenu = UserBox::userboxmenu->indexOf(UserBox::userboxmenu->getItem(tr("Offline to user"))); // szuka w menu "Niedostpny dla Kontaktu"
	if (PosInMenu == -1)		// jeli nie znalaz - przypisuje warto 7 - u mnie jest na takiej pozycji ;)
	{
		PosInMenu = 7;
		kdebugm(KDEBUG_WARNING, "szukanie pozycji w menu nie powiodo si - przyjmuj warto domyln...\n");
	}
	PosInMenu += 1;			// bo oszacowywa dla "Niedostpny dla..."
	
// dodaje nowy element w menu kontekstowym na licie kontaktw - na podstawie tego, co oszacowa
// nowa pozycja - po naciniciu wywoa wait4Person
	UserBox::userboxmenu->addItemAtPos(PosInMenu, "Wait4Person", tr("Wait for this person"), this, SLOT(wait4Person()));



// nowa zakadka
	ConfigDialog::addTab(QT_TRANSLATE_NOOP("@default", "Iwait4u"), "Iwait4u_tab");
	ConfigDialog::addLabel("Iwait4u", "Iwait4u", QT_TRANSLATE_NOOP("@default", "List of users, about which module should ALWAYS inform you."));
	ConfigDialog::addLabel("Iwait4u", "Iwait4u", QT_TRANSLATE_NOOP("@default", "They will be NEVER removed from the tracked list by computer."));
	ConfigDialog::addLabel("Iwait4u", "Iwait4u", QT_TRANSLATE_NOOP("@default", "You can remove them only here."));
	ConfigDialog::addLabel("Iwait4u", "Iwait4u", QT_TRANSLATE_NOOP("@default", "If you want to be informed only ONCE, use popup menu on users list in Kadu main window instead of this!"));
	
	ConfigDialog::addCheckBox("Iwait4u", "Iwait4u", QT_TRANSLATE_NOOP("@default", "Ignore busy/online status changes"), "ignore_busy", false);
	ConfigDialog::addHBox("Iwait4u", "Iwait4u", "hbox2");
	ConfigDialog::addCheckBox("Iwait4u", "hbox2", QT_TRANSLATE_NOOP("@default", "Make delay between notifies"), "make_delay", false);
	ConfigDialog::addSpinBox("Iwait4u", "hbox2", QT_TRANSLATE_NOOP("@default", "Notify once per:"), "notify_timeout", 1, 999, 1, 20);
	
	ConfigDialog::addGrid("Iwait4u", "Iwait4u", "iwait4u_listboxy", 3);

		ConfigDialog::addGrid("Iwait4u", "iwait4u_listboxy", "iwait4u_listbox1", 1);
			ConfigDialog::addLabel("Iwait4u", "iwait4u_listbox1", QT_TRANSLATE_NOOP("@default", "All users:"));
			ConfigDialog::addListBox("Iwait4u", "iwait4u_listbox1","iwait4u_available");

		ConfigDialog::addGrid("Iwait4u", "iwait4u_listboxy", "iwait4u_listbox2", 1);
			ConfigDialog::addPushButton("Iwait4u", "iwait4u_listbox2", "", "AddToNotifyList","","iwait4u_forward");
			ConfigDialog::addPushButton("Iwait4u", "iwait4u_listbox2", "", "RemoveFromNotifyList","","iwait4u_back");

		ConfigDialog::addGrid("Iwait4u", "iwait4u_listboxy", "iwait4u_listbox3", 1);
			ConfigDialog::addLabel("Iwait4u", "iwait4u_listbox3", QT_TRANSLATE_NOOP("@default", "Always wait for:"));
			ConfigDialog::addListBox("Iwait4u", "iwait4u_listbox3", "iwait4u_track");

	ConfigDialog::connectSlot("Iwait4u", "", SIGNAL(clicked()), this, SLOT(_Right(void)), "iwait4u_forward");
	ConfigDialog::connectSlot("Iwait4u", "", SIGNAL(clicked()), this, SLOT(_Left(void)), "iwait4u_back");
	ConfigDialog::connectSlot("Iwait4u", "iwait4u_available", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Right(void)));
	ConfigDialog::connectSlot("Iwait4u", "iwait4u_track", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Left(void)));

// sounds:
	ConfigDialog::addVGroupBox("Iwait4u", "Iwait4u", QT_TRANSLATE_NOOP("@default", "Sounds"));
	ConfigDialog::addCheckBox("Iwait4u", "Sounds", QT_TRANSLATE_NOOP("@default", "Use both window and sound to inform"), "use_sounds", false);
	ConfigDialog::addCheckBox("Iwait4u", "Sounds", QT_TRANSLATE_NOOP("@default", "Repeat sounds (until OK pressed)"), "repeat_sounds", false);
	ConfigDialog::addSpinBox("Iwait4u", "Sounds", QT_TRANSLATE_NOOP("@default", "Time between repeating of sound (including length of sound!), in ms"), "sounds_delay", 10, 100000, 100, 3000);
	
	ConfigDialog::addHBox("Iwait4u", "Sounds", "hbox1");
	ConfigDialog::addLineEdit("Iwait4u", "hbox1", QT_TRANSLATE_NOOP("@default", "Path to sound:"), "sound_path");
	ConfigDialog::addPushButton("Iwait4u", "hbox1", QString::null, "OpenFile", QString::null, "fileopen");


	ConfigDialog::connectSlot("Iwait4u", QT_TRANSLATE_NOOP("@default", "Make delay between notifies"), SIGNAL(toggled(bool)), this, SLOT(toggledMakeDelay(bool)));
	ConfigDialog::connectSlot("Iwait4u", QT_TRANSLATE_NOOP("@default", "Use both window and sound to inform"), SIGNAL(toggled(bool)), this, SLOT(toggledUseSounds(bool)));
	ConfigDialog::connectSlot("Iwait4u", QT_TRANSLATE_NOOP("@default", "Repeat sounds (until OK pressed)"), SIGNAL(toggled(bool)), this, SLOT(toggledRepeatSounds(bool)));
	ConfigDialog::connectSlot("Iwait4u", QString::null, SIGNAL(clicked()), this, SLOT(chooseSoundFile()), "fileopen");


	ConfigDialog::registerSlotOnCreateTab("Iwait4u", this, SLOT(onCreateConfigDialog(void)));
	ConfigDialog::registerSlotOnApplyTab("Iwait4u", this, SLOT(onApplyConfigDialog(void)));
} 

void Waiting::destroyGUI(void)
{
	ConfigDialog::disconnectSlot("Iwait4u", "", SIGNAL(clicked()), this, SLOT(_Right(void)), "iwait4u_forward");
	ConfigDialog::disconnectSlot("Iwait4u", "", SIGNAL(clicked()), this, SLOT(_Left(void)), "iwait4u_back");
	ConfigDialog::disconnectSlot("Iwait4u", "iwait4u_available", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Right(void)));
	ConfigDialog::disconnectSlot("Iwait4u", "iwait4u_track", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Left(void)));
	ConfigDialog::disconnectSlot("Iwait4u", "Repeat sounds (until OK pressed)", SIGNAL(toggled(bool)), this, SLOT(toggledRepeatSounds(bool)));
	ConfigDialog::disconnectSlot("Iwait4u", "Use both window and sound to inform", SIGNAL(toggled(bool)), this, SLOT(toggledUseSounds(bool)));
	ConfigDialog::disconnectSlot("Iwait4u", QString::null, SIGNAL(clicked()), this, SLOT(chooseSoundFile()), "fileopen");
	ConfigDialog::disconnectSlot("Iwait4u", "Make delay between notifies", SIGNAL(toggled(bool)), this, SLOT(toggledMakeDelay(bool)));

	ConfigDialog::unregisterSlotOnCreateTab("Iwait4u", this, SLOT(onCreateConfigDialog(void)));
	ConfigDialog::unregisterSlotOnApplyTab("Iwait4u", this, SLOT(onApplyConfigDialog(void)));

// sound
	ConfigDialog::removeControl("Iwait4u", "Path to sound:");
	ConfigDialog::removeControl("Iwait4u", QString::null, "fileopen");
	ConfigDialog::removeControl("Iwait4u", "hbox1");
	ConfigDialog::removeControl("Iwait4u", "Time between repeating of sound (including length of sound!), in ms");
	ConfigDialog::removeControl("Iwait4u", "Repeat sounds (until OK pressed)");
	ConfigDialog::removeControl("Iwait4u", "Use both window and sound to inform");
	ConfigDialog::removeControl("Iwait4u", "Sounds");

// lista
	ConfigDialog::removeControl("Iwait4u", "iwait4u_track");
	ConfigDialog::removeControl("Iwait4u", "Always wait for:");
	ConfigDialog::removeControl("Iwait4u", "iwait4u_listbox3");
	ConfigDialog::removeControl("Iwait4u", "", "iwait4u_back");
	ConfigDialog::removeControl("Iwait4u", "", "iwait4u_forward");
	ConfigDialog::removeControl("Iwait4u", "iwait4u_listbox2");
	ConfigDialog::removeControl("Iwait4u", "iwait4u_available");
	ConfigDialog::removeControl("Iwait4u", "All users:");
	ConfigDialog::removeControl("Iwait4u", "iwait4u_listbox1");
	ConfigDialog::removeControl("Iwait4u", "iwait4u_listboxy");
	
	ConfigDialog::removeControl("Iwait4u", "Notify once per:");
	ConfigDialog::removeControl("Iwait4u", "Make delay between notifies");
	ConfigDialog::removeControl("Iwait4u", "hbox2");
	ConfigDialog::removeControl("Iwait4u", "Ignore busy/online status changes");

	ConfigDialog::removeControl("Iwait4u", "If you want to be informed only ONCE, use popup menu on users list in Kadu main window instead of this!");
	ConfigDialog::removeControl("Iwait4u", "You can remove them only here.");
	ConfigDialog::removeControl("Iwait4u", "They will be NEVER removed from the tracked list by computer.");
	ConfigDialog::removeControl("Iwait4u", "List of users, about which module should ALWAYS inform you.");

	ConfigDialog::removeTab("Iwait4u");

// czyci menu kontekstowe
	UserBox::userboxmenu->removeItem(PosInMenu);
}



/**
	konfiguracja
**/

void Waiting::onCreateConfigDialog(void)
{
	QListBox *e_availusers= ConfigDialog::getListBox("Iwait4u", "iwait4u_available");
	QListBox *e_notifies= ConfigDialog::getListBox("Iwait4u", "iwait4u_track");
	
	CONST_FOREACH(i, *userlist)
	{
		if (!((*i) == our_user) && (*i).usesProtocol("Gadu") && !(*i).isAnonymous())	// jeli to nie jestemy my i nie jest user bez numeru
		{
			if (isAlwaysTracked((*i).ID("Gadu")))
				e_notifies->insertItem((*i).altNick());
			else
				e_availusers->insertItem((*i).altNick());
		}
	}

	e_availusers->sort();
	e_notifies->sort();
	e_availusers->setSelectionMode(QListBox::Extended);
	e_notifies->setSelectionMode(QListBox::Extended);

	ConfigDialog::getSpinBox("Iwait4u", "Time between repeating of sound (including length of sound!), in ms")->setSuffix(" ms");
	ConfigDialog::getSpinBox("Iwait4u", "Notify once per:")->setSuffix(" min");
	ConfigDialog::getSpinBox("Iwait4u", "Notify once per:")->setEnabled(config_file.readBoolEntry("Iwait4u", "make_delay", false));
	
	ConfigDialog::getCheckBox("Iwait4u", "Repeat sounds (until OK pressed)")->setEnabled(config_file.readBoolEntry("Iwait4u", "use_sounds", true));
	ConfigDialog::getLineEdit("Iwait4u", "Path to sound:")->setEnabled(config_file.readBoolEntry("Iwait4u", "use_sounds", true));
	ConfigDialog::getPushButton("Iwait4u", QString::null, "fileopen")->setEnabled(config_file.readBoolEntry("Iwait4u", "use_sounds", true));
	ConfigDialog::getSpinBox("Iwait4u", "Time between repeating of sound (including length of sound!), in ms")->setEnabled(config_file.readBoolEntry("Iwait4u", "use_sounds", true));
	if (!config_file.readBoolEntry("Iwait4u", "repeat_sounds", true))
		ConfigDialog::getSpinBox("Iwait4u", "Time between repeating of sound (including length of sound!), in ms")->setEnabled(config_file.readBoolEntry("Iwait4u", "repeat_sounds", true));
}

void Waiting::onApplyConfigDialog(void)
{
	unsigned int i;
	QListBox *e_notifies= ConfigDialog::getListBox("Iwait4u", "iwait4u_track");
	
// ALWAYS
	always_tracked.clear();

	for (i = 0; i < e_notifies->count(); ++i)
	{
		always_tracked.append(userlist->byAltNick(e_notifies->text(i)).ID("Gadu"));
	}
		
	saveAlwaysTrackedList();
}

void Waiting::_Left(void)
{
	QListBox *e_availusers= ConfigDialog::getListBox("Iwait4u", "iwait4u_available");
	QListBox *e_notifies= ConfigDialog::getListBox("Iwait4u", "iwait4u_track");
	QStringList tomove;
	unsigned int i;

	for(i=0; i<e_notifies->count(); ++i)
		if (e_notifies->isSelected(i))
			tomove+=e_notifies->text(i);

	FOREACH(elem, tomove)
	{
		e_availusers->insertItem(*elem);
		e_notifies->removeItem(e_notifies->index(e_notifies->findItem(*elem)));
	}

	e_availusers->sort();
}

void Waiting::_Right(void)
{
	QListBox *e_availusers= ConfigDialog::getListBox("Iwait4u", "iwait4u_available");
	QListBox *e_notifies= ConfigDialog::getListBox("Iwait4u", "iwait4u_track");
	QStringList tomove;
	unsigned int i;

	for(i=0; i<e_availusers->count(); ++i)
		if (e_availusers->isSelected(i))
			tomove+=e_availusers->text(i);

	FOREACH(elem, tomove)
	{
		e_notifies->insertItem(*elem);
		e_availusers->removeItem(e_availusers->index(e_availusers->findItem(*elem)));
	}

	e_notifies->sort();
}

void Waiting::toggledMakeDelay(bool toggled)
{
	ConfigDialog::getSpinBox("Iwait4u", "Notify once per:")->setEnabled(toggled);
}

void Waiting::toggledUseSounds(bool toggled)
{
	ConfigDialog::getCheckBox("Iwait4u", "Repeat sounds (until OK pressed)")->setEnabled(toggled);
	ConfigDialog::getLineEdit("Iwait4u", "Path to sound:")->setEnabled(toggled);
	ConfigDialog::getPushButton("Iwait4u", QString::null, "fileopen")->setEnabled(toggled);
	ConfigDialog::getSpinBox("Iwait4u", "Time between repeating of sound (including length of sound!), in ms")->setEnabled(toggled);
	
	if(toggled)
		ConfigDialog::getSpinBox("Iwait4u", "Time between repeating of sound (including length of sound!), in ms")->setEnabled(ConfigDialog::getCheckBox("Iwait4u", "Repeat sounds (until OK pressed)")->isChecked());
}

void Waiting::toggledRepeatSounds(bool toggled)
{
	ConfigDialog::getSpinBox("Iwait4u", "Time between repeating of sound (including length of sound!), in ms")->setEnabled(toggled);
}

void Waiting::chooseSoundFile(void)
{
	QString start=QDir::rootDirPath();
	QString p=ConfigDialog::getLineEdit("Iwait4u", "Path to sound:")->text();

	if (QFile(p).exists())
		start=p;
	
	QString s(QFileDialog::getOpenFileName( start, "Audio Files (*.wav *.au *.raw)", ConfigDialog::configdialog));
	if (s.length())
		ConfigDialog::getLineEdit("Iwait4u", "Path to sound:")->setText(s);
}


/**
	inne
**/

void Waiting::popupMenu()
{
	UserListElements users;
	UserBox *activeUserBox = UserBox::activeUserBox();
	if (activeUserBox == NULL)
		return;

	users = activeUserBox->selectedUsers();

	// Jeeli to jestemy my lub to jest kontakt SMS (bez numerka GG) - szary
	if (users.contains(our_user) || users.contains("Gadu", 0))	// uin 0 ma osoba bez numeru
		UserBox::userboxmenu->setItemEnabled(PosInMenu, false);


	FOREACH(i, users)
	{	// jeli user jest na licie ALWAYS - szary + chackbox
		if (isAlwaysTracked((*i).ID("Gadu")))
		{
			UserBox::userboxmenu->setItemEnabled(PosInMenu, false);
			UserBox::userboxmenu->setItemChecked(PosInMenu, true);
			break;				// przerywa jeli ju znalaz jednego
		} else if (isOnTrackedList((*i).ID("Gadu")))	// jeli uin jest na licie poszukiwanych - zaznacza checkbox.
		{
			UserBox::userboxmenu->setItemChecked(PosInMenu, true);
			// nie przerywa, bo jeli osoba z Tracked bya przed always, to nie zrobiby szarego
		}
	}
}
