/***************************************************************************
                          initialview.cpp  -  description
                             -------------------
    begin                : Sun Jan 12 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "initialview.h"

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>

#include <kapp.h>
#include <kcombobox.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kpassdlg.h>

#include "account.h"
#include "kmessdebug.h"

// The constructor
InitialView::InitialView(QWidget *parent, const char *name )
 : InitialViewInterface(parent,name)
{
  KIconLoader *loader = KGlobal::iconLoader();

  // Load the app's configuration file
  config_ = kapp->config();
  // Set the username box with the last used email address
	config_->setGroup( "InitialView" );
  handleEdit_->setText( config_->readEntry( "defaultHandle", "me@hotmail.com" ) );

  PixmapLabel3->setPixmap( loader->loadIcon( "kmesslogo", KIcon::User ) );

}



// The destructor
InitialView::~InitialView()
{
#ifdef KMESSDEBUG_INITIALVIEW
  kdDebug() << "DESTROYED InitialView" << endl;
#endif
}



// Add an account to the list of displayed accounts from which the user can choose
void InitialView::addAccount(Account *account)
{
  QString dropdownItem;
#ifdef KMESSTEST
  uint accountCount = accounts_.count();
#endif
  // Add the account to the list of accounts
  accounts_.append( account );
  // Add an entry for the account to the dropdown list
  dropdownItem = account->getFriendlyName() + " (" + account->getHandle() + ")";
  profileComboBox_->insertItem( dropdownItem );
#ifdef KMESSTEST
  ASSERT( accounts_.count() == ( accountCount + 1 ) );
#endif
}



// The "connect" button was pressed.
void InitialView::connectToMsn()
{
  Account *account = new Account();
  bool     saveAccount = rememberCheckBox_->isChecked();
  account->setLoginInformation( handleEdit_->text(), handleEdit_->text(), passwordEdit_->password() );
  emit connectWithAndSaveAccount( account, saveAccount );  

  // Save the entered text
	config_->setGroup( "InitialView" );
  config_->writeEntry( "defaultHandle",  handleEdit_->text() );
}



// The profile with the given index was selected from the drop-down list.
void InitialView::profileSelected(int index)
{
#ifdef KMESSTEST
  QString dropdownItem;
  dropdownItem = accounts_.at(index)->getFriendlyName() + " (" + accounts_.at(index)->getHandle() + ")";
  ASSERT( profileComboBox_->currentText() == dropdownItem );
#endif
  // The index *should* be the matching index for the profile's
  //  stored id.
  if ( accounts_.count() > static_cast<unsigned int>(index) )
  {
    emit connectWithAccount( accounts_.at(index) );
  }
}

#include "initialview.moc"
