/***************************************************************************
                          notificationwidget.h  -  description
                             -------------------
    begin                : Tue May 20 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTIFICATIONWIDGET_H
#define NOTIFICATIONWIDGET_H

#include <qobject.h>
#include <qptrlist.h>
#include <qwidget.h>

#include "curvedwidget.h"

/**
  *@author Michael Curtis
  */

class QHBoxLayout;
class QLabel;
class QString;
class QStringList;
class QVBoxLayout;
class QWidget;
class NotificationItem;

class NotificationWidget : public CurvedWidget
{
   Q_OBJECT

   public:
      NotificationWidget( QWidget *parent=0, const char *name=0);
     ~NotificationWidget();

     // event handler, for seeing when something is added to us/deleted from us
     bool      event( QEvent *event );
     // make up our label ;)
     void      recreateLabel();

   signals:
     void      clicked( QStringList strings, QObject *object );
     void      empty( NotificationWidget *me );
     void      full( NotificationWidget *me );

   private slots:
     void      forwardClicked( QStringList strings, QObject *object );

   private:
      // displays the title
      QLabel                      *label_;
      // what the list of contacts is displayed in
      QVBoxLayout                 *listLayout_;
      // list of notification items
      QPtrList<NotificationItem>   notificationItems_;
      // the item pixmap
      QLabel                      *pixmapLabel_;
      // what we put the pixmap and the list in
      QHBoxLayout                 *pixmapLayout_;
};

#endif
