// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#include "ksudoku.h"

#include <qdragobject.h>
#include <kprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <ksavefile.h>

#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdeversion.h>
#include <kstatusbar.h>
#include <kaccel.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kactionclasses.h>
#include <krun.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kurlrequesterdlg.h>

#include <knewdlg.h>

#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>

bool guidedMode;

void ksudoku::checkCompleted()
{
	skPuzzle* puzzle = (type == 0) ? m_view->puzzle : glwin->puzzle;
	skPuzzle* completed_puzzle = (type == 0) ? m_view->completed_puzzle : glwin->completed_puzzle;


	ITERATE(i,puzzle->size)
		if(type == 0)
		{
			if(m_view->btns[i]->value == 0)
				return;
		}
		else
			if(puzzle->numbers[i] == 0)	return;

	ITERATE(i,puzzle->size)
		if(type == 0)
		{
			if(m_view->btns[i]->value != completed_puzzle->numbers[i])
			{
				KMessageBox::information(this, "Sorry the solution you entered is not correct.\nIf you want to see error check Options->Guided mode please.");
				return;
			}
		}
		else
		{
			if(puzzle->numbers[i] != completed_puzzle->numbers[i])
			{
				KMessageBox::information(this, "Sorry the solution you entered is not correct.\nIf you want to see error check Options->Guided mode please.");
				return;
			}
		}

	QString mesg;
	int secs = t.elapsed() / 1000;
	int mins = secs / 60;
	secs = secs % 60;

	if(!donebyhimself)
		mesg.sprintf("Congratulations! You made it in %d minutes and %d seconds. With some tricks.", mins,secs);
	else
		mesg.sprintf("Congratulations!!!! You made it in %d minutes and %d seconds.", mins,secs);

	KMessageBox::information(this, mesg);
		
}

void ksudoku::updateStatusBar()
{
	int secs = t.elapsed() / 1000;
	int mins = secs / 60;
	secs = secs % 60;
	
	QString m;

	char zerochar = '0';
	if(type == 0) if(m_view) if(m_view->puzzle)  zerochar = m_view->puzzle->zerochar;
	if(type == 1) if(glwin) if(glwin->puzzle)  zerochar = glwin->puzzle->zerochar;

	if(type == 0)
	{
		if(m_view == 0) return;
		if(secs % 36 < 12)
			m.sprintf("Selected item %c, Time elapsed %d:%02d. Press SHIFT to highlight.", +m_view->current_selected_number, mins, secs);
		else  if(secs % 36 >=12 &&  secs % 36 < 24)
			m.sprintf("Selected item %c, Time elapsed %d:%02d. Use RMB to pencil-mark (superscript).", zerochar +m_view->current_selected_number, mins, secs);
		else
			m.sprintf("Selected item %c, Time elapsed %d:%02d. Type in a cell to place that number in it.", zerochar +m_view->current_selected_number, mins, secs);
	}else
	{
		if(glwin == 0) return;
		if(secs % 36 < 12)
			m.sprintf("Selected item %c, Time elapsed %d:%02d. DRAG to rotate. MOUSE WHEEL to zoom in/out.", zerochar +glwin->selected_number, mins, secs);
		else  if(secs % 36 >=12 &&  secs % 36 < 24)
			m.sprintf("Selected item %c, Time elapsed %d:%02d. DOUBLE CLICK on a cube to insert selected number.", zerochar +glwin->selected_number, mins, secs);
		else
			m.sprintf("Selected item %c, Time elapsed %d:%02d. Type in a cell (zero to delete) to place that number in it.", zerochar +glwin->selected_number, mins, secs);
	}

	statusBar()->message(m);
}

void ksudoku::load(const KURL& url)
{
	if (!myURL.isEmpty() && myURL.isValid())
	{
		QString name;
		KIO::NetAccess::download(url, name, this);
			
		FILE *fp;
		
		if (!(fp = fopen(QFile::encodeName(name), "r"))) 
		{
			KMessageBox::information(this, "Could not open file.");
			return;
		}

		type = 0;
		fscanf(fp, "%d\n", &order);
		if(order == 3) { type = 1; fscanf(fp, "%d\n", &order);}
		
		if((order != 9 && order != 16 && order != 25)) { KMessageBox::information(this, "The file format is invalid."); return;}
		if(type == 0)
		{
			m_view->setup(order,0,0,true);
			
			ITERATE(i,order)
			{
			
				unsigned char b;
				ITERATE(j,order)
				{
					fscanf(fp, "%c", &b);
					m_view->puzzle->numbers[i*order+j] = (unsigned) b-m_view->puzzle->zerochar;
					if(m_view->puzzle->numbers[i*order+j] !=0) m_view->btns[i*order+j]->given = true;
					m_view->btns[i*order+j]->setValue ( m_view->puzzle->numbers[i*order+j]);
					m_view->btns[i*order+j]->update();
				}
				fscanf(fp, "%c", &b);
			}
			m_view->update();
		}
		else
		{
			m_view->hide();
			m_view->close();
			glwin = new glWindow(this, "ksudoku-3dwnd", order, difficulty, simmetry,true);
			readProperties( KApplication::kApplication()->config());
			glwin->show();			
			setCentralWidget(glwin);	
			unsigned char b;
			ITERATE(i,(int)order*sqrt(order))
			{
				fscanf(fp, "%c", &b);
				glwin->puzzle->numbers[i] = b-glwin->puzzle->zerochar;
				glwin->flags[i] = (glwin->puzzle->numbers[i] != 0);
			}	
			glwin->paintGL();
		}

		//ITERATE(i,order*order) KMessageBox::information(this, QString::number((m_view->btns[i]->value)));

		//m_view->resizeEvent(0);
		stateChanged("dubbing");
		setCaption(url.prettyURL());
		
		KIO::NetAccess::removeTempFile( name );
	}
}

ksudoku::ksudoku(bool dub2, bool load, KURL path)
    : KMainWindow( 0, "ksudoku" ),
      m_view(new ksudokuView(this)),
      m_printer(0)
{
    // tell the KMainWindow that this is indeed the main widget
    setCentralWidget(m_view);
	donebyhimself = true;
	type = 0;
    // then, setup our actions
	readProperties( KApplication::kApplication()->config());
    setupActions();

    // and a status bar
    statusBar()->show();

    // Apply the create the main window and ask the mainwindow to
		// automatically save settings if changed: window size, toolbar
    // position, icon size, etc.  Also to add actions for the statusbar
		// toolbar, and keybindings if necessary.
    setupGUI();

    // allow the view to change the statusbar and caption
	glwin = 0;
	if(!load)
	{	
		dub = false;
		
		KNewDlg w(dub);
		w.setGeometry(100,100,200,100);
		w.exec();
				
		if(w.success == 1)
		{
			stateChanged("dubbing", StateReverse);
			order =  w.order;
			difficulty = w.difficulty;
			type  = w.type;

			simmetry = w.simmetry;

			if(type == 0)
			{
				m_view->setup(order, difficulty, simmetry, dub);
			}
			else
			{
				m_view->hide();
				m_view->close();
				glwin = new glWindow(this, "ksudoku-3dwnd", order, difficulty, simmetry);
				readProperties( KApplication::kApplication()->config());
				glwin->show();			
				setCentralWidget(glwin);	
			}
		}
		else if(w.success == 2)
		{
			order =  w.order;
			type  = w.type;
			dub = true;
			if(type == 0)
				m_view->setup(order, 0, 0, true);
			else
			{
				m_view->hide();
				m_view->close();
				glwin = new glWindow(this, "ksudoku-3dwnd", order, difficulty, simmetry, true);
				readProperties( KApplication::kApplication()->config());
				glwin->show();			
				setCentralWidget(glwin);	
			}
			stateChanged("dubbing");
		}
		else
		{
			return;
			//2FIX : close
		}				
	}
	else
	{
		dub = true;
		myURL = path;
		this->load(path);
	}

	QTimer *timer = new QTimer( this );
    connect( timer, SIGNAL(timeout()), this, SLOT(updateStatusBar()) );
    timer->start( 1000, false ); // 2 seconds single-shot timer
    connect( m_view, SIGNAL(changedSelectedNum()), this, SLOT(updateStatusBar()) );
}

ksudoku::~ksudoku()
{
	if(glwin) delete glwin;
}
	void ksudoku::mouseOnlySuperscript()
	{
		if(m_view->mouseOnlySuperscript == 0)
			m_view->mouseOnlySuperscript = 1;
		else
			m_view->mouseOnlySuperscript = 0;

		saveProperties( KApplication::kApplication()->config());
	}

	void ksudoku::setGuidedMode()
	{
		if(type == 0)
		{
			if(m_view->puzzle == 0) return;
		}
		else{
			if(!glwin) return;
			if(glwin)if(glwin->puzzle == 0) return;}

		if(guidedMode ==  0)
			guidedMode = 1;
		else
			 guidedMode = 0;

		if(type == 0)
			ITERATE(i,m_view->puzzle->size)
				m_view->btns[i]->paintEvent(0);
		else
			if(glwin) glwin->paintGL();
				

		saveProperties( KApplication::kApplication()->config());
	}

	void ksudoku::homepage()
	{
		KRun::runURL (KURL("http://ksudoku.sourceforge.net/"), "text/html");
	}
	void ksudoku::support()
	{
		KRun::runURL (KURL("http://sourceforge.net/project/project_donations.php?group_id=147876"), "text/html");
	}
	void ksudoku::sendComment()
	{
		KRun::runURL (KURL("http://ksudoku.sourceforge.net/newcomment.php"), "text/html");
	}

	void ksudoku::checkForUpdates()
	{
		QString name;
		char buf[16];
		QString myVer = "0.3";
		KIO::NetAccess::download(KURL("http://ksudoku.sourceforge.net/latest.php"), name, this);
			
		FILE *fp;
		
		if (!(fp = fopen(QFile::encodeName(name), "r"))) 
		{
			KMessageBox::information(this, "Could not get the response from server.");
			return;
		}

		fscanf(fp, "%s", buf);
		if(QString(&buf[0]) == myVer)
			KMessageBox::information(this, "Your program is at the latest version");
		else
		{
			QString msg;
			msg.sprintf("Your program version is %s, the latest version is %s.\nDo you want to update?",  myVer.ascii(), &buf[0]);
			if(KMessageBox::questionYesNo(this, msg) == KMessageBox::Yes)
				KRun::runURL (KURL("http://ksudoku.sourceforge.net/3.htm"), "text/html");
		}
		//close(fp);
		KIO::NetAccess::removeTempFile( name );
	}
	void ksudoku::giveHint()
	{
		donebyhimself = false;

		//printf("Remaining %d\n",m_view->remaining);
		if(type == 0){
			int remaining = 0;
			ITERATE(i,m_view->puzzle->size) if(m_view->btns[i]->value == 0) remaining++;
			if(remaining <= 0) return;
	
			int i;
			do
				i = RANDOM(m_view->puzzle->size);		
			while(m_view->puzzle->numbers[i] != 0);
			
			m_view->puzzle->numbers[i] = m_view->completed_puzzle->numbers[i] ;
			m_view->btns[i]->given = true;
			m_view->btns[i]->setValue(m_view->puzzle->numbers[i]);
			
			m_view->btns[i]->update();
			update();
		}
		else
			if(glwin) glwin->giveHint();
	}
	
	void ksudoku::autoSolve()
	{
		donebyhimself = false;
		if(type == 0)
		{
			//m_view->mySolver->solve(m_view->puzzle, 1, m_view->puzzle);
			for(int i=0; i<m_view->puzzle->order; i++)
				for(int j=0; j<m_view->puzzle->order; j++)
				{
					if(m_view->completed_puzzle->numbers[i] !=0) m_view->btns[i*m_view->puzzle->order+j]->given = true;
					m_view->btns[i*m_view->puzzle->order+j]->setValue(m_view->completed_puzzle->numbers[i*m_view->puzzle->order+j]);
					m_view->btns[i*m_view->puzzle->order+j]->update();
				}
			//m_view->remaining= 0;
			update();
			}
		else
			if(glwin) glwin->autoSolve();
	}
	
	void ksudoku::dubPuzzle()
	{
		/*if(!dub)
		{
			(new ksudoku(true))->show();
		}
		else
		{*/
		if(type == 0)
		{
			ITERATE(i,m_view->puzzle->size)
			{
				m_view->puzzle->numbers[i] = m_view->btns[i]->value;
			}
			
			if(m_view->genPuzzle(0, 0, true)==0)
			{
				ITERATE(i, m_view->puzzle->size) 
				{
					m_view->btns[i]->given = (m_view->btns[i]->value != 0);
					m_view->btns[i]->setValue(m_view->btns[i]->value);
				}
				m_view->update();
				stateChanged("dubbing", StateReverse);
			}	
			
		}
		else
		{
			
			if(glwin->genPuzzle(true)==0)
			{
				ITERATE(i, glwin->puzzle->size) 
				{
					glwin->flags[i] = (glwin->puzzle->numbers[i] != 0);
				}
				glwin->paintGL();
				stateChanged("dubbing", StateReverse);
			}	
		}
		push();
	}
	
	void ksudoku::genMultiple()
	{
		//KMessageBox::information(this, i18n("Sorry, this feature is under development."));
	}
	
	void ksudoku::set0(){if(glwin) glwin->selected_number = 0; m_view->current_selected_number = 0;updateStatusBar();}
	void ksudoku::set1(){if(glwin) glwin->selected_number = 1; m_view->current_selected_number = 1;updateStatusBar();}
	void ksudoku::set2(){if(glwin) glwin->selected_number = 2; m_view->current_selected_number = 2;updateStatusBar();}
	void ksudoku::set3(){if(glwin) glwin->selected_number = 3; m_view->current_selected_number = 3;updateStatusBar();}
	void ksudoku::set4(){if(glwin) glwin->selected_number = 4; m_view->current_selected_number = 4;updateStatusBar();}
	void ksudoku::set5(){if(glwin) glwin->selected_number = 5; m_view->current_selected_number = 5;updateStatusBar();}
	void ksudoku::set6(){if(glwin) glwin->selected_number = 6; m_view->current_selected_number = 6;updateStatusBar();}
	void ksudoku::set7(){if(glwin) glwin->selected_number = 7; m_view->current_selected_number = 7;updateStatusBar();}
	void ksudoku::set8(){if(glwin) glwin->selected_number = 8; m_view->current_selected_number = 8;updateStatusBar();}
	void ksudoku::set9(){if(glwin) glwin->selected_number = 9; m_view->current_selected_number = 9;updateStatusBar();}
	void ksudoku::set10(){if(glwin) glwin->selected_number = 10; m_view->current_selected_number = 10;updateStatusBar();}
	void ksudoku::set11(){if(glwin) glwin->selected_number = 11; m_view->current_selected_number = 11;updateStatusBar();}
	void ksudoku::set12(){if(glwin) glwin->selected_number = 12; m_view->current_selected_number = 12;updateStatusBar();}
	void ksudoku::set13(){if(glwin) glwin->selected_number = 13; m_view->current_selected_number = 13;updateStatusBar();}
	void ksudoku::set14(){if(glwin) glwin->selected_number = 14; m_view->current_selected_number = 14;updateStatusBar();}
	void ksudoku::set15(){if(glwin) glwin->selected_number = 15; m_view->current_selected_number = 15;updateStatusBar();}
	void ksudoku::set16(){if(glwin) glwin->selected_number = 16; m_view->current_selected_number = 16;updateStatusBar();}
	
	void ksudoku::set17(){if(glwin) glwin->selected_number = 17; m_view->current_selected_number = 17;updateStatusBar();}
	void ksudoku::set18(){if(glwin) glwin->selected_number = 18; m_view->current_selected_number = 18;updateStatusBar();}
	void ksudoku::set19(){if(glwin) glwin->selected_number = 19; m_view->current_selected_number = 19;updateStatusBar();}
	void ksudoku::set20(){if(glwin) glwin->selected_number = 20; m_view->current_selected_number = 20;updateStatusBar();}
	void ksudoku::set21(){if(glwin) glwin->selected_number = 21; m_view->current_selected_number = 21;updateStatusBar();}
	void ksudoku::set22(){if(glwin) glwin->selected_number = 22; m_view->current_selected_number = 22;updateStatusBar();}
	void ksudoku::set23(){if(glwin) glwin->selected_number = 23; m_view->current_selected_number = 23;updateStatusBar();}
	void ksudoku::set24(){if(glwin) glwin->selected_number = 24; m_view->current_selected_number = 24;updateStatusBar();}
	void ksudoku::set25(){if(glwin) glwin->selected_number = 25; m_view->current_selected_number = 25;updateStatusBar();}


void ksudoku::setupActions()
{
    KStdAction::openNew(this, SLOT(fileNew()), actionCollection());
    KStdAction::open(this, SLOT(fileOpen()), actionCollection());
    KStdAction::save(this, SLOT(fileSave()), actionCollection());
    KStdAction::saveAs(this, SLOT(fileSaveAs()), actionCollection());
    KStdAction::print(this, SLOT(filePrint()), actionCollection());
    KStdAction::quit(kapp, SLOT(quit()), actionCollection());

    KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());
				  						 
								  
	(void)new KAction(i18n("del"), 0, this, SLOT(set0()), actionCollection(), "0");
	(void)new KAction(i18n("1"), 0, this, SLOT(set1()), actionCollection(), "1");
	(void)new KAction(i18n("2"), 0, this, SLOT(set2()), actionCollection(), "2");
	(void)new KAction(i18n("3"), 0, this, SLOT(set3()), actionCollection(), "3");
	(void)new KAction(i18n("4"), 0, this, SLOT(set4()), actionCollection(), "4");
	(void)new KAction(i18n("5"), 0, this, SLOT(set5()), actionCollection(), "5");
	(void)new KAction(i18n("6"), 0, this, SLOT(set6()), actionCollection(), "6");
	(void)new KAction(i18n("7"), 0, this, SLOT(set7()), actionCollection(), "7");
	(void)new KAction(i18n("8"), 0, this, SLOT(set8()), actionCollection(), "8");
	(void)new KAction(i18n("9"), 0, this, SLOT(set9()), actionCollection(), "9");
	(void)new KAction(i18n("j"), 0, this, SLOT(set10()), actionCollection(), "j");
	(void)new KAction(i18n("k"), 0, this, SLOT(set11()), actionCollection(), "k");
	(void)new KAction(i18n("l"), 0, this, SLOT(set12()), actionCollection(), "l");
	(void)new KAction(i18n("m"), 0, this, SLOT(set13()), actionCollection(), "m");
	(void)new KAction(i18n("n"), 0, this, SLOT(set14()), actionCollection(), "n");
	(void)new KAction(i18n("o"), 0, this, SLOT(set15()), actionCollection(), "o");
	(void)new KAction(i18n("p"), 0, this, SLOT(set16()), actionCollection(), "p");

	(void)new KAction(i18n("q"), 0, this, SLOT(set17()), actionCollection(), "q");
	(void)new KAction(i18n("r"), 0, this, SLOT(set18()), actionCollection(), "r");
	(void)new KAction(i18n("s"), 0, this, SLOT(set19()), actionCollection(), "s");
	(void)new KAction(i18n("t"), 0, this, SLOT(set20()), actionCollection(), "t");
	(void)new KAction(i18n("u"), 0, this, SLOT(set21()), actionCollection(), "u");
	(void)new KAction(i18n("v"), 0, this, SLOT(set22()), actionCollection(), "v");
	(void)new KAction(i18n("w"), 0, this, SLOT(set23()), actionCollection(), "w");
	(void)new KAction(i18n("y"), 0, this, SLOT(set24()), actionCollection(), "x");
	(void)new KAction(i18n("x"), 0, this, SLOT(set25()), actionCollection(), "y");

	(void)new KAction(i18n("a"), 0, this, SLOT(set1()), actionCollection(), "a");
	(void)new KAction(i18n("b"), 0, this, SLOT(set2()), actionCollection(), "b");
	(void)new KAction(i18n("c"), 0, this, SLOT(set3()), actionCollection(), "c");
	(void)new KAction(i18n("d"), 0, this, SLOT(set4()), actionCollection(), "d");
	(void)new KAction(i18n("e"), 0, this, SLOT(set5()), actionCollection(), "e");
	(void)new KAction(i18n("f"), 0, this, SLOT(set6()), actionCollection(), "f");
	(void)new KAction(i18n("g"), 0, this, SLOT(set7()), actionCollection(), "g");
	(void)new KAction(i18n("h"), 0, this, SLOT(set8()), actionCollection(), "h");
	(void)new KAction(i18n("i"), 0, this, SLOT(set9()), actionCollection(), "i");

	(void)new KAction(i18n("Give Hint!"),  0, this, SLOT(giveHint()), actionCollection(), "giveHint"); //DONE
	(void)new KAction(i18n("Solve!"), 0, this, SLOT(autoSolve()), actionCollection(), "autoSolve");	//DONE
	//(void)new KAction(i18n("Generate Multiple"), 0, this, SLOT(genMultiple()), actionCollection(), "genMultiple");
	(void)new KAction(i18n("Check"), 0, this, SLOT(dubPuzzle()), actionCollection(), "FinishDubPuzzle");

	//WEB
	(void)new KAction(i18n("Check for updates"), 0, this, SLOT(checkForUpdates()), actionCollection(), "checkForUpdates");
	(void)new KAction(i18n("Home page"), 0, this, SLOT(homepage()), actionCollection(), "Home_page");
	(void)new KAction(i18n("Support this project"), 0, this, SLOT(support()), actionCollection(), "support");
	(void)new KAction(i18n("Send comment"), 0, this, SLOT(sendComment()), actionCollection(), "SendComment");

	//Settings
	KToggleAction* a = new KToggleAction(i18n("Mouse-Only superscript mode"), 0, this, SLOT(mouseOnlySuperscript()), actionCollection(), "mouseOnlySuperscript");
	a->setChecked(m_view->mouseOnlySuperscript);
	
	a=new KToggleAction(i18n("Guided mode (mark wrong red)"), 0, this, SLOT(setGuidedMode()), actionCollection(), "guidedMode");
	a->setChecked(guidedMode);

	a=new KToggleAction(i18n("Show tracker"), 0, this, SLOT(setShowTracker()), actionCollection(), "showTracker");
	a->setChecked(m_view->showTracker);

	//Checkpoints
	(void)new KAction(i18n("Push checkpoint (add)"), CTRL+Key_A, this, SLOT(push()), actionCollection(), "pushC");
	(void)new KAction(i18n("Pop checkpoint (extract)"), CTRL+Key_E, this, SLOT(pop()), actionCollection(), "popC");
}

void ksudoku::push()
{
	if(type == 0) {if(m_view) m_view->push();return;}
	if(glwin) glwin->push();
}

void ksudoku::pop()
{
	if(type == 0) {if(m_view)  m_view->pop(); return;}
	if(glwin) glwin->pop();
}

void ksudoku::setShowTracker()
{
	m_view->showTracker = !m_view->showTracker;
	saveProperties( KApplication::kApplication()->config());
}
void ksudoku::saveProperties(KConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored

/*#if KDE_IS_VERSION(3,1,3)
        config->writeEntry("lastURL", m_view->currentURL());
        config->writeEntry("guidedMode", m_view->guidedMode);
        config->writeEntry("mouseOnlySuperscript", m_view->mouseOnlySuperscript);
#else*/
        config->writeEntry("lastURL", (type == 0) ? m_view->currentURL() : "");
        config->writeEntry("guidedMode", guidedMode);

 		config->writeEntry("mouseOnlySuperscript",  m_view->mouseOnlySuperscript);
		config->writeEntry("showTracker", m_view->showTracker );
	 	config->writeEntry("FIRSTRUN0.3", 1);
		config->sync();
//#endif
}

void ksudoku::readProperties(KConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'

    QString url = config->readEntry("lastURL");
	if(config->readBoolEntry("FIRSTRUN0.3") ==0)
	{	
		guidedMode=1;
		m_view->mouseOnlySuperscript=1;
		m_view->showTracker=1;
		guidedMode = 1;
		saveProperties(config);
		return;
	}

	guidedMode = config->readBoolEntry("guidedMode");
	m_view->showTracker = config->readBoolEntry("showTracker");
    m_view->mouseOnlySuperscript = config->readBoolEntry("mouseOnlySuperscript");

	/*if (!url.isEmpty())
        m_view->openURL(KURL(url));*/
}

void ksudoku::dragEnterEvent(QDragEnterEvent *event)
{
    // accept uri drops only
    event->accept(KURLDrag::canDecode(event));
}

void ksudoku::dropEvent(QDropEvent *event)
{
    // this is a very simplistic implementation of a drop event.  we
    // will only accept a dropped URL.  the Qt dnd code can do *much*
    // much more, so please read the docs there
    KURL::List urls;

    // see if we can decode a URI.. if not, just ignore it
    if (KURLDrag::decode(event, urls) && !urls.isEmpty())
    {
        // okay, we have a URI.. process it
        const KURL &url = urls.first();

        // load in the file
        load(url);
    }
}

void ksudoku::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

  
    // create a new window
    (new ksudoku)->show();
}

void ksudoku::fileOpen()
{
    // this slot is called whenever the File->Open menu is selected,
    // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
    // button is clicked
    // standard filedialog
    myURL = KFileDialog::getOpenURL(QString::null, QString::null, this, i18n("Open Location"));
	(new ksudoku(false, true, myURL))->show();		
	
}

void ksudoku::fileSave()
{
    // this slot is called whenever the File->Save menu is selected,
    // the Save shortcut is pressed (usually CTRL+S) or the Save toolbar
    // button is clicked

    // save the current file

	skPuzzle* puzzle;
	if(m_view == 0) return;
	if(m_view->puzzle==0) if(glwin == 0)  return;

	if(type==0) puzzle = m_view->puzzle;
	else puzzle = glwin->puzzle;
	
	if(myURL.isEmpty())	myURL = KFileDialog::getSaveURL();
    if (!myURL.isEmpty() && myURL.isValid())
	{
		KSaveFile f(myURL.path());
		if(f.status() == 0)
		{
			QTextStream *s = f.textStream();
			if(type == 1) *s << "3\n";
			*s << puzzle->order;
			*s << "\n";
			ITERATE(i, puzzle->size)
			{
				*s << (char) (puzzle->zerochar + puzzle->numbers[i]);
				if(type == 0) if(i % puzzle->order == puzzle->order-1) *s << '\n';
			}
			
			f.close();
		}
		else
			KMessageBox::information(this, "Could not write to file.");
	}
}

void ksudoku::fileSaveAs()
{
    // this slot is called whenever the File->Save As menu is selected,
    myURL = KFileDialog::getSaveURL();
    if (!myURL.isEmpty() && myURL.isValid())
    	fileSave();
}

void ksudoku::filePrint()
{
    // this slot is called whenever the File->Print menu is selected,
    // the Print shortcut is pressed (usually CTRL+P) or the Print toolbar
    // button is clicked
	if(type != 0)
	{
		KMessageBox::information(this, "Sorry. I can not print 3d puzzles!");
		return;
	}
    if (!m_printer) m_printer = new KPrinter;
    if (m_printer->setup(this))
    {
        // setup the printer.  with Qt, you always "print" to a
        // QPainter.. whether the output medium is a pixmap, a screen,
        // or paper
        QPainter p;
        p.begin(m_printer);

        // we let our view do the actual printing
        QPaintDeviceMetrics metrics(m_printer);
        m_view->print(&p, metrics.height(), metrics.width());
        // and send the result to the printer
        p.end();
    }
}

void ksudoku::optionsPreferences()
{
    // popup some sort of preference dialog, here
/*    ksudokuPreferences dlg;
    if (dlg.exec())
    {
        // redo your settings
    }*/
}

void ksudoku::changeStatusbar(const QString& text)
{
    // display the text on the statusbar
    statusBar()->message(text);
}


void ksudoku::changeCaption(const QString& text)
{
    // display the text on the caption
    setCaption(text);
}
#include "ksudoku.moc"

