@echo off
cls

echo .
echo MySQL Workbench Debug Build Script
echo --------------------------------------------------------------------
echo This script will create a runtime image of the MySQL Workbench
echo in the .\bin directory. All resources, mysql gui libraries and the
echo binary will be build using the correct settings.
echo .

echo Cleaning previous builds...
rmdir bin /S /Q 1> nul
echo .

echo Preparing application folder ...
call PrepareApplicationFolder.cmd
echo.
if errorlevel 1 goto error

echo Compiling common libraries...
pushd ..\common\
call BuildDebug.cmd
popd
echo.
if errorlevel 1 goto error

echo =======================================================
echo Building Workbench application
echo -------------------------------------------------------
pushd source\windows
dcc32 -$A8 -$B- -$C+ -$D+ -$E- -$F- -$G+ -$H+ -$I+ -$J- -$K+ -$L+ -$M- -$N+ -$O- -$P+ -$Q+ -$R+ -$S- -$T- -$U- -$V+ -$W+ -$X+ -$Y+ -$Z4 -H+ -W -$M4096,1048576 -$K4194304 -B -CG -E..\..\bin\windows -N0intermediate -U%ProgramFiles%\borland\bds\4.0\lib;%ProgramFiles%\borland\bds\4.0\Imports -O%ProgramFiles%\borland\bds\4.0\lib;%ProgramFiles%\borland\bds\4.0\Imports;common\obj\windows -R%ProgramFiles%\borland\bds\4.0\lib;%ProgramFiles%\borland\bds\4.0\Imports -NSBorland.Vcl -LE..\..\..\..\Output -LN..\..\..\..\Output -AWinTypes=Windows;WinProcs=Windows;DbiTypes=BDE;DbiProcs=BDE;DbiErrs=BDE; -NOintermediate -NBintermediate -W-UNSAFE_TYPE -W-UNSAFE_CODE -W-UNSAFE_CAST -U..\..\..\common\source\windows\Common;..\..\..\common\source\windows;..\..\..\common\source\windows\png;..\..\..\common\source\windows\TNT;..\..\..\common\source\windows\VirtualTreeView\Source;..\..\..\common\source\windows\embeddedwb;..\..\..\common\source\windows\UniCodeEditor\Source;..\..\..\common\source\windows\GenericCanvasViewer\Source;..\..\..\common\source\windows\tools;%ProgramFiles%\borland\bds\4.0\lib;%ProgramFiles%\borland\bds\4.0\Imports -O..\..\..\common\obj\Windows -I..\..\..\common\source\windows\Common --no-config MySQLWorkbench.dpr -Q
popd
echo.

if not errorlevel 1 goto finish

:error
echo ##### Batch build cannot continue due to an error. #####
goto end

:finish
echo -------------------------------------------------------
echo Finished Workbench successfully.
echo =======================================================

:end