#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2008 by Sun Microsystems, Inc.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# $RCSfile: makefile.mk,v $
#
# $Revision: 1.1.1.1 $
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

PRJ=..
PRJNAME=reportbuilder
TARGET=rptx

# --- Settings ----------------------------------
.INCLUDE :  makefile.pmk

# ------------------------------------------------------------------
# calready set in util$/makefile.pmk
# EXTENSIONNAME:=sun-report-builder
EXTENSION_ZIPNAME:=sun-report-builder

# create Extension -----------------------------

.IF "$(SOLAR_JAVA)"!=""

XMLFILES = $(EXTENSIONDIR)$/description.xml \
			$(EXTENSIONDIR)$/META-INF$/manifest.xml

COMPONENT_MERGED_XCU= \
			$(EXTENSIONDIR)$/registry$/data$/org$/openoffice$/Office$/DataAccess.xcu \
			$(EXTENSIONDIR)$/registry$/data$/org$/openoffice$/Office$/ReportDesign.xcu \
			$(EXTENSIONDIR)$/registry$/data$/org$/openoffice$/Office$/Paths.xcu

COMPONENT_OTR_FILES= \
	$(EXTENSIONDIR)$/template$/en-US$/wizard$/report$/default.otr

COMPONENT_HTMLFILES = $(EXTENSIONDIR)$/THIRDPARTYREADMELICENSE.html \
			$(EXTENSIONDIR)$/readme_en-US.html \
			$(EXTENSIONDIR)$/readme_en-US.txt

COMPONENT_JARFILES = \
	$(EXTENSIONDIR)$/sun-report-builder.jar

COMPONENT_HELP= \
	$(EXTENSIONDIR)$/help$/component.txt

# .jar files from solver
COMPONENT_EXTJARFILES = \
	$(EXTENSIONDIR)$/flute-1.3-jfree-20061107.jar							\
	$(EXTENSIONDIR)$/jcommon-1.0.10.jar										\
	$(EXTENSIONDIR)$/jcommon-serializer-0.2.0.jar							\
	$(EXTENSIONDIR)$/libfonts-0.3.3.jar										\
	$(EXTENSIONDIR)$/libformula-0.1.14.jar									\
	$(EXTENSIONDIR)$/liblayout-0.2.8.jar										\
	$(EXTENSIONDIR)$/libloader-0.3.6.jar										\
	$(EXTENSIONDIR)$/librepository-0.1.4.jar									\
	$(EXTENSIONDIR)$/libxml-0.9.9.jar										\
	$(EXTENSIONDIR)$/pentaho-reporting-flow-engine-0.9.2.jar					\
	$(EXTENSIONDIR)$/sac.jar                                                \
	$(EXTENSIONDIR)$/sun-report-builder.jar \
	$(EXTENSIONDIR)$/reportbuilderwizard.jar

COMPONENT_MANIFEST_GENERIC:=TRUE
COMPONENT_MANIFEST_SEARCHDIR:=registry

# make sure to add your custom files here
EXTENSION_PACKDEPS=$(COMPONENT_EXTJARFILES) $(COMPONENT_HTMLFILES) $(COMPONENT_OTR_FILES) $(COMPONENT_HELP)

# --- Targets ----------------------------------

.INCLUDE : extension_pre.mk
.INCLUDE : target.mk
.INCLUDE : extension_post.mk

.IF "$(SYSTEM_JFREEREPORT)" == "YES"
$(EXTENSIONDIR)$/%.jar : $(JFREEREPORT_JAR:d:d)$/%.jar
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@
.ELSE
$(EXTENSIONDIR)$/%.jar : $(SOLARBINDIR)$/%.jar
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@
.ENDIF

$(EXTENSIONDIR)$/readme_en-US.% : $(PRJ)$/license$/readme_en-US.%
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@

$(EXTENSIONDIR)$/THIRDPARTYREADMELICENSE.html : $(PRJ)$/license$/THIRDPARTYREADMELICENSE.html
    @@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@

$(COMPONENT_HELP) : $$(@:f)
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@

    .ELSE			# "$(SOLAR_JAVA)"!=""
.INCLUDE : target.mk
.ENDIF			# "$(SOLAR_JAVA)"!=""
#
