/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: clipfmtitem.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _SVX_CLIPFMTITEM_HXX
#define _SVX_CLIPFMTITEM_HXX

// include ---------------------------------------------------------------

#include <tools/gen.hxx>
#include <svtools/poolitem.hxx>
#include "svx/svxdllapi.h"

// class SvxClipboardFmtItem ----------------------------------------------
struct SvxClipboardFmtItem_Impl;

class SVX_DLLPUBLIC SvxClipboardFmtItem : public SfxPoolItem
{
	SvxClipboardFmtItem_Impl* pImpl;
protected:

	virtual int 			 operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	 Clone( SfxItemPool *pPool = 0 ) const;

public:
	TYPEINFO();
	SvxClipboardFmtItem( USHORT nId = 0 );
	SvxClipboardFmtItem( const SvxClipboardFmtItem& );
	virtual ~SvxClipboardFmtItem();

    virtual BOOL QueryValue( com::sun::star::uno::Any& rVal, BYTE nMemberId ) const;
    virtual sal_Bool PutValue( const com::sun::star::uno::Any& rVal, BYTE nMemberId );
    
    void AddClipbrdFormat( ULONG nId, USHORT nPos = USHRT_MAX );
	void AddClipbrdFormat( ULONG nId, const String& rName,
							USHORT nPos = USHRT_MAX );
	USHORT Count() const;

	ULONG GetClipbrdFormatId( USHORT nPos ) const;
	const String& GetClipbrdFormatName( USHORT nPos ) const;
};


#endif

