/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: thesdsp.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _LINGUISTIC_THESDSP_HXX_
#define _LINGUISTIC_THESDSP_HXX_

#include <com/sun/star/uno/Reference.h>
#include <com/sun/star/uno/Sequence.h>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/beans/XPropertyAccess.hpp>
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#include <com/sun/star/lang/XComponent.hpp>
#include <com/sun/star/lang/XInitialization.hpp>
#include <com/sun/star/lang/XServiceDisplayName.hpp>

#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/linguistic2/XThesaurus.hpp>

#include <uno/lbnames.h>			// CPPU_CURRENT_LANGUAGE_BINDING_NAME macro, which specify the environment type
#include <cppuhelper/implbase1.hxx>	// helper for implementations
#include <cppuhelper/implbase5.hxx>	// helper for implementations
#include <cppuhelper/interfacecontainer.h>

#include <vos/mutex.hxx>

#include <boost/shared_ptr.hpp>
#include <map>

#include "lngopt.hxx"


///////////////////////////////////////////////////////////////////////////

class ThesaurusDispatcher :
	public cppu::WeakImplHelper1
	<
		::com::sun::star::linguistic2::XThesaurus
	>,
	public LinguDispatcher
{
    typedef boost::shared_ptr< LangSvcEntries_Thes >                LangSvcEntries_Thes_Ptr_t;
    typedef std::map< LanguageType, LangSvcEntries_Thes_Ptr_t >     ThesSvcByLangMap_t;
    ThesSvcByLangMap_t      aSvcMap;

	::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet >		xPropSet;

	// disallow copy-constructor and assignment-operator for now
	ThesaurusDispatcher(const ThesaurusDispatcher &);
	ThesaurusDispatcher & operator = (const ThesaurusDispatcher &);

	inline ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet >
			GetPropSet();

	void 	ClearSvcList();

public:
	ThesaurusDispatcher();
	virtual ~ThesaurusDispatcher();

	// XSupportedLocales
    virtual ::com::sun::star::uno::Sequence<
			::com::sun::star::lang::Locale > SAL_CALL
		getLocales()
			throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL
		hasLocale( const ::com::sun::star::lang::Locale& aLocale )
			throw(::com::sun::star::uno::RuntimeException);

	// XThesaurus
    virtual ::com::sun::star::uno::Sequence<
			::com::sun::star::uno::Reference<
				::com::sun::star::linguistic2::XMeaning > > SAL_CALL
		queryMeanings( const ::rtl::OUString& aTerm,
				const ::com::sun::star::lang::Locale& aLocale,
				const ::com::sun::star::beans::PropertyValues& aProperties )
			throw(::com::sun::star::lang::IllegalArgumentException,
				  ::com::sun::star::uno::RuntimeException);

	// LinguDispatcher
	virtual void
		SetServiceList( const ::com::sun::star::lang::Locale &rLocale,
				const ::com::sun::star::uno::Sequence<
					rtl::OUString > &rSvcImplNames );
	virtual ::com::sun::star::uno::Sequence< rtl::OUString >
		GetServiceList( const ::com::sun::star::lang::Locale &rLocale ) const;
	virtual DspType
		GetDspType() const;
};


inline ::com::sun::star::uno::Reference<
	::com::sun::star::beans::XPropertySet >
		ThesaurusDispatcher::GetPropSet()
{
	return xPropSet.is() ? 
		xPropSet : xPropSet = linguistic::GetLinguProperties();
}


///////////////////////////////////////////////////////////////////////////

#endif

