# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.4
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Amanda::Config;
use base qw(Exporter);
use base qw(DynaLoader);
package Amanda::Configc;
bootstrap Amanda::Config;
package Amanda::Config;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Amanda::Config;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Config;

*data_path_from_string = *Amanda::Configc::data_path_from_string;
*getconf = *Amanda::Configc::getconf;
*getconf_seen = *Amanda::Configc::getconf_seen;
*getconf_linenum = *Amanda::Configc::getconf_linenum;
*getconf_byname = *Amanda::Configc::getconf_byname;
*getconf_list = *Amanda::Configc::getconf_list;
*getconf_byname_strs = *Amanda::Configc::getconf_byname_strs;
*lookup_tapetype = *Amanda::Configc::lookup_tapetype;
*tapetype_getconf = *Amanda::Configc::tapetype_getconf;
*tapetype_name = *Amanda::Configc::tapetype_name;
*tapetype_seen = *Amanda::Configc::tapetype_seen;
*lookup_dumptype = *Amanda::Configc::lookup_dumptype;
*dumptype_getconf = *Amanda::Configc::dumptype_getconf;
*dumptype_name = *Amanda::Configc::dumptype_name;
*dumptype_seen = *Amanda::Configc::dumptype_seen;
*lookup_interface = *Amanda::Configc::lookup_interface;
*interface_getconf = *Amanda::Configc::interface_getconf;
*interface_name = *Amanda::Configc::interface_name;
*interface_seen = *Amanda::Configc::interface_seen;
*lookup_holdingdisk = *Amanda::Configc::lookup_holdingdisk;
*getconf_holdingdisks = *Amanda::Configc::getconf_holdingdisks;
*holdingdisk_getconf = *Amanda::Configc::holdingdisk_getconf;
*holdingdisk_name = *Amanda::Configc::holdingdisk_name;
*holdingdisk_seen = *Amanda::Configc::holdingdisk_seen;
*lookup_application = *Amanda::Configc::lookup_application;
*application_getconf = *Amanda::Configc::application_getconf;
*application_name = *Amanda::Configc::application_name;
*application_seen = *Amanda::Configc::application_seen;
*lookup_pp_script = *Amanda::Configc::lookup_pp_script;
*pp_script_getconf = *Amanda::Configc::pp_script_getconf;
*pp_script_name = *Amanda::Configc::pp_script_name;
*pp_script_seen = *Amanda::Configc::pp_script_seen;
*lookup_device_config = *Amanda::Configc::lookup_device_config;
*device_config_getconf = *Amanda::Configc::device_config_getconf;
*device_config_name = *Amanda::Configc::device_config_name;
*device_config_seen = *Amanda::Configc::device_config_seen;
*lookup_changer_config = *Amanda::Configc::lookup_changer_config;
*changer_config_getconf = *Amanda::Configc::changer_config_getconf;
*changer_config_name = *Amanda::Configc::changer_config_name;
*changer_config_seen = *Amanda::Configc::changer_config_seen;
*lookup_interactivity = *Amanda::Configc::lookup_interactivity;
*interactivity_getconf = *Amanda::Configc::interactivity_getconf;
*interactivity_name = *Amanda::Configc::interactivity_name;
*interactivity_seen = *Amanda::Configc::interactivity_seen;
*lookup_taperscan = *Amanda::Configc::lookup_taperscan;
*taperscan_getconf = *Amanda::Configc::taperscan_getconf;
*taperscan_name = *Amanda::Configc::taperscan_name;
*taperscan_seen = *Amanda::Configc::taperscan_seen;
*getconf_unit_divisor = *Amanda::Configc::getconf_unit_divisor;
*config_init = *Amanda::Configc::config_init;
*config_uninit = *Amanda::Configc::config_uninit;
*get_config_options = *Amanda::Configc::get_config_options;
*get_config_name = *Amanda::Configc::get_config_name;
*get_config_dir = *Amanda::Configc::get_config_dir;
*get_config_filename = *Amanda::Configc::get_config_filename;
*config_print_errors = *Amanda::Configc::config_print_errors;
*config_clear_errors = *Amanda::Configc::config_clear_errors;
*config_errors = *Amanda::Configc::config_errors;
*new_config_overrides = *Amanda::Configc::new_config_overrides;
*free_config_overrides = *Amanda::Configc::free_config_overrides;
*add_config_override = *Amanda::Configc::add_config_override;
*add_config_override_opt = *Amanda::Configc::add_config_override_opt;
*set_config_overrides = *Amanda::Configc::set_config_overrides;
*dump_configuration = *Amanda::Configc::dump_configuration;
*config_dir_relative = *Amanda::Configc::config_dir_relative;
*taperalgo2str = *Amanda::Configc::taperalgo2str;
*find_multiplier = *Amanda::Configc::find_multiplier;
*C_string_to_boolean = *Amanda::Configc::C_string_to_boolean;
*amandaify_property_name = *Amanda::Configc::amandaify_property_name;

# ------- VARIABLE STUBS --------

package Amanda::Config;

*CNF_ORG = *Amanda::Configc::CNF_ORG;
*CNF_CONF = *Amanda::Configc::CNF_CONF;
*CNF_AMDUMP_SERVER = *Amanda::Configc::CNF_AMDUMP_SERVER;
*CNF_INDEX_SERVER = *Amanda::Configc::CNF_INDEX_SERVER;
*CNF_TAPE_SERVER = *Amanda::Configc::CNF_TAPE_SERVER;
*CNF_AUTH = *Amanda::Configc::CNF_AUTH;
*CNF_SSH_KEYS = *Amanda::Configc::CNF_SSH_KEYS;
*CNF_AMANDAD_PATH = *Amanda::Configc::CNF_AMANDAD_PATH;
*CNF_CLIENT_USERNAME = *Amanda::Configc::CNF_CLIENT_USERNAME;
*CNF_CLIENT_PORT = *Amanda::Configc::CNF_CLIENT_PORT;
*CNF_GNUTAR_LIST_DIR = *Amanda::Configc::CNF_GNUTAR_LIST_DIR;
*CNF_AMANDATES = *Amanda::Configc::CNF_AMANDATES;
*CNF_MAILER = *Amanda::Configc::CNF_MAILER;
*CNF_MAILTO = *Amanda::Configc::CNF_MAILTO;
*CNF_DUMPUSER = *Amanda::Configc::CNF_DUMPUSER;
*CNF_TAPEDEV = *Amanda::Configc::CNF_TAPEDEV;
*CNF_DEVICE_PROPERTY = *Amanda::Configc::CNF_DEVICE_PROPERTY;
*CNF_PROPERTY = *Amanda::Configc::CNF_PROPERTY;
*CNF_CHANGERDEV = *Amanda::Configc::CNF_CHANGERDEV;
*CNF_CHANGERFILE = *Amanda::Configc::CNF_CHANGERFILE;
*CNF_LABELSTR = *Amanda::Configc::CNF_LABELSTR;
*CNF_AUTOLABEL = *Amanda::Configc::CNF_AUTOLABEL;
*CNF_META_AUTOLABEL = *Amanda::Configc::CNF_META_AUTOLABEL;
*CNF_TAPELIST = *Amanda::Configc::CNF_TAPELIST;
*CNF_DISKFILE = *Amanda::Configc::CNF_DISKFILE;
*CNF_INFOFILE = *Amanda::Configc::CNF_INFOFILE;
*CNF_LOGDIR = *Amanda::Configc::CNF_LOGDIR;
*CNF_INDEXDIR = *Amanda::Configc::CNF_INDEXDIR;
*CNF_TAPETYPE = *Amanda::Configc::CNF_TAPETYPE;
*CNF_DUMPCYCLE = *Amanda::Configc::CNF_DUMPCYCLE;
*CNF_RUNSPERCYCLE = *Amanda::Configc::CNF_RUNSPERCYCLE;
*CNF_TAPECYCLE = *Amanda::Configc::CNF_TAPECYCLE;
*CNF_NETUSAGE = *Amanda::Configc::CNF_NETUSAGE;
*CNF_INPARALLEL = *Amanda::Configc::CNF_INPARALLEL;
*CNF_DUMPORDER = *Amanda::Configc::CNF_DUMPORDER;
*CNF_BUMPPERCENT = *Amanda::Configc::CNF_BUMPPERCENT;
*CNF_BUMPSIZE = *Amanda::Configc::CNF_BUMPSIZE;
*CNF_BUMPMULT = *Amanda::Configc::CNF_BUMPMULT;
*CNF_BUMPDAYS = *Amanda::Configc::CNF_BUMPDAYS;
*CNF_TPCHANGER = *Amanda::Configc::CNF_TPCHANGER;
*CNF_RUNTAPES = *Amanda::Configc::CNF_RUNTAPES;
*CNF_MAX_DLE_BY_VOLUME = *Amanda::Configc::CNF_MAX_DLE_BY_VOLUME;
*CNF_MAXDUMPS = *Amanda::Configc::CNF_MAXDUMPS;
*CNF_ETIMEOUT = *Amanda::Configc::CNF_ETIMEOUT;
*CNF_DTIMEOUT = *Amanda::Configc::CNF_DTIMEOUT;
*CNF_CTIMEOUT = *Amanda::Configc::CNF_CTIMEOUT;
*CNF_DEVICE_OUTPUT_BUFFER_SIZE = *Amanda::Configc::CNF_DEVICE_OUTPUT_BUFFER_SIZE;
*CNF_PRINTER = *Amanda::Configc::CNF_PRINTER;
*CNF_AUTOFLUSH = *Amanda::Configc::CNF_AUTOFLUSH;
*CNF_RESERVE = *Amanda::Configc::CNF_RESERVE;
*CNF_MAXDUMPSIZE = *Amanda::Configc::CNF_MAXDUMPSIZE;
*CNF_COLUMNSPEC = *Amanda::Configc::CNF_COLUMNSPEC;
*CNF_AMRECOVER_DO_FSF = *Amanda::Configc::CNF_AMRECOVER_DO_FSF;
*CNF_AMRECOVER_CHECK_LABEL = *Amanda::Configc::CNF_AMRECOVER_CHECK_LABEL;
*CNF_AMRECOVER_CHANGER = *Amanda::Configc::CNF_AMRECOVER_CHANGER;
*CNF_TAPERALGO = *Amanda::Configc::CNF_TAPERALGO;
*CNF_FLUSH_THRESHOLD_DUMPED = *Amanda::Configc::CNF_FLUSH_THRESHOLD_DUMPED;
*CNF_FLUSH_THRESHOLD_SCHEDULED = *Amanda::Configc::CNF_FLUSH_THRESHOLD_SCHEDULED;
*CNF_TAPERFLUSH = *Amanda::Configc::CNF_TAPERFLUSH;
*CNF_DISPLAYUNIT = *Amanda::Configc::CNF_DISPLAYUNIT;
*CNF_KRB5KEYTAB = *Amanda::Configc::CNF_KRB5KEYTAB;
*CNF_KRB5PRINCIPAL = *Amanda::Configc::CNF_KRB5PRINCIPAL;
*CNF_LABEL_NEW_TAPES = *Amanda::Configc::CNF_LABEL_NEW_TAPES;
*CNF_USETIMESTAMPS = *Amanda::Configc::CNF_USETIMESTAMPS;
*CNF_REP_TRIES = *Amanda::Configc::CNF_REP_TRIES;
*CNF_CONNECT_TRIES = *Amanda::Configc::CNF_CONNECT_TRIES;
*CNF_REQ_TRIES = *Amanda::Configc::CNF_REQ_TRIES;
*CNF_DEBUG_AMANDAD = *Amanda::Configc::CNF_DEBUG_AMANDAD;
*CNF_DEBUG_RECOVERY = *Amanda::Configc::CNF_DEBUG_RECOVERY;
*CNF_DEBUG_AMIDXTAPED = *Amanda::Configc::CNF_DEBUG_AMIDXTAPED;
*CNF_DEBUG_AMINDEXD = *Amanda::Configc::CNF_DEBUG_AMINDEXD;
*CNF_DEBUG_AMRECOVER = *Amanda::Configc::CNF_DEBUG_AMRECOVER;
*CNF_DEBUG_AUTH = *Amanda::Configc::CNF_DEBUG_AUTH;
*CNF_DEBUG_EVENT = *Amanda::Configc::CNF_DEBUG_EVENT;
*CNF_DEBUG_HOLDING = *Amanda::Configc::CNF_DEBUG_HOLDING;
*CNF_DEBUG_PROTOCOL = *Amanda::Configc::CNF_DEBUG_PROTOCOL;
*CNF_DEBUG_PLANNER = *Amanda::Configc::CNF_DEBUG_PLANNER;
*CNF_DEBUG_DRIVER = *Amanda::Configc::CNF_DEBUG_DRIVER;
*CNF_DEBUG_DUMPER = *Amanda::Configc::CNF_DEBUG_DUMPER;
*CNF_DEBUG_CHUNKER = *Amanda::Configc::CNF_DEBUG_CHUNKER;
*CNF_DEBUG_TAPER = *Amanda::Configc::CNF_DEBUG_TAPER;
*CNF_DEBUG_SELFCHECK = *Amanda::Configc::CNF_DEBUG_SELFCHECK;
*CNF_DEBUG_SENDSIZE = *Amanda::Configc::CNF_DEBUG_SENDSIZE;
*CNF_DEBUG_SENDBACKUP = *Amanda::Configc::CNF_DEBUG_SENDBACKUP;
*CNF_RESERVED_UDP_PORT = *Amanda::Configc::CNF_RESERVED_UDP_PORT;
*CNF_RESERVED_TCP_PORT = *Amanda::Configc::CNF_RESERVED_TCP_PORT;
*CNF_UNRESERVED_TCP_PORT = *Amanda::Configc::CNF_UNRESERVED_TCP_PORT;
*CNF_HOLDINGDISK = *Amanda::Configc::CNF_HOLDINGDISK;
*CNF_SEND_AMREPORT_ON = *Amanda::Configc::CNF_SEND_AMREPORT_ON;
*CNF_TAPER_PARALLEL_WRITE = *Amanda::Configc::CNF_TAPER_PARALLEL_WRITE;
*CNF_RECOVERY_LIMIT = *Amanda::Configc::CNF_RECOVERY_LIMIT;
*CNF_INTERACTIVITY = *Amanda::Configc::CNF_INTERACTIVITY;
*CNF_TAPERSCAN = *Amanda::Configc::CNF_TAPERSCAN;
*CNF_EJECT_VOLUME = *Amanda::Configc::CNF_EJECT_VOLUME;
*TAPETYPE_COMMENT = *Amanda::Configc::TAPETYPE_COMMENT;
*TAPETYPE_LBL_TEMPL = *Amanda::Configc::TAPETYPE_LBL_TEMPL;
*TAPETYPE_BLOCKSIZE = *Amanda::Configc::TAPETYPE_BLOCKSIZE;
*TAPETYPE_READBLOCKSIZE = *Amanda::Configc::TAPETYPE_READBLOCKSIZE;
*TAPETYPE_LENGTH = *Amanda::Configc::TAPETYPE_LENGTH;
*TAPETYPE_FILEMARK = *Amanda::Configc::TAPETYPE_FILEMARK;
*TAPETYPE_SPEED = *Amanda::Configc::TAPETYPE_SPEED;
*TAPETYPE_PART_SIZE = *Amanda::Configc::TAPETYPE_PART_SIZE;
*TAPETYPE_PART_CACHE_TYPE = *Amanda::Configc::TAPETYPE_PART_CACHE_TYPE;
*TAPETYPE_PART_CACHE_DIR = *Amanda::Configc::TAPETYPE_PART_CACHE_DIR;
*TAPETYPE_PART_CACHE_MAX_SIZE = *Amanda::Configc::TAPETYPE_PART_CACHE_MAX_SIZE;
*DUMPTYPE_COMMENT = *Amanda::Configc::DUMPTYPE_COMMENT;
*DUMPTYPE_PROGRAM = *Amanda::Configc::DUMPTYPE_PROGRAM;
*DUMPTYPE_SRVCOMPPROG = *Amanda::Configc::DUMPTYPE_SRVCOMPPROG;
*DUMPTYPE_CLNTCOMPPROG = *Amanda::Configc::DUMPTYPE_CLNTCOMPPROG;
*DUMPTYPE_SRV_ENCRYPT = *Amanda::Configc::DUMPTYPE_SRV_ENCRYPT;
*DUMPTYPE_CLNT_ENCRYPT = *Amanda::Configc::DUMPTYPE_CLNT_ENCRYPT;
*DUMPTYPE_AMANDAD_PATH = *Amanda::Configc::DUMPTYPE_AMANDAD_PATH;
*DUMPTYPE_CLIENT_USERNAME = *Amanda::Configc::DUMPTYPE_CLIENT_USERNAME;
*DUMPTYPE_CLIENT_PORT = *Amanda::Configc::DUMPTYPE_CLIENT_PORT;
*DUMPTYPE_SSH_KEYS = *Amanda::Configc::DUMPTYPE_SSH_KEYS;
*DUMPTYPE_AUTH = *Amanda::Configc::DUMPTYPE_AUTH;
*DUMPTYPE_EXCLUDE = *Amanda::Configc::DUMPTYPE_EXCLUDE;
*DUMPTYPE_INCLUDE = *Amanda::Configc::DUMPTYPE_INCLUDE;
*DUMPTYPE_PRIORITY = *Amanda::Configc::DUMPTYPE_PRIORITY;
*DUMPTYPE_DUMPCYCLE = *Amanda::Configc::DUMPTYPE_DUMPCYCLE;
*DUMPTYPE_MAXDUMPS = *Amanda::Configc::DUMPTYPE_MAXDUMPS;
*DUMPTYPE_MAXPROMOTEDAY = *Amanda::Configc::DUMPTYPE_MAXPROMOTEDAY;
*DUMPTYPE_BUMPPERCENT = *Amanda::Configc::DUMPTYPE_BUMPPERCENT;
*DUMPTYPE_BUMPSIZE = *Amanda::Configc::DUMPTYPE_BUMPSIZE;
*DUMPTYPE_BUMPDAYS = *Amanda::Configc::DUMPTYPE_BUMPDAYS;
*DUMPTYPE_BUMPMULT = *Amanda::Configc::DUMPTYPE_BUMPMULT;
*DUMPTYPE_STARTTIME = *Amanda::Configc::DUMPTYPE_STARTTIME;
*DUMPTYPE_STRATEGY = *Amanda::Configc::DUMPTYPE_STRATEGY;
*DUMPTYPE_ESTIMATELIST = *Amanda::Configc::DUMPTYPE_ESTIMATELIST;
*DUMPTYPE_COMPRESS = *Amanda::Configc::DUMPTYPE_COMPRESS;
*DUMPTYPE_ENCRYPT = *Amanda::Configc::DUMPTYPE_ENCRYPT;
*DUMPTYPE_SRV_DECRYPT_OPT = *Amanda::Configc::DUMPTYPE_SRV_DECRYPT_OPT;
*DUMPTYPE_CLNT_DECRYPT_OPT = *Amanda::Configc::DUMPTYPE_CLNT_DECRYPT_OPT;
*DUMPTYPE_COMPRATE = *Amanda::Configc::DUMPTYPE_COMPRATE;
*DUMPTYPE_TAPE_SPLITSIZE = *Amanda::Configc::DUMPTYPE_TAPE_SPLITSIZE;
*DUMPTYPE_FALLBACK_SPLITSIZE = *Amanda::Configc::DUMPTYPE_FALLBACK_SPLITSIZE;
*DUMPTYPE_SPLIT_DISKBUFFER = *Amanda::Configc::DUMPTYPE_SPLIT_DISKBUFFER;
*DUMPTYPE_RECORD = *Amanda::Configc::DUMPTYPE_RECORD;
*DUMPTYPE_SKIP_INCR = *Amanda::Configc::DUMPTYPE_SKIP_INCR;
*DUMPTYPE_SKIP_FULL = *Amanda::Configc::DUMPTYPE_SKIP_FULL;
*DUMPTYPE_HOLDINGDISK = *Amanda::Configc::DUMPTYPE_HOLDINGDISK;
*DUMPTYPE_KENCRYPT = *Amanda::Configc::DUMPTYPE_KENCRYPT;
*DUMPTYPE_IGNORE = *Amanda::Configc::DUMPTYPE_IGNORE;
*DUMPTYPE_INDEX = *Amanda::Configc::DUMPTYPE_INDEX;
*DUMPTYPE_APPLICATION = *Amanda::Configc::DUMPTYPE_APPLICATION;
*DUMPTYPE_SCRIPTLIST = *Amanda::Configc::DUMPTYPE_SCRIPTLIST;
*DUMPTYPE_PROPERTY = *Amanda::Configc::DUMPTYPE_PROPERTY;
*DUMPTYPE_DATA_PATH = *Amanda::Configc::DUMPTYPE_DATA_PATH;
*DUMPTYPE_ALLOW_SPLIT = *Amanda::Configc::DUMPTYPE_ALLOW_SPLIT;
*DUMPTYPE_RECOVERY_LIMIT = *Amanda::Configc::DUMPTYPE_RECOVERY_LIMIT;
*DUMPTYPE_DUMP_LIMIT = *Amanda::Configc::DUMPTYPE_DUMP_LIMIT;
*INTER_COMMENT = *Amanda::Configc::INTER_COMMENT;
*INTER_MAXUSAGE = *Amanda::Configc::INTER_MAXUSAGE;
*HOLDING_COMMENT = *Amanda::Configc::HOLDING_COMMENT;
*HOLDING_DISKDIR = *Amanda::Configc::HOLDING_DISKDIR;
*HOLDING_DISKSIZE = *Amanda::Configc::HOLDING_DISKSIZE;
*HOLDING_CHUNKSIZE = *Amanda::Configc::HOLDING_CHUNKSIZE;
*APPLICATION_COMMENT = *Amanda::Configc::APPLICATION_COMMENT;
*APPLICATION_PLUGIN = *Amanda::Configc::APPLICATION_PLUGIN;
*APPLICATION_PROPERTY = *Amanda::Configc::APPLICATION_PROPERTY;
*APPLICATION_CLIENT_NAME = *Amanda::Configc::APPLICATION_CLIENT_NAME;
*PP_SCRIPT_COMMENT = *Amanda::Configc::PP_SCRIPT_COMMENT;
*PP_SCRIPT_PLUGIN = *Amanda::Configc::PP_SCRIPT_PLUGIN;
*PP_SCRIPT_PROPERTY = *Amanda::Configc::PP_SCRIPT_PROPERTY;
*PP_SCRIPT_EXECUTE_ON = *Amanda::Configc::PP_SCRIPT_EXECUTE_ON;
*PP_SCRIPT_EXECUTE_WHERE = *Amanda::Configc::PP_SCRIPT_EXECUTE_WHERE;
*PP_SCRIPT_ORDER = *Amanda::Configc::PP_SCRIPT_ORDER;
*PP_SCRIPT_SINGLE_EXECUTION = *Amanda::Configc::PP_SCRIPT_SINGLE_EXECUTION;
*PP_SCRIPT_CLIENT_NAME = *Amanda::Configc::PP_SCRIPT_CLIENT_NAME;
*DEVICE_CONFIG_COMMENT = *Amanda::Configc::DEVICE_CONFIG_COMMENT;
*DEVICE_CONFIG_TAPEDEV = *Amanda::Configc::DEVICE_CONFIG_TAPEDEV;
*DEVICE_CONFIG_DEVICE_PROPERTY = *Amanda::Configc::DEVICE_CONFIG_DEVICE_PROPERTY;
*CHANGER_CONFIG_COMMENT = *Amanda::Configc::CHANGER_CONFIG_COMMENT;
*CHANGER_CONFIG_TAPEDEV = *Amanda::Configc::CHANGER_CONFIG_TAPEDEV;
*CHANGER_CONFIG_TPCHANGER = *Amanda::Configc::CHANGER_CONFIG_TPCHANGER;
*CHANGER_CONFIG_CHANGERDEV = *Amanda::Configc::CHANGER_CONFIG_CHANGERDEV;
*CHANGER_CONFIG_CHANGERFILE = *Amanda::Configc::CHANGER_CONFIG_CHANGERFILE;
*CHANGER_CONFIG_PROPERTY = *Amanda::Configc::CHANGER_CONFIG_PROPERTY;
*CHANGER_CONFIG_DEVICE_PROPERTY = *Amanda::Configc::CHANGER_CONFIG_DEVICE_PROPERTY;
*INTERACTIVITY_COMMENT = *Amanda::Configc::INTERACTIVITY_COMMENT;
*INTERACTIVITY_PLUGIN = *Amanda::Configc::INTERACTIVITY_PLUGIN;
*INTERACTIVITY_PROPERTY = *Amanda::Configc::INTERACTIVITY_PROPERTY;
*TAPERSCAN_COMMENT = *Amanda::Configc::TAPERSCAN_COMMENT;
*TAPERSCAN_PLUGIN = *Amanda::Configc::TAPERSCAN_PLUGIN;
*TAPERSCAN_PROPERTY = *Amanda::Configc::TAPERSCAN_PROPERTY;
*HOLD_NEVER = *Amanda::Configc::HOLD_NEVER;
*HOLD_AUTO = *Amanda::Configc::HOLD_AUTO;
*HOLD_REQUIRED = *Amanda::Configc::HOLD_REQUIRED;
*COMP_NONE = *Amanda::Configc::COMP_NONE;
*COMP_FAST = *Amanda::Configc::COMP_FAST;
*COMP_BEST = *Amanda::Configc::COMP_BEST;
*COMP_CUST = *Amanda::Configc::COMP_CUST;
*COMP_SERVER_FAST = *Amanda::Configc::COMP_SERVER_FAST;
*COMP_SERVER_BEST = *Amanda::Configc::COMP_SERVER_BEST;
*COMP_SERVER_CUST = *Amanda::Configc::COMP_SERVER_CUST;
*ENCRYPT_NONE = *Amanda::Configc::ENCRYPT_NONE;
*ENCRYPT_CUST = *Amanda::Configc::ENCRYPT_CUST;
*ENCRYPT_SERV_CUST = *Amanda::Configc::ENCRYPT_SERV_CUST;
*DS_SKIP = *Amanda::Configc::DS_SKIP;
*DS_STANDARD = *Amanda::Configc::DS_STANDARD;
*DS_NOFULL = *Amanda::Configc::DS_NOFULL;
*DS_NOINC = *Amanda::Configc::DS_NOINC;
*DS_4 = *Amanda::Configc::DS_4;
*DS_5 = *Amanda::Configc::DS_5;
*DS_HANOI = *Amanda::Configc::DS_HANOI;
*DS_INCRONLY = *Amanda::Configc::DS_INCRONLY;
*ES_CLIENT = *Amanda::Configc::ES_CLIENT;
*ES_SERVER = *Amanda::Configc::ES_SERVER;
*ES_CALCSIZE = *Amanda::Configc::ES_CALCSIZE;
*AL_OTHER_CONFIG = *Amanda::Configc::AL_OTHER_CONFIG;
*AL_NON_AMANDA = *Amanda::Configc::AL_NON_AMANDA;
*AL_VOLUME_ERROR = *Amanda::Configc::AL_VOLUME_ERROR;
*AL_EMPTY = *Amanda::Configc::AL_EMPTY;
*ALGO_FIRST = *Amanda::Configc::ALGO_FIRST;
*ALGO_FIRSTFIT = *Amanda::Configc::ALGO_FIRSTFIT;
*ALGO_LARGEST = *Amanda::Configc::ALGO_LARGEST;
*ALGO_LARGESTFIT = *Amanda::Configc::ALGO_LARGESTFIT;
*ALGO_SMALLEST = *Amanda::Configc::ALGO_SMALLEST;
*ALGO_LAST = *Amanda::Configc::ALGO_LAST;
*EXECUTE_ON_PRE_AMCHECK = *Amanda::Configc::EXECUTE_ON_PRE_AMCHECK;
*EXECUTE_ON_PRE_DLE_AMCHECK = *Amanda::Configc::EXECUTE_ON_PRE_DLE_AMCHECK;
*EXECUTE_ON_PRE_HOST_AMCHECK = *Amanda::Configc::EXECUTE_ON_PRE_HOST_AMCHECK;
*EXECUTE_ON_POST_AMCHECK = *Amanda::Configc::EXECUTE_ON_POST_AMCHECK;
*EXECUTE_ON_POST_DLE_AMCHECK = *Amanda::Configc::EXECUTE_ON_POST_DLE_AMCHECK;
*EXECUTE_ON_POST_HOST_AMCHECK = *Amanda::Configc::EXECUTE_ON_POST_HOST_AMCHECK;
*EXECUTE_ON_PRE_ESTIMATE = *Amanda::Configc::EXECUTE_ON_PRE_ESTIMATE;
*EXECUTE_ON_PRE_DLE_ESTIMATE = *Amanda::Configc::EXECUTE_ON_PRE_DLE_ESTIMATE;
*EXECUTE_ON_PRE_HOST_ESTIMATE = *Amanda::Configc::EXECUTE_ON_PRE_HOST_ESTIMATE;
*EXECUTE_ON_POST_ESTIMATE = *Amanda::Configc::EXECUTE_ON_POST_ESTIMATE;
*EXECUTE_ON_POST_DLE_ESTIMATE = *Amanda::Configc::EXECUTE_ON_POST_DLE_ESTIMATE;
*EXECUTE_ON_POST_HOST_ESTIMATE = *Amanda::Configc::EXECUTE_ON_POST_HOST_ESTIMATE;
*EXECUTE_ON_PRE_BACKUP = *Amanda::Configc::EXECUTE_ON_PRE_BACKUP;
*EXECUTE_ON_PRE_DLE_BACKUP = *Amanda::Configc::EXECUTE_ON_PRE_DLE_BACKUP;
*EXECUTE_ON_PRE_HOST_BACKUP = *Amanda::Configc::EXECUTE_ON_PRE_HOST_BACKUP;
*EXECUTE_ON_POST_BACKUP = *Amanda::Configc::EXECUTE_ON_POST_BACKUP;
*EXECUTE_ON_POST_DLE_BACKUP = *Amanda::Configc::EXECUTE_ON_POST_DLE_BACKUP;
*EXECUTE_ON_POST_HOST_BACKUP = *Amanda::Configc::EXECUTE_ON_POST_HOST_BACKUP;
*SEND_AMREPORT_ALL = *Amanda::Configc::SEND_AMREPORT_ALL;
*SEND_AMREPORT_STRANGE = *Amanda::Configc::SEND_AMREPORT_STRANGE;
*SEND_AMREPORT_ERROR = *Amanda::Configc::SEND_AMREPORT_ERROR;
*SEND_AMREPORT_NEVER = *Amanda::Configc::SEND_AMREPORT_NEVER;
*DATA_PATH_AMANDA = *Amanda::Configc::DATA_PATH_AMANDA;
*DATA_PATH_DIRECTTCP = *Amanda::Configc::DATA_PATH_DIRECTTCP;
*PART_CACHE_TYPE_NONE = *Amanda::Configc::PART_CACHE_TYPE_NONE;
*PART_CACHE_TYPE_DISK = *Amanda::Configc::PART_CACHE_TYPE_DISK;
*PART_CACHE_TYPE_MEMORY = *Amanda::Configc::PART_CACHE_TYPE_MEMORY;
*debug_amandad = *Amanda::Configc::debug_amandad;
*debug_recovery = *Amanda::Configc::debug_recovery;
*debug_amidxtaped = *Amanda::Configc::debug_amidxtaped;
*debug_amindexd = *Amanda::Configc::debug_amindexd;
*debug_amrecover = *Amanda::Configc::debug_amrecover;
*debug_auth = *Amanda::Configc::debug_auth;
*debug_event = *Amanda::Configc::debug_event;
*debug_holding = *Amanda::Configc::debug_holding;
*debug_protocol = *Amanda::Configc::debug_protocol;
*debug_planner = *Amanda::Configc::debug_planner;
*debug_driver = *Amanda::Configc::debug_driver;
*debug_dumper = *Amanda::Configc::debug_dumper;
*debug_chunker = *Amanda::Configc::debug_chunker;
*debug_taper = *Amanda::Configc::debug_taper;
*debug_selfcheck = *Amanda::Configc::debug_selfcheck;
*debug_sendsize = *Amanda::Configc::debug_sendsize;
*debug_sendbackup = *Amanda::Configc::debug_sendbackup;
*CFGERR_OK = *Amanda::Configc::CFGERR_OK;
*CFGERR_WARNINGS = *Amanda::Configc::CFGERR_WARNINGS;
*CFGERR_ERRORS = *Amanda::Configc::CFGERR_ERRORS;
*CONFIG_INIT_EXPLICIT_NAME = *Amanda::Configc::CONFIG_INIT_EXPLICIT_NAME;
*CONFIG_INIT_USE_CWD = *Amanda::Configc::CONFIG_INIT_USE_CWD;
*CONFIG_INIT_CLIENT = *Amanda::Configc::CONFIG_INIT_CLIENT;
*CONFIG_INIT_OVERLAY = *Amanda::Configc::CONFIG_INIT_OVERLAY;

@EXPORT_OK = ();
%EXPORT_TAGS = ();


=head1 NAME

Amanda::Config - access to Amanda configuration parameters

=head1 SYNOPSIS

    use Amanda::Config qw( :init :getconf );

    my $config_name = shift @ARGV;
    config_init($CONFIG_INIT_EXPLICIT_NAME, $config_name);
    apply_config_overrides($config_overrides);
    my ($cfgerr_level, @cfgerr_errors) = config_errors();
    if ($cfgerr_level >= $CFGERR_WARNINGS) {
	config_print_errors();
	if ($cfgerr_level >= $CFGERR_ERRORS) {
	    die("errors processing config file");
	}
    }

    print "tape device is ", getconf($CNF_TAPEDEV), "\n";

This API closely parallels the C API.

=head1 INITIALIZATION

The Amanda configuration is treated as a global state for the
application.  It is not possible to load two configurations
simultaneously.

All initialization-related symbols can be imported with the tag
C<:init>.

=head2 LOADING CONFIGURATION

The Amanda configuration is loaded with the aptly named
C<config_init($flags, $name)>.  Because of the great variety in
invocation method among Amanda applications, this function has a number
of flags that affect its behavior.  These flags can be OR'd together.

=over

=item If C<CONFIG_INIT_EXPLICIT_NAME> is given, then the C<$name> parameter can
contain the name of a configuration to load.  Note that if the parameter is
C<".">, this is equivalent to C<CONFIG_INIT_USE_CWD>.

=item If C<CONFIG_INIT_USE_CWD> is given, and if the current directory
contains C<amanda.conf>, then that file is loaded.

=item If C<CONFIG_INIT_CLIENT> is given, then a client configuration
is loaded.

=item If C<CONFIG_INIT_OVERLAY> is given, then any existing
configuration is not reset.

=back

See C<conffile.h> for more detailed information on these flags and
their interactions.

C<config_uninit()> reverses the effects of C<config_init>.  It is
not often used.

Once the configuration is loaded, the configuration name
(e.g., "DailySet1"), directory (C</etc/amanda/DailySet1>),
and filename (C</etc/amanda/DailySet1/amanda.conf>) are
available from C<get_config_name()>, C<get_config_dir()>, and
C<get_config_filename()>, respectively.

=head3 CONFIG ERRORS

This module collects configuration errors and warnings in a list, and also
tracks the overall error level with an enumeration: C<$CFGERR_OK>,
C<$CFGERR_WARNINGS>, and C<$CFGERR_ERRORS>.  C<config_init> and
C<apply_config_overrides> both return the current level.  The level and the
list of error messages are available from C<config_errors>:

  my ($cfgerr_level, @errors) = Amanda::Config::config_errors();

As a convenience, C<config_print_errors> will print all error messages to
stderr.  The error state can be cleared with C<config_clear_errors>.

=head2 CONFIG OVERWRITES

Most Amanda applications accept the command-line option C<-o>
to "overwrite" configuration values in C<amanda.conf>.  In Perl
applications, these options should be parsed with L<Getopt::Long|Getopt::Long>, with
the action being a call to C<add_config_override_opt>.  For example:

  my $config_overrides = new_config_overrides($#ARGV+1);
    GetOptions(
	# ...
	'o=s' => sub { add_config_override_opt($config_overrides, $_[1]); },
    ) or usage();
  my $cfg_ok = config_init($CONFIG_INIT_EXPLICIT_NAME | $CONFIG_INIT_USE_CWD, $config_name);
  apply_config_overrides($config_overrides);

C<new_config_overrides($size_estimate)> creates a new
overwrites object, using the given size as an estimate of
the number of items it will contain (C<$#ARGC/2> is a good
estimate).  Individual configuration options are then added via
C<add_config_override($co, $key, $value)> (which takes a key/value
pair) or C<add_config_override_opt($co, $optarg)>, which parses a
string following C<-o> on the command line.

Once the overwrites are gathered, they are applied with
C<apply_config_overrides($co)>, which applies the overwrites to the
active configuration.  No further operations can be performed on the
overwrites object after C<apply_config_overrides> has been called.

The utility function C<get_config_options()> returns a list of
command-line arguments to represent any overwrites that were used
to generate the current configuration.  (TODO: this function isn't
available yet)

=head1 PARAMETER ACCESS

Amanda configurations consist of "global" parameters and several
sets of "subsections" -- one set for dumptypes, one for tapetypes,
and so on.

All of the global parameters are represented by a constant beginning with
C<$CNF_>, e.g., C<$CNF_LABELSTR>.  The function C<getconf($cnf)> returns the
value of parameter C<$cnf>, in whatever format is appropriate for the parameter
(see DATA FORMATS, below).  C<getconf_seen($cnf)> returns a true value if
C<$cnf> was seen in the configuration file.  If it was not seen, then it will
have its default value.  C<getconf_linenum($cnf)> returns the line number in
the configuration file where it is set, 0 if it is not in a configuration file,
or -2 if it is set in a command line argument.

Some parameters have enumerated types.  The values for those
enumerations are available from this module with the same name as
in C<conffile.h>.  For example, C<$CNF_TAPERALGO> will yield a value
from the enumeration C<taperalgo_t>, the constants for which all
begin with C<$ALGO_>.  See C<conffile.h> for the details.

Each subsection type C<TYP> has the following functions:

=over

=item C<lookup_TYP($subsec_name)>

which returns an opaque object
(C<$ss>) representing the subsection, or C<undef> if no subsection
with that name exists;

=item C<TYP_name($ss)>

returning the name of the subsection;

=item C<TYP_getconf($ss, $cnf)>

which fetches a parameter value from C<$ss>; and

=item C<TYP_seen($ss, $cnf)>

which returns a true value if <$cnf> was seen in the subsection.

=back

The subsections are:

=over

=item C<tapetype>

with constants beginning with C<$TAPETYPE_>

=item C<dumptype>

with constants beginning with C<$DUMPTYPE_>

=item C<interface>

with constants beginning with C<$INTER_>

=item C<holdingdisk>

with constants beginning with C<$HOLDING_>

=item C<application>

with constants beginning with C<$APPLICATION_>

=item C<script>

with constants beginning with C<$PP_SCRIPT_>

=item C<device>

with constants beginning with C<$DEVICE_CONFIG_>.

=item C<changer>

with constants beginning with C<$CHANGER_CONFIG_>.

=back

See C<conffile.h> for the names of the constants themselves.

=head2 DATA FORMATS

Each configuration parameter has a "conftype", as assigned in
C<common-src/conffile.c>.  The translation of most of these types into Perl
values is straightforward:

  CONFTYPE_INT                        Math::BigInt
  CONFTYPE_INT64                      Math::BigInt
  CONFTYPE_REAL                       floating-point value
  CONFTYPE_STR                        string
  CONFTYPE_IDENT                      string
  CONFTYPE_TIME                       Math::BigInt (epoch value)
  CONFTYPE_SIZE                       Math::BigInt
  CONFTYPE_BOOLEAN                    Math::BigInt
  CONFTYPE_COMPRESS                   Math::BigInt
  CONFTYPE_ENCRYPT                    Math::BigInt
  CONFTYPE_HOLDING                    Math::BigInt
  CONFTYPE_ESTIMATELIST               [ Math::BigInt, .. ]
  CONFTYPE_STRATEGY                   Math::BigInt
  CONFTYPE_TAPERALGO                  Math::BigInt
  CONFTYPE_PRIORITY                   Math::BigInt
  CONFTYPE_RATE                       float, float
  CONFTYPE_INTRANGE                   Math::BigInt, Math::BigInt
  CONFTYPE_APPLICATION                string
  CONFTYPE_EXECUTE_ON                 string
  CONFTYPE_EXECUTE_WHERE              Math::BigInt
  CONFTYPE_SEND_AMREPORT_ON           Math::BigInt
  CONFTYPE_IDENTLIST                  [ string, .. ]
  CONFTYPE_PART_CACHE_TYPE	      Math::BigInt
  CONFTYPE_RECOVERY_LIMIT             [ string, .. ] (undef if not specified;
					    undef in the list means same-host)

Note that C<CONFTYPE_INTRANGE> and C<CONFTYPE_RATE> each return two values, not
an array reference.

Include and exclude lists with type C<CONFTYPE_EXINCLUDE> return a hash giving
all listed filenames (in the C<list> key), include/exclude files (C<files>),
and a boolean indicating that the list is optional (C<optional>):

  { list => [ str, .. ], file => [ str, .. ], optional => Math::BigInt }

Properties are represented as a hash of hashes.  The keys are the property
names, converted to ASCII lowercase.  Each property has a C<values> array
giving all values specified for this property, as well as booleans C<priority>
and C<append> that are true if the corresponding keyword was supplied.

  { prop1 => { values => [ str, .. ] priority => int, append => int },
    prop2 => { .. } .. }

Note that integer types of all sizes become C<Math::BigInt> objects rather than
Perl integers, as is the habit throughout Amanda.

The C<CNF_AUTOLABEL> value is a hash with the following keys

  template	label template, or undef
  other_config	boolean
  non_amanda	boolean
  volume_error	boolean
  empty		boolean

=head2 OTHER ACCESS

Parameter values are available by name from C<getconf_byname($name)> and
C<getconf_byname_strs($name, $str_needs_quotes)>.  These functions implement
the C<TYP:NAME:PARAM> syntax advertised by C<amgetconf> to access values in
subsections.  The first function returns a Perl value (see DATA FORMATS,
above), while the second returns a list of strings suitable for use in
C<amanda.conf>, including quotes around strings if C<$str_needs_quotes> is
true.

C<getconf_list($typ)> returns a list of the names of all subsections of the
given type.  C<%subsection_names> is a hash whose keys are allowed subsection
names.

=head2 DERIVED VALUES

The C<$CNF_DISPLAYUNIT> implies a certain divisor to convert from
kilobytes to the desired unit.  This divisor is available from
C<getconf_unit_divisor()>.  Note carefully that it is a I<divisor>
for a value in I<kilobytes>!

Finally, various subsections of Amanda enable verbose debugging via
configuration parameters.  The status of each parameter is available
a similarly-named variable, e.g., C<$debug_auth>.

All parameter access functions and constants can be imported with
the tag C<:getconf>.

=head1 MISCELLANEOUS

These functions defy categorization.

The function C<config_dir_relative> will interpret a path relative to
the current configuration directory.  Absolute paths are passed through
unchanged, while relative paths are converted to absolute paths.

C<dump_configuration()> dumps the current configuration, in a format
suitable for re-evaluation for this module, to standard output.
This function may be revised to return a string.

Several parts of Amanda need to convert unit modifier value like
"gbytes" to a multiplier.  The function C<find_multiplier($str)>
returns the unit multiplier for such a string.  For example, "mbytes"
is converted to 1048576 (1024*1024).

C<string_to_boolean()> takes a string and returns 0 if it matches any of
Amanda's names for false, or 1 if matches a name for true. If it can't be
interpreted, C<undef> is returned.

C<amandaify_property_name()> converts a string into Amanda's property style:
all lower-case and with "-" replacing "_".

=head1 CONSTANTS

This section lists all of the configuration parameter constants defined in this
module.  All of these constants are available with the C<:getconf> export tag.

=cut


push @EXPORT_OK, qw(confparm_key_to_string);
push @{$EXPORT_TAGS{"confparm_key"}}, qw(confparm_key_to_string);

my %_confparm_key_VALUES;
#Convert an enum value to a single string
sub confparm_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_confparm_key_VALUES) {
	my $v = $_confparm_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $CNF_ORG $CNF_CONF $CNF_AMDUMP_SERVER $CNF_INDEX_SERVER $CNF_TAPE_SERVER $CNF_AUTH $CNF_SSH_KEYS $CNF_AMANDAD_PATH $CNF_CLIENT_USERNAME $CNF_CLIENT_PORT $CNF_GNUTAR_LIST_DIR $CNF_AMANDATES $CNF_MAILER $CNF_MAILTO $CNF_DUMPUSER $CNF_TAPEDEV $CNF_DEVICE_PROPERTY $CNF_PROPERTY $CNF_CHANGERDEV $CNF_CHANGERFILE $CNF_LABELSTR $CNF_AUTOLABEL $CNF_META_AUTOLABEL $CNF_TAPELIST $CNF_DISKFILE $CNF_INFOFILE $CNF_LOGDIR $CNF_INDEXDIR $CNF_TAPETYPE $CNF_DUMPCYCLE $CNF_RUNSPERCYCLE $CNF_TAPECYCLE $CNF_NETUSAGE $CNF_INPARALLEL $CNF_DUMPORDER $CNF_BUMPPERCENT $CNF_BUMPSIZE $CNF_BUMPMULT $CNF_BUMPDAYS $CNF_TPCHANGER $CNF_RUNTAPES $CNF_MAX_DLE_BY_VOLUME $CNF_MAXDUMPS $CNF_ETIMEOUT $CNF_DTIMEOUT $CNF_CTIMEOUT $CNF_DEVICE_OUTPUT_BUFFER_SIZE $CNF_PRINTER $CNF_AUTOFLUSH $CNF_RESERVE $CNF_MAXDUMPSIZE $CNF_COLUMNSPEC $CNF_AMRECOVER_DO_FSF $CNF_AMRECOVER_CHECK_LABEL $CNF_AMRECOVER_CHANGER $CNF_TAPERALGO $CNF_FLUSH_THRESHOLD_DUMPED $CNF_FLUSH_THRESHOLD_SCHEDULED $CNF_TAPERFLUSH $CNF_DISPLAYUNIT $CNF_KRB5KEYTAB $CNF_KRB5PRINCIPAL $CNF_LABEL_NEW_TAPES $CNF_USETIMESTAMPS $CNF_REP_TRIES $CNF_CONNECT_TRIES $CNF_REQ_TRIES $CNF_DEBUG_AMANDAD $CNF_DEBUG_RECOVERY $CNF_DEBUG_AMIDXTAPED $CNF_DEBUG_AMINDEXD $CNF_DEBUG_AMRECOVER $CNF_DEBUG_AUTH $CNF_DEBUG_EVENT $CNF_DEBUG_HOLDING $CNF_DEBUG_PROTOCOL $CNF_DEBUG_PLANNER $CNF_DEBUG_DRIVER $CNF_DEBUG_DUMPER $CNF_DEBUG_CHUNKER $CNF_DEBUG_TAPER $CNF_DEBUG_SELFCHECK $CNF_DEBUG_SENDSIZE $CNF_DEBUG_SENDBACKUP $CNF_RESERVED_UDP_PORT $CNF_RESERVED_TCP_PORT $CNF_UNRESERVED_TCP_PORT $CNF_HOLDINGDISK $CNF_SEND_AMREPORT_ON $CNF_TAPER_PARALLEL_WRITE $CNF_RECOVERY_LIMIT  $CNF_INTERACTIVITY  $CNF_TAPERSCAN  $CNF_EJECT_VOLUME);
push @{$EXPORT_TAGS{"confparm_key"}}, qw( $CNF_ORG $CNF_CONF $CNF_AMDUMP_SERVER $CNF_INDEX_SERVER $CNF_TAPE_SERVER $CNF_AUTH $CNF_SSH_KEYS $CNF_AMANDAD_PATH $CNF_CLIENT_USERNAME $CNF_CLIENT_PORT $CNF_GNUTAR_LIST_DIR $CNF_AMANDATES $CNF_MAILER $CNF_MAILTO $CNF_DUMPUSER $CNF_TAPEDEV $CNF_DEVICE_PROPERTY $CNF_PROPERTY $CNF_CHANGERDEV $CNF_CHANGERFILE $CNF_LABELSTR $CNF_AUTOLABEL $CNF_META_AUTOLABEL $CNF_TAPELIST $CNF_DISKFILE $CNF_INFOFILE $CNF_LOGDIR $CNF_INDEXDIR $CNF_TAPETYPE $CNF_DUMPCYCLE $CNF_RUNSPERCYCLE $CNF_TAPECYCLE $CNF_NETUSAGE $CNF_INPARALLEL $CNF_DUMPORDER $CNF_BUMPPERCENT $CNF_BUMPSIZE $CNF_BUMPMULT $CNF_BUMPDAYS $CNF_TPCHANGER $CNF_RUNTAPES $CNF_MAX_DLE_BY_VOLUME $CNF_MAXDUMPS $CNF_ETIMEOUT $CNF_DTIMEOUT $CNF_CTIMEOUT $CNF_DEVICE_OUTPUT_BUFFER_SIZE $CNF_PRINTER $CNF_AUTOFLUSH $CNF_RESERVE $CNF_MAXDUMPSIZE $CNF_COLUMNSPEC $CNF_AMRECOVER_DO_FSF $CNF_AMRECOVER_CHECK_LABEL $CNF_AMRECOVER_CHANGER $CNF_TAPERALGO $CNF_FLUSH_THRESHOLD_DUMPED $CNF_FLUSH_THRESHOLD_SCHEDULED $CNF_TAPERFLUSH $CNF_DISPLAYUNIT $CNF_KRB5KEYTAB $CNF_KRB5PRINCIPAL $CNF_LABEL_NEW_TAPES $CNF_USETIMESTAMPS $CNF_REP_TRIES $CNF_CONNECT_TRIES $CNF_REQ_TRIES $CNF_DEBUG_AMANDAD $CNF_DEBUG_RECOVERY $CNF_DEBUG_AMIDXTAPED $CNF_DEBUG_AMINDEXD $CNF_DEBUG_AMRECOVER $CNF_DEBUG_AUTH $CNF_DEBUG_EVENT $CNF_DEBUG_HOLDING $CNF_DEBUG_PROTOCOL $CNF_DEBUG_PLANNER $CNF_DEBUG_DRIVER $CNF_DEBUG_DUMPER $CNF_DEBUG_CHUNKER $CNF_DEBUG_TAPER $CNF_DEBUG_SELFCHECK $CNF_DEBUG_SENDSIZE $CNF_DEBUG_SENDBACKUP $CNF_RESERVED_UDP_PORT $CNF_RESERVED_TCP_PORT $CNF_UNRESERVED_TCP_PORT $CNF_HOLDINGDISK $CNF_SEND_AMREPORT_ON $CNF_TAPER_PARALLEL_WRITE $CNF_RECOVERY_LIMIT  $CNF_INTERACTIVITY  $CNF_TAPERSCAN  $CNF_EJECT_VOLUME);
      foreach (qw(  CNF_ORG CNF_CONF CNF_AMDUMP_SERVER CNF_INDEX_SERVER CNF_TAPE_SERVER CNF_AUTH CNF_SSH_KEYS CNF_AMANDAD_PATH CNF_CLIENT_USERNAME CNF_CLIENT_PORT CNF_GNUTAR_LIST_DIR CNF_AMANDATES CNF_MAILER CNF_MAILTO CNF_DUMPUSER CNF_TAPEDEV CNF_DEVICE_PROPERTY CNF_PROPERTY CNF_CHANGERDEV CNF_CHANGERFILE CNF_LABELSTR CNF_AUTOLABEL CNF_META_AUTOLABEL CNF_TAPELIST CNF_DISKFILE CNF_INFOFILE CNF_LOGDIR CNF_INDEXDIR CNF_TAPETYPE CNF_DUMPCYCLE CNF_RUNSPERCYCLE CNF_TAPECYCLE CNF_NETUSAGE CNF_INPARALLEL CNF_DUMPORDER CNF_BUMPPERCENT CNF_BUMPSIZE CNF_BUMPMULT CNF_BUMPDAYS CNF_TPCHANGER CNF_RUNTAPES CNF_MAX_DLE_BY_VOLUME CNF_MAXDUMPS CNF_ETIMEOUT CNF_DTIMEOUT CNF_CTIMEOUT CNF_DEVICE_OUTPUT_BUFFER_SIZE CNF_PRINTER CNF_AUTOFLUSH CNF_RESERVE CNF_MAXDUMPSIZE CNF_COLUMNSPEC CNF_AMRECOVER_DO_FSF CNF_AMRECOVER_CHECK_LABEL CNF_AMRECOVER_CHANGER CNF_TAPERALGO CNF_FLUSH_THRESHOLD_DUMPED CNF_FLUSH_THRESHOLD_SCHEDULED CNF_TAPERFLUSH CNF_DISPLAYUNIT CNF_KRB5KEYTAB CNF_KRB5PRINCIPAL CNF_LABEL_NEW_TAPES CNF_USETIMESTAMPS CNF_REP_TRIES CNF_CONNECT_TRIES CNF_REQ_TRIES CNF_DEBUG_AMANDAD CNF_DEBUG_RECOVERY CNF_DEBUG_AMIDXTAPED CNF_DEBUG_AMINDEXD CNF_DEBUG_AMRECOVER CNF_DEBUG_AUTH CNF_DEBUG_EVENT CNF_DEBUG_HOLDING CNF_DEBUG_PROTOCOL CNF_DEBUG_PLANNER CNF_DEBUG_DRIVER CNF_DEBUG_DUMPER CNF_DEBUG_CHUNKER CNF_DEBUG_TAPER CNF_DEBUG_SELFCHECK CNF_DEBUG_SENDSIZE CNF_DEBUG_SENDBACKUP CNF_RESERVED_UDP_PORT CNF_RESERVED_TCP_PORT CNF_UNRESERVED_TCP_PORT CNF_HOLDINGDISK CNF_SEND_AMREPORT_ON CNF_TAPER_PARALLEL_WRITE CNF_RECOVERY_LIMIT  CNF_INTERACTIVITY  CNF_TAPERSCAN  CNF_EJECT_VOLUME)) {  	$_confparm_key_VALUES{$_} = $$_;      }  
#copy symbols in confparm_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"confparm_key"}};


use Amanda::Config::FoldingHash;

=pod

Global Parameters:       C<$CNF_ORG> C<$CNF_CONF> C<$CNF_AMDUMP_SERVER> C<$CNF_INDEX_SERVER> C<$CNF_TAPE_SERVER> C<$CNF_AUTH> C<$CNF_SSH_KEYS> C<$CNF_AMANDAD_PATH> C<$CNF_CLIENT_USERNAME> C<$CNF_CLIENT_PORT> C<$CNF_GNUTAR_LIST_DIR> C<$CNF_AMANDATES> C<$CNF_MAILER> C<$CNF_MAILTO> C<$CNF_DUMPUSER> C<$CNF_TAPEDEV> C<$CNF_DEVICE_PROPERTY> C<$CNF_PROPERTY> C<$CNF_CHANGERDEV> C<$CNF_CHANGERFILE> C<$CNF_LABELSTR> C<$CNF_AUTOLABEL> C<$CNF_META_AUTOLABEL> C<$CNF_TAPELIST> C<$CNF_DISKFILE> C<$CNF_INFOFILE> C<$CNF_LOGDIR> C<$CNF_INDEXDIR> C<$CNF_TAPETYPE> C<$CNF_DUMPCYCLE> C<$CNF_RUNSPERCYCLE> C<$CNF_TAPECYCLE> C<$CNF_NETUSAGE> C<$CNF_INPARALLEL> C<$CNF_DUMPORDER> C<$CNF_BUMPPERCENT> C<$CNF_BUMPSIZE> C<$CNF_BUMPMULT> C<$CNF_BUMPDAYS> C<$CNF_TPCHANGER> C<$CNF_RUNTAPES> C<$CNF_MAX_DLE_BY_VOLUME> C<$CNF_MAXDUMPS> C<$CNF_ETIMEOUT> C<$CNF_DTIMEOUT> C<$CNF_CTIMEOUT> C<$CNF_DEVICE_OUTPUT_BUFFER_SIZE> C<$CNF_PRINTER> C<$CNF_AUTOFLUSH> C<$CNF_RESERVE> C<$CNF_MAXDUMPSIZE> C<$CNF_COLUMNSPEC> C<$CNF_AMRECOVER_DO_FSF> C<$CNF_AMRECOVER_CHECK_LABEL> C<$CNF_AMRECOVER_CHANGER> C<$CNF_TAPERALGO> C<$CNF_FLUSH_THRESHOLD_DUMPED> C<$CNF_FLUSH_THRESHOLD_SCHEDULED> C<$CNF_TAPERFLUSH> C<$CNF_DISPLAYUNIT> C<$CNF_KRB5KEYTAB> C<$CNF_KRB5PRINCIPAL> C<$CNF_LABEL_NEW_TAPES> C<$CNF_USETIMESTAMPS> C<$CNF_REP_TRIES> C<$CNF_CONNECT_TRIES> C<$CNF_REQ_TRIES> C<$CNF_DEBUG_AMANDAD> C<$CNF_DEBUG_RECOVERY> C<$CNF_DEBUG_AMIDXTAPED> C<$CNF_DEBUG_AMINDEXD> C<$CNF_DEBUG_AMRECOVER> C<$CNF_DEBUG_AUTH> C<$CNF_DEBUG_EVENT> C<$CNF_DEBUG_HOLDING> C<$CNF_DEBUG_PROTOCOL> C<$CNF_DEBUG_PLANNER> C<$CNF_DEBUG_DRIVER> C<$CNF_DEBUG_DUMPER> C<$CNF_DEBUG_CHUNKER> C<$CNF_DEBUG_TAPER> C<$CNF_DEBUG_SELFCHECK> C<$CNF_DEBUG_SENDSIZE> C<$CNF_DEBUG_SENDBACKUP> C<$CNF_RESERVED_UDP_PORT> C<$CNF_RESERVED_TCP_PORT> C<$CNF_UNRESERVED_TCP_PORT> C<$CNF_HOLDINGDISK> C<$CNF_SEND_AMREPORT_ON> C<$CNF_TAPER_PARALLEL_WRITE> C<$CNF_RECOVERY_LIMIT>  C<$CNF_INTERACTIVITY>  C<$CNF_TAPERSCAN>  C<$CNF_EJECT_VOLUME>

=cut

push @EXPORT_OK, qw(tapetype_key_to_string);
push @{$EXPORT_TAGS{"tapetype_key"}}, qw(tapetype_key_to_string);

my %_tapetype_key_VALUES;
#Convert an enum value to a single string
sub tapetype_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_tapetype_key_VALUES) {
	my $v = $_tapetype_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $TAPETYPE_COMMENT $TAPETYPE_LBL_TEMPL $TAPETYPE_BLOCKSIZE $TAPETYPE_READBLOCKSIZE $TAPETYPE_LENGTH $TAPETYPE_FILEMARK $TAPETYPE_SPEED $TAPETYPE_PART_SIZE $TAPETYPE_PART_CACHE_TYPE $TAPETYPE_PART_CACHE_DIR $TAPETYPE_PART_CACHE_MAX_SIZE);
push @{$EXPORT_TAGS{"tapetype_key"}}, qw( $TAPETYPE_COMMENT $TAPETYPE_LBL_TEMPL $TAPETYPE_BLOCKSIZE $TAPETYPE_READBLOCKSIZE $TAPETYPE_LENGTH $TAPETYPE_FILEMARK $TAPETYPE_SPEED $TAPETYPE_PART_SIZE $TAPETYPE_PART_CACHE_TYPE $TAPETYPE_PART_CACHE_DIR $TAPETYPE_PART_CACHE_MAX_SIZE);
      foreach (qw(  TAPETYPE_COMMENT TAPETYPE_LBL_TEMPL TAPETYPE_BLOCKSIZE TAPETYPE_READBLOCKSIZE TAPETYPE_LENGTH TAPETYPE_FILEMARK TAPETYPE_SPEED TAPETYPE_PART_SIZE TAPETYPE_PART_CACHE_TYPE TAPETYPE_PART_CACHE_DIR TAPETYPE_PART_CACHE_MAX_SIZE)) {  	$_tapetype_key_VALUES{$_} = $$_;      }  
#copy symbols in tapetype_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"tapetype_key"}};


use Amanda::Config::FoldingHash;

=pod

Tapetype Parameters:       C<$TAPETYPE_COMMENT> C<$TAPETYPE_LBL_TEMPL> C<$TAPETYPE_BLOCKSIZE> C<$TAPETYPE_READBLOCKSIZE> C<$TAPETYPE_LENGTH> C<$TAPETYPE_FILEMARK> C<$TAPETYPE_SPEED> C<$TAPETYPE_PART_SIZE> C<$TAPETYPE_PART_CACHE_TYPE> C<$TAPETYPE_PART_CACHE_DIR> C<$TAPETYPE_PART_CACHE_MAX_SIZE>

=cut

push @EXPORT_OK, qw(dumptype_key_to_string);
push @{$EXPORT_TAGS{"dumptype_key"}}, qw(dumptype_key_to_string);

my %_dumptype_key_VALUES;
#Convert an enum value to a single string
sub dumptype_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_dumptype_key_VALUES) {
	my $v = $_dumptype_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $DUMPTYPE_COMMENT $DUMPTYPE_PROGRAM $DUMPTYPE_SRVCOMPPROG $DUMPTYPE_CLNTCOMPPROG $DUMPTYPE_SRV_ENCRYPT $DUMPTYPE_CLNT_ENCRYPT $DUMPTYPE_AMANDAD_PATH $DUMPTYPE_CLIENT_USERNAME $DUMPTYPE_CLIENT_PORT $DUMPTYPE_SSH_KEYS $DUMPTYPE_AUTH $DUMPTYPE_EXCLUDE $DUMPTYPE_INCLUDE $DUMPTYPE_PRIORITY $DUMPTYPE_DUMPCYCLE $DUMPTYPE_MAXDUMPS $DUMPTYPE_MAXPROMOTEDAY $DUMPTYPE_BUMPPERCENT $DUMPTYPE_BUMPSIZE $DUMPTYPE_BUMPDAYS $DUMPTYPE_BUMPMULT $DUMPTYPE_STARTTIME $DUMPTYPE_STRATEGY $DUMPTYPE_ESTIMATELIST $DUMPTYPE_COMPRESS $DUMPTYPE_ENCRYPT $DUMPTYPE_SRV_DECRYPT_OPT $DUMPTYPE_CLNT_DECRYPT_OPT $DUMPTYPE_COMPRATE $DUMPTYPE_TAPE_SPLITSIZE $DUMPTYPE_FALLBACK_SPLITSIZE $DUMPTYPE_SPLIT_DISKBUFFER $DUMPTYPE_RECORD $DUMPTYPE_SKIP_INCR $DUMPTYPE_SKIP_FULL $DUMPTYPE_HOLDINGDISK $DUMPTYPE_KENCRYPT $DUMPTYPE_IGNORE $DUMPTYPE_INDEX $DUMPTYPE_APPLICATION $DUMPTYPE_SCRIPTLIST $DUMPTYPE_PROPERTY $DUMPTYPE_DATA_PATH $DUMPTYPE_ALLOW_SPLIT $DUMPTYPE_RECOVERY_LIMIT  $DUMPTYPE_DUMP_LIMIT);
push @{$EXPORT_TAGS{"dumptype_key"}}, qw( $DUMPTYPE_COMMENT $DUMPTYPE_PROGRAM $DUMPTYPE_SRVCOMPPROG $DUMPTYPE_CLNTCOMPPROG $DUMPTYPE_SRV_ENCRYPT $DUMPTYPE_CLNT_ENCRYPT $DUMPTYPE_AMANDAD_PATH $DUMPTYPE_CLIENT_USERNAME $DUMPTYPE_CLIENT_PORT $DUMPTYPE_SSH_KEYS $DUMPTYPE_AUTH $DUMPTYPE_EXCLUDE $DUMPTYPE_INCLUDE $DUMPTYPE_PRIORITY $DUMPTYPE_DUMPCYCLE $DUMPTYPE_MAXDUMPS $DUMPTYPE_MAXPROMOTEDAY $DUMPTYPE_BUMPPERCENT $DUMPTYPE_BUMPSIZE $DUMPTYPE_BUMPDAYS $DUMPTYPE_BUMPMULT $DUMPTYPE_STARTTIME $DUMPTYPE_STRATEGY $DUMPTYPE_ESTIMATELIST $DUMPTYPE_COMPRESS $DUMPTYPE_ENCRYPT $DUMPTYPE_SRV_DECRYPT_OPT $DUMPTYPE_CLNT_DECRYPT_OPT $DUMPTYPE_COMPRATE $DUMPTYPE_TAPE_SPLITSIZE $DUMPTYPE_FALLBACK_SPLITSIZE $DUMPTYPE_SPLIT_DISKBUFFER $DUMPTYPE_RECORD $DUMPTYPE_SKIP_INCR $DUMPTYPE_SKIP_FULL $DUMPTYPE_HOLDINGDISK $DUMPTYPE_KENCRYPT $DUMPTYPE_IGNORE $DUMPTYPE_INDEX $DUMPTYPE_APPLICATION $DUMPTYPE_SCRIPTLIST $DUMPTYPE_PROPERTY $DUMPTYPE_DATA_PATH $DUMPTYPE_ALLOW_SPLIT $DUMPTYPE_RECOVERY_LIMIT  $DUMPTYPE_DUMP_LIMIT);
      foreach (qw(  DUMPTYPE_COMMENT DUMPTYPE_PROGRAM DUMPTYPE_SRVCOMPPROG DUMPTYPE_CLNTCOMPPROG DUMPTYPE_SRV_ENCRYPT DUMPTYPE_CLNT_ENCRYPT DUMPTYPE_AMANDAD_PATH DUMPTYPE_CLIENT_USERNAME DUMPTYPE_CLIENT_PORT DUMPTYPE_SSH_KEYS DUMPTYPE_AUTH DUMPTYPE_EXCLUDE DUMPTYPE_INCLUDE DUMPTYPE_PRIORITY DUMPTYPE_DUMPCYCLE DUMPTYPE_MAXDUMPS DUMPTYPE_MAXPROMOTEDAY DUMPTYPE_BUMPPERCENT DUMPTYPE_BUMPSIZE DUMPTYPE_BUMPDAYS DUMPTYPE_BUMPMULT DUMPTYPE_STARTTIME DUMPTYPE_STRATEGY DUMPTYPE_ESTIMATELIST DUMPTYPE_COMPRESS DUMPTYPE_ENCRYPT DUMPTYPE_SRV_DECRYPT_OPT DUMPTYPE_CLNT_DECRYPT_OPT DUMPTYPE_COMPRATE DUMPTYPE_TAPE_SPLITSIZE DUMPTYPE_FALLBACK_SPLITSIZE DUMPTYPE_SPLIT_DISKBUFFER DUMPTYPE_RECORD DUMPTYPE_SKIP_INCR DUMPTYPE_SKIP_FULL DUMPTYPE_HOLDINGDISK DUMPTYPE_KENCRYPT DUMPTYPE_IGNORE DUMPTYPE_INDEX DUMPTYPE_APPLICATION DUMPTYPE_SCRIPTLIST DUMPTYPE_PROPERTY DUMPTYPE_DATA_PATH DUMPTYPE_ALLOW_SPLIT DUMPTYPE_RECOVERY_LIMIT  DUMPTYPE_DUMP_LIMIT)) {  	$_dumptype_key_VALUES{$_} = $$_;      }  
#copy symbols in dumptype_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"dumptype_key"}};


use Amanda::Config::FoldingHash;

=pod

Dumptype Parameters:       C<$DUMPTYPE_COMMENT> C<$DUMPTYPE_PROGRAM> C<$DUMPTYPE_SRVCOMPPROG> C<$DUMPTYPE_CLNTCOMPPROG> C<$DUMPTYPE_SRV_ENCRYPT> C<$DUMPTYPE_CLNT_ENCRYPT> C<$DUMPTYPE_AMANDAD_PATH> C<$DUMPTYPE_CLIENT_USERNAME> C<$DUMPTYPE_CLIENT_PORT> C<$DUMPTYPE_SSH_KEYS> C<$DUMPTYPE_AUTH> C<$DUMPTYPE_EXCLUDE> C<$DUMPTYPE_INCLUDE> C<$DUMPTYPE_PRIORITY> C<$DUMPTYPE_DUMPCYCLE> C<$DUMPTYPE_MAXDUMPS> C<$DUMPTYPE_MAXPROMOTEDAY> C<$DUMPTYPE_BUMPPERCENT> C<$DUMPTYPE_BUMPSIZE> C<$DUMPTYPE_BUMPDAYS> C<$DUMPTYPE_BUMPMULT> C<$DUMPTYPE_STARTTIME> C<$DUMPTYPE_STRATEGY> C<$DUMPTYPE_ESTIMATELIST> C<$DUMPTYPE_COMPRESS> C<$DUMPTYPE_ENCRYPT> C<$DUMPTYPE_SRV_DECRYPT_OPT> C<$DUMPTYPE_CLNT_DECRYPT_OPT> C<$DUMPTYPE_COMPRATE> C<$DUMPTYPE_TAPE_SPLITSIZE> C<$DUMPTYPE_FALLBACK_SPLITSIZE> C<$DUMPTYPE_SPLIT_DISKBUFFER> C<$DUMPTYPE_RECORD> C<$DUMPTYPE_SKIP_INCR> C<$DUMPTYPE_SKIP_FULL> C<$DUMPTYPE_HOLDINGDISK> C<$DUMPTYPE_KENCRYPT> C<$DUMPTYPE_IGNORE> C<$DUMPTYPE_INDEX> C<$DUMPTYPE_APPLICATION> C<$DUMPTYPE_SCRIPTLIST> C<$DUMPTYPE_PROPERTY> C<$DUMPTYPE_DATA_PATH> C<$DUMPTYPE_ALLOW_SPLIT> C<$DUMPTYPE_RECOVERY_LIMIT>  C<$DUMPTYPE_DUMP_LIMIT>

=cut

push @EXPORT_OK, qw(interface_key_to_string);
push @{$EXPORT_TAGS{"interface_key"}}, qw(interface_key_to_string);

my %_interface_key_VALUES;
#Convert an enum value to a single string
sub interface_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_interface_key_VALUES) {
	my $v = $_interface_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $INTER_COMMENT $INTER_MAXUSAGE);
push @{$EXPORT_TAGS{"interface_key"}}, qw( $INTER_COMMENT $INTER_MAXUSAGE);
      foreach (qw(  INTER_COMMENT INTER_MAXUSAGE)) {  	$_interface_key_VALUES{$_} = $$_;      }  
#copy symbols in interface_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"interface_key"}};


use Amanda::Config::FoldingHash;

=pod

Dumptype Parameters:       C<$INTER_COMMENT> C<$INTER_MAXUSAGE>

=cut

push @EXPORT_OK, qw(holdingdisk_key_to_string);
push @{$EXPORT_TAGS{"holdingdisk_key"}}, qw(holdingdisk_key_to_string);

my %_holdingdisk_key_VALUES;
#Convert an enum value to a single string
sub holdingdisk_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_holdingdisk_key_VALUES) {
	my $v = $_holdingdisk_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $HOLDING_COMMENT $HOLDING_DISKDIR $HOLDING_DISKSIZE $HOLDING_CHUNKSIZE);
push @{$EXPORT_TAGS{"holdingdisk_key"}}, qw( $HOLDING_COMMENT $HOLDING_DISKDIR $HOLDING_DISKSIZE $HOLDING_CHUNKSIZE);
      foreach (qw(  HOLDING_COMMENT HOLDING_DISKDIR HOLDING_DISKSIZE HOLDING_CHUNKSIZE)) {  	$_holdingdisk_key_VALUES{$_} = $$_;      }  
#copy symbols in holdingdisk_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"holdingdisk_key"}};


use Amanda::Config::FoldingHash;

=pod

Holdingdisk Parameters:       C<$HOLDING_COMMENT> C<$HOLDING_DISKDIR> C<$HOLDING_DISKSIZE> C<$HOLDING_CHUNKSIZE>

=cut

push @EXPORT_OK, qw(application_key_to_string);
push @{$EXPORT_TAGS{"application_key"}}, qw(application_key_to_string);

my %_application_key_VALUES;
#Convert an enum value to a single string
sub application_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_application_key_VALUES) {
	my $v = $_application_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $APPLICATION_COMMENT $APPLICATION_PLUGIN $APPLICATION_PROPERTY  $APPLICATION_CLIENT_NAME);
push @{$EXPORT_TAGS{"application_key"}}, qw( $APPLICATION_COMMENT $APPLICATION_PLUGIN $APPLICATION_PROPERTY  $APPLICATION_CLIENT_NAME);
      foreach (qw(  APPLICATION_COMMENT APPLICATION_PLUGIN APPLICATION_PROPERTY  APPLICATION_CLIENT_NAME)) {  	$_application_key_VALUES{$_} = $$_;      }  
#copy symbols in application_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"application_key"}};


use Amanda::Config::FoldingHash;

=pod

Application Parameters:       C<$APPLICATION_COMMENT> C<$APPLICATION_PLUGIN> C<$APPLICATION_PROPERTY>  C<$APPLICATION_CLIENT_NAME>

=cut

push @EXPORT_OK, qw(pp_script_key_to_string);
push @{$EXPORT_TAGS{"pp_script_key"}}, qw(pp_script_key_to_string);

my %_pp_script_key_VALUES;
#Convert an enum value to a single string
sub pp_script_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_pp_script_key_VALUES) {
	my $v = $_pp_script_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $PP_SCRIPT_COMMENT $PP_SCRIPT_PLUGIN $PP_SCRIPT_PROPERTY $PP_SCRIPT_EXECUTE_ON $PP_SCRIPT_EXECUTE_WHERE $PP_SCRIPT_ORDER $PP_SCRIPT_SINGLE_EXECUTION $PP_SCRIPT_CLIENT_NAME);
push @{$EXPORT_TAGS{"pp_script_key"}}, qw( $PP_SCRIPT_COMMENT $PP_SCRIPT_PLUGIN $PP_SCRIPT_PROPERTY $PP_SCRIPT_EXECUTE_ON $PP_SCRIPT_EXECUTE_WHERE $PP_SCRIPT_ORDER $PP_SCRIPT_SINGLE_EXECUTION $PP_SCRIPT_CLIENT_NAME);
      foreach (qw(  PP_SCRIPT_COMMENT PP_SCRIPT_PLUGIN PP_SCRIPT_PROPERTY PP_SCRIPT_EXECUTE_ON PP_SCRIPT_EXECUTE_WHERE PP_SCRIPT_ORDER PP_SCRIPT_SINGLE_EXECUTION PP_SCRIPT_CLIENT_NAME)) {  	$_pp_script_key_VALUES{$_} = $$_;      }  
#copy symbols in pp_script_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"pp_script_key"}};


use Amanda::Config::FoldingHash;

=pod

Pre/Post-Script Parameters:       C<$PP_SCRIPT_COMMENT> C<$PP_SCRIPT_PLUGIN> C<$PP_SCRIPT_PROPERTY> C<$PP_SCRIPT_EXECUTE_ON> C<$PP_SCRIPT_EXECUTE_WHERE> C<$PP_SCRIPT_ORDER> C<$PP_SCRIPT_SINGLE_EXECUTION> C<$PP_SCRIPT_CLIENT_NAME>

=cut

push @EXPORT_OK, qw(device_config_key_to_string);
push @{$EXPORT_TAGS{"device_config_key"}}, qw(device_config_key_to_string);

my %_device_config_key_VALUES;
#Convert an enum value to a single string
sub device_config_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_device_config_key_VALUES) {
	my $v = $_device_config_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $DEVICE_CONFIG_COMMENT $DEVICE_CONFIG_TAPEDEV $DEVICE_CONFIG_DEVICE_PROPERTY);
push @{$EXPORT_TAGS{"device_config_key"}}, qw( $DEVICE_CONFIG_COMMENT $DEVICE_CONFIG_TAPEDEV $DEVICE_CONFIG_DEVICE_PROPERTY);
      foreach (qw(  DEVICE_CONFIG_COMMENT DEVICE_CONFIG_TAPEDEV DEVICE_CONFIG_DEVICE_PROPERTY)) {  	$_device_config_key_VALUES{$_} = $$_;      }  
#copy symbols in device_config_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"device_config_key"}};


use Amanda::Config::FoldingHash;

=pod

Pre/Post-Script Parameters:       C<$DEVICE_CONFIG_COMMENT> C<$DEVICE_CONFIG_TAPEDEV> C<$DEVICE_CONFIG_DEVICE_PROPERTY>

=cut

push @EXPORT_OK, qw(changer_config_key_to_string);
push @{$EXPORT_TAGS{"changer_config_key"}}, qw(changer_config_key_to_string);

my %_changer_config_key_VALUES;
#Convert an enum value to a single string
sub changer_config_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_changer_config_key_VALUES) {
	my $v = $_changer_config_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $CHANGER_CONFIG_COMMENT $CHANGER_CONFIG_TAPEDEV $CHANGER_CONFIG_TPCHANGER $CHANGER_CONFIG_CHANGERDEV $CHANGER_CONFIG_CHANGERFILE $CHANGER_CONFIG_PROPERTY $CHANGER_CONFIG_DEVICE_PROPERTY);
push @{$EXPORT_TAGS{"changer_config_key"}}, qw( $CHANGER_CONFIG_COMMENT $CHANGER_CONFIG_TAPEDEV $CHANGER_CONFIG_TPCHANGER $CHANGER_CONFIG_CHANGERDEV $CHANGER_CONFIG_CHANGERFILE $CHANGER_CONFIG_PROPERTY $CHANGER_CONFIG_DEVICE_PROPERTY);
      foreach (qw(  CHANGER_CONFIG_COMMENT CHANGER_CONFIG_TAPEDEV CHANGER_CONFIG_TPCHANGER CHANGER_CONFIG_CHANGERDEV CHANGER_CONFIG_CHANGERFILE CHANGER_CONFIG_PROPERTY CHANGER_CONFIG_DEVICE_PROPERTY)) {  	$_changer_config_key_VALUES{$_} = $$_;      }  
#copy symbols in changer_config_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"changer_config_key"}};


use Amanda::Config::FoldingHash;

=pod

Pre/Post-Script Parameters:       C<$CHANGER_CONFIG_COMMENT> C<$CHANGER_CONFIG_TAPEDEV> C<$CHANGER_CONFIG_TPCHANGER> C<$CHANGER_CONFIG_CHANGERDEV> C<$CHANGER_CONFIG_CHANGERFILE> C<$CHANGER_CONFIG_PROPERTY> C<$CHANGER_CONFIG_DEVICE_PROPERTY>

=cut

push @EXPORT_OK, qw(interactivity_key_to_string);
push @{$EXPORT_TAGS{"interactivity_key"}}, qw(interactivity_key_to_string);

my %_interactivity_key_VALUES;
#Convert an enum value to a single string
sub interactivity_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_interactivity_key_VALUES) {
	my $v = $_interactivity_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $INTERACTIVITY_COMMENT $INTERACTIVITY_PLUGIN $INTERACTIVITY_PROPERTY);
push @{$EXPORT_TAGS{"interactivity_key"}}, qw( $INTERACTIVITY_COMMENT $INTERACTIVITY_PLUGIN $INTERACTIVITY_PROPERTY);
      foreach (qw(  INTERACTIVITY_COMMENT INTERACTIVITY_PLUGIN INTERACTIVITY_PROPERTY)) {  	$_interactivity_key_VALUES{$_} = $$_;      }  
#copy symbols in interactivity_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"interactivity_key"}};


use Amanda::Config::FoldingHash;

=pod

Interactivity Parameters:       C<$INTERACTIVITY_COMMENT> C<$INTERACTIVITY_PLUGIN> C<$INTERACTIVITY_PROPERTY>

=cut

push @EXPORT_OK, qw(taperscan_key_to_string);
push @{$EXPORT_TAGS{"taperscan_key"}}, qw(taperscan_key_to_string);

my %_taperscan_key_VALUES;
#Convert an enum value to a single string
sub taperscan_key_to_string {
    my ($enumval) = @_;

    for my $k (keys %_taperscan_key_VALUES) {
	my $v = $_taperscan_key_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw( $TAPERSCAN_COMMENT $TAPERSCAN_PLUGIN $TAPERSCAN_PROPERTY);
push @{$EXPORT_TAGS{"taperscan_key"}}, qw( $TAPERSCAN_COMMENT $TAPERSCAN_PLUGIN $TAPERSCAN_PROPERTY);
      foreach (qw(  TAPERSCAN_COMMENT TAPERSCAN_PLUGIN TAPERSCAN_PROPERTY)) {  	$_taperscan_key_VALUES{$_} = $$_;      }  
#copy symbols in taperscan_key to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"taperscan_key"}};


use Amanda::Config::FoldingHash;

=pod

Taperscan Parameters:       C<$TAPERSCAN_COMMENT> C<$TAPERSCAN_PLUGIN> C<$TAPERSCAN_PROPERTY>

=cut

push @EXPORT_OK, qw(dump_holdingdisk_t_to_string);
push @{$EXPORT_TAGS{"dump_holdingdisk_t"}}, qw(dump_holdingdisk_t_to_string);

my %_dump_holdingdisk_t_VALUES;
#Convert an enum value to a single string
sub dump_holdingdisk_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_dump_holdingdisk_t_VALUES) {
	my $v = $_dump_holdingdisk_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($HOLD_NEVER);
push @{$EXPORT_TAGS{"dump_holdingdisk_t"}}, qw($HOLD_NEVER);

$_dump_holdingdisk_t_VALUES{"HOLD_NEVER"} = $HOLD_NEVER;

push @EXPORT_OK, qw($HOLD_AUTO);
push @{$EXPORT_TAGS{"dump_holdingdisk_t"}}, qw($HOLD_AUTO);

$_dump_holdingdisk_t_VALUES{"HOLD_AUTO"} = $HOLD_AUTO;

push @EXPORT_OK, qw($HOLD_REQUIRED);
push @{$EXPORT_TAGS{"dump_holdingdisk_t"}}, qw($HOLD_REQUIRED);

$_dump_holdingdisk_t_VALUES{"HOLD_REQUIRED"} = $HOLD_REQUIRED;

#copy symbols in dump_holdingdisk_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"dump_holdingdisk_t"}};

push @EXPORT_OK, qw(comp_t_to_string);
push @{$EXPORT_TAGS{"comp_t"}}, qw(comp_t_to_string);

my %_comp_t_VALUES;
#Convert an enum value to a single string
sub comp_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_comp_t_VALUES) {
	my $v = $_comp_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($COMP_NONE);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_NONE);

$_comp_t_VALUES{"COMP_NONE"} = $COMP_NONE;

push @EXPORT_OK, qw($COMP_FAST);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_FAST);

$_comp_t_VALUES{"COMP_FAST"} = $COMP_FAST;

push @EXPORT_OK, qw($COMP_BEST);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_BEST);

$_comp_t_VALUES{"COMP_BEST"} = $COMP_BEST;

push @EXPORT_OK, qw($COMP_CUST);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_CUST);

$_comp_t_VALUES{"COMP_CUST"} = $COMP_CUST;

push @EXPORT_OK, qw($COMP_SERVER_FAST);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_SERVER_FAST);

$_comp_t_VALUES{"COMP_SERVER_FAST"} = $COMP_SERVER_FAST;

push @EXPORT_OK, qw($COMP_SERVER_BEST);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_SERVER_BEST);

$_comp_t_VALUES{"COMP_SERVER_BEST"} = $COMP_SERVER_BEST;

push @EXPORT_OK, qw($COMP_SERVER_CUST);
push @{$EXPORT_TAGS{"comp_t"}}, qw($COMP_SERVER_CUST);

$_comp_t_VALUES{"COMP_SERVER_CUST"} = $COMP_SERVER_CUST;

#copy symbols in comp_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"comp_t"}};

push @EXPORT_OK, qw(encrypt_t_to_string);
push @{$EXPORT_TAGS{"encrypt_t"}}, qw(encrypt_t_to_string);

my %_encrypt_t_VALUES;
#Convert an enum value to a single string
sub encrypt_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_encrypt_t_VALUES) {
	my $v = $_encrypt_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($ENCRYPT_NONE);
push @{$EXPORT_TAGS{"encrypt_t"}}, qw($ENCRYPT_NONE);

$_encrypt_t_VALUES{"ENCRYPT_NONE"} = $ENCRYPT_NONE;

push @EXPORT_OK, qw($ENCRYPT_CUST);
push @{$EXPORT_TAGS{"encrypt_t"}}, qw($ENCRYPT_CUST);

$_encrypt_t_VALUES{"ENCRYPT_CUST"} = $ENCRYPT_CUST;

push @EXPORT_OK, qw($ENCRYPT_SERV_CUST);
push @{$EXPORT_TAGS{"encrypt_t"}}, qw($ENCRYPT_SERV_CUST);

$_encrypt_t_VALUES{"ENCRYPT_SERV_CUST"} = $ENCRYPT_SERV_CUST;

#copy symbols in encrypt_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"encrypt_t"}};

push @EXPORT_OK, qw(strategy_t_to_string);
push @{$EXPORT_TAGS{"strategy_t"}}, qw(strategy_t_to_string);

my %_strategy_t_VALUES;
#Convert an enum value to a single string
sub strategy_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_strategy_t_VALUES) {
	my $v = $_strategy_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($DS_SKIP);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_SKIP);

$_strategy_t_VALUES{"DS_SKIP"} = $DS_SKIP;

push @EXPORT_OK, qw($DS_STANDARD);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_STANDARD);

$_strategy_t_VALUES{"DS_STANDARD"} = $DS_STANDARD;

push @EXPORT_OK, qw($DS_NOFULL);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_NOFULL);

$_strategy_t_VALUES{"DS_NOFULL"} = $DS_NOFULL;

push @EXPORT_OK, qw($DS_NOINC);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_NOINC);

$_strategy_t_VALUES{"DS_NOINC"} = $DS_NOINC;

push @EXPORT_OK, qw($DS_4);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_4);

$_strategy_t_VALUES{"DS_4"} = $DS_4;

push @EXPORT_OK, qw($DS_5);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_5);

$_strategy_t_VALUES{"DS_5"} = $DS_5;

push @EXPORT_OK, qw($DS_HANOI);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_HANOI);

$_strategy_t_VALUES{"DS_HANOI"} = $DS_HANOI;

push @EXPORT_OK, qw($DS_INCRONLY);
push @{$EXPORT_TAGS{"strategy_t"}}, qw($DS_INCRONLY);

$_strategy_t_VALUES{"DS_INCRONLY"} = $DS_INCRONLY;

#copy symbols in strategy_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"strategy_t"}};

push @EXPORT_OK, qw(estimate_t_to_string);
push @{$EXPORT_TAGS{"estimate_t"}}, qw(estimate_t_to_string);

my %_estimate_t_VALUES;
#Convert an enum value to a single string
sub estimate_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_estimate_t_VALUES) {
	my $v = $_estimate_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($ES_CLIENT);
push @{$EXPORT_TAGS{"estimate_t"}}, qw($ES_CLIENT);

$_estimate_t_VALUES{"ES_CLIENT"} = $ES_CLIENT;

push @EXPORT_OK, qw($ES_SERVER);
push @{$EXPORT_TAGS{"estimate_t"}}, qw($ES_SERVER);

$_estimate_t_VALUES{"ES_SERVER"} = $ES_SERVER;

push @EXPORT_OK, qw($ES_CALCSIZE);
push @{$EXPORT_TAGS{"estimate_t"}}, qw($ES_CALCSIZE);

$_estimate_t_VALUES{"ES_CALCSIZE"} = $ES_CALCSIZE;

#copy symbols in estimate_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"estimate_t"}};

push @EXPORT_OK, qw(autolabel_enum_t_to_string);
push @{$EXPORT_TAGS{"autolabel_enum_t"}}, qw(autolabel_enum_t_to_string);

my %_autolabel_enum_t_VALUES;
#Convert an enum value to a single string
sub autolabel_enum_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_autolabel_enum_t_VALUES) {
	my $v = $_autolabel_enum_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($AL_OTHER_CONFIG);
push @{$EXPORT_TAGS{"autolabel_enum_t"}}, qw($AL_OTHER_CONFIG);

$_autolabel_enum_t_VALUES{"AL_OTHER_CONFIG"} = $AL_OTHER_CONFIG;

push @EXPORT_OK, qw($AL_NON_AMANDA);
push @{$EXPORT_TAGS{"autolabel_enum_t"}}, qw($AL_NON_AMANDA);

$_autolabel_enum_t_VALUES{"AL_NON_AMANDA"} = $AL_NON_AMANDA;

push @EXPORT_OK, qw($AL_VOLUME_ERROR);
push @{$EXPORT_TAGS{"autolabel_enum_t"}}, qw($AL_VOLUME_ERROR);

$_autolabel_enum_t_VALUES{"AL_VOLUME_ERROR"} = $AL_VOLUME_ERROR;

push @EXPORT_OK, qw($AL_EMPTY);
push @{$EXPORT_TAGS{"autolabel_enum_t"}}, qw($AL_EMPTY);

$_autolabel_enum_t_VALUES{"AL_EMPTY"} = $AL_EMPTY;

#copy symbols in autolabel_enum_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"autolabel_enum_t"}};

push @EXPORT_OK, qw(taperalgo_t_to_string);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw(taperalgo_t_to_string);

my %_taperalgo_t_VALUES;
#Convert an enum value to a single string
sub taperalgo_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_taperalgo_t_VALUES) {
	my $v = $_taperalgo_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($ALGO_FIRST);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw($ALGO_FIRST);

$_taperalgo_t_VALUES{"ALGO_FIRST"} = $ALGO_FIRST;

push @EXPORT_OK, qw($ALGO_FIRSTFIT);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw($ALGO_FIRSTFIT);

$_taperalgo_t_VALUES{"ALGO_FIRSTFIT"} = $ALGO_FIRSTFIT;

push @EXPORT_OK, qw($ALGO_LARGEST);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw($ALGO_LARGEST);

$_taperalgo_t_VALUES{"ALGO_LARGEST"} = $ALGO_LARGEST;

push @EXPORT_OK, qw($ALGO_LARGESTFIT);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw($ALGO_LARGESTFIT);

$_taperalgo_t_VALUES{"ALGO_LARGESTFIT"} = $ALGO_LARGESTFIT;

push @EXPORT_OK, qw($ALGO_SMALLEST);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw($ALGO_SMALLEST);

$_taperalgo_t_VALUES{"ALGO_SMALLEST"} = $ALGO_SMALLEST;

push @EXPORT_OK, qw($ALGO_LAST);
push @{$EXPORT_TAGS{"taperalgo_t"}}, qw($ALGO_LAST);

$_taperalgo_t_VALUES{"ALGO_LAST"} = $ALGO_LAST;

#copy symbols in taperalgo_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"taperalgo_t"}};

push @EXPORT_OK, qw(execute_on_t_to_string);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw(execute_on_t_to_string);

my %_execute_on_t_VALUES;
#Convert an enum value to a single string
sub execute_on_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_execute_on_t_VALUES) {
	my $v = $_execute_on_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($EXECUTE_ON_PRE_AMCHECK);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_AMCHECK);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_AMCHECK"} = $EXECUTE_ON_PRE_AMCHECK;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_DLE_AMCHECK);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_DLE_AMCHECK);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_DLE_AMCHECK"} = $EXECUTE_ON_PRE_DLE_AMCHECK;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_HOST_AMCHECK);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_HOST_AMCHECK);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_HOST_AMCHECK"} = $EXECUTE_ON_PRE_HOST_AMCHECK;

push @EXPORT_OK, qw($EXECUTE_ON_POST_AMCHECK);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_AMCHECK);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_AMCHECK"} = $EXECUTE_ON_POST_AMCHECK;

push @EXPORT_OK, qw($EXECUTE_ON_POST_DLE_AMCHECK);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_DLE_AMCHECK);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_DLE_AMCHECK"} = $EXECUTE_ON_POST_DLE_AMCHECK;

push @EXPORT_OK, qw($EXECUTE_ON_POST_HOST_AMCHECK);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_HOST_AMCHECK);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_HOST_AMCHECK"} = $EXECUTE_ON_POST_HOST_AMCHECK;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_ESTIMATE);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_ESTIMATE);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_ESTIMATE"} = $EXECUTE_ON_PRE_ESTIMATE;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_DLE_ESTIMATE);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_DLE_ESTIMATE);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_DLE_ESTIMATE"} = $EXECUTE_ON_PRE_DLE_ESTIMATE;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_HOST_ESTIMATE);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_HOST_ESTIMATE);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_HOST_ESTIMATE"} = $EXECUTE_ON_PRE_HOST_ESTIMATE;

push @EXPORT_OK, qw($EXECUTE_ON_POST_ESTIMATE);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_ESTIMATE);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_ESTIMATE"} = $EXECUTE_ON_POST_ESTIMATE;

push @EXPORT_OK, qw($EXECUTE_ON_POST_DLE_ESTIMATE);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_DLE_ESTIMATE);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_DLE_ESTIMATE"} = $EXECUTE_ON_POST_DLE_ESTIMATE;

push @EXPORT_OK, qw($EXECUTE_ON_POST_HOST_ESTIMATE);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_HOST_ESTIMATE);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_HOST_ESTIMATE"} = $EXECUTE_ON_POST_HOST_ESTIMATE;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_BACKUP);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_BACKUP);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_BACKUP"} = $EXECUTE_ON_PRE_BACKUP;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_DLE_BACKUP);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_DLE_BACKUP);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_DLE_BACKUP"} = $EXECUTE_ON_PRE_DLE_BACKUP;

push @EXPORT_OK, qw($EXECUTE_ON_PRE_HOST_BACKUP);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_PRE_HOST_BACKUP);

$_execute_on_t_VALUES{"EXECUTE_ON_PRE_HOST_BACKUP"} = $EXECUTE_ON_PRE_HOST_BACKUP;

push @EXPORT_OK, qw($EXECUTE_ON_POST_BACKUP);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_BACKUP);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_BACKUP"} = $EXECUTE_ON_POST_BACKUP;

push @EXPORT_OK, qw($EXECUTE_ON_POST_DLE_BACKUP);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_DLE_BACKUP);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_DLE_BACKUP"} = $EXECUTE_ON_POST_DLE_BACKUP;

push @EXPORT_OK, qw($EXECUTE_ON_POST_HOST_BACKUP);
push @{$EXPORT_TAGS{"execute_on_t"}}, qw($EXECUTE_ON_POST_HOST_BACKUP);

$_execute_on_t_VALUES{"EXECUTE_ON_POST_HOST_BACKUP"} = $EXECUTE_ON_POST_HOST_BACKUP;

#copy symbols in execute_on_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"execute_on_t"}};

push @EXPORT_OK, qw(send_amreport_on_t_to_string);
push @{$EXPORT_TAGS{"send_amreport_on_t"}}, qw(send_amreport_on_t_to_string);

my %_send_amreport_on_t_VALUES;
#Convert an enum value to a single string
sub send_amreport_on_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_send_amreport_on_t_VALUES) {
	my $v = $_send_amreport_on_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($SEND_AMREPORT_ALL);
push @{$EXPORT_TAGS{"send_amreport_on_t"}}, qw($SEND_AMREPORT_ALL);

$_send_amreport_on_t_VALUES{"SEND_AMREPORT_ALL"} = $SEND_AMREPORT_ALL;

push @EXPORT_OK, qw($SEND_AMREPORT_STRANGE);
push @{$EXPORT_TAGS{"send_amreport_on_t"}}, qw($SEND_AMREPORT_STRANGE);

$_send_amreport_on_t_VALUES{"SEND_AMREPORT_STRANGE"} = $SEND_AMREPORT_STRANGE;

push @EXPORT_OK, qw($SEND_AMREPORT_ERROR);
push @{$EXPORT_TAGS{"send_amreport_on_t"}}, qw($SEND_AMREPORT_ERROR);

$_send_amreport_on_t_VALUES{"SEND_AMREPORT_ERROR"} = $SEND_AMREPORT_ERROR;

push @EXPORT_OK, qw($SEND_AMREPORT_NEVER);
push @{$EXPORT_TAGS{"send_amreport_on_t"}}, qw($SEND_AMREPORT_NEVER);

$_send_amreport_on_t_VALUES{"SEND_AMREPORT_NEVER"} = $SEND_AMREPORT_NEVER;

#copy symbols in send_amreport_on_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"send_amreport_on_t"}};

push @EXPORT_OK, qw(data_path_t_to_string);
push @{$EXPORT_TAGS{"data_path_t"}}, qw(data_path_t_to_string);

my %_data_path_t_VALUES;
#Convert an enum value to a single string
sub data_path_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_data_path_t_VALUES) {
	my $v = $_data_path_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($DATA_PATH_AMANDA);
push @{$EXPORT_TAGS{"data_path_t"}}, qw($DATA_PATH_AMANDA);

$_data_path_t_VALUES{"DATA_PATH_AMANDA"} = $DATA_PATH_AMANDA;

push @EXPORT_OK, qw($DATA_PATH_DIRECTTCP);
push @{$EXPORT_TAGS{"data_path_t"}}, qw($DATA_PATH_DIRECTTCP);

$_data_path_t_VALUES{"DATA_PATH_DIRECTTCP"} = $DATA_PATH_DIRECTTCP;

#copy symbols in data_path_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"data_path_t"}};

push @EXPORT_OK, qw(part_cache_type_t_to_string);
push @{$EXPORT_TAGS{"part_cache_type_t"}}, qw(part_cache_type_t_to_string);

my %_part_cache_type_t_VALUES;
#Convert an enum value to a single string
sub part_cache_type_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_part_cache_type_t_VALUES) {
	my $v = $_part_cache_type_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($PART_CACHE_TYPE_NONE);
push @{$EXPORT_TAGS{"part_cache_type_t"}}, qw($PART_CACHE_TYPE_NONE);

$_part_cache_type_t_VALUES{"PART_CACHE_TYPE_NONE"} = $PART_CACHE_TYPE_NONE;

push @EXPORT_OK, qw($PART_CACHE_TYPE_DISK);
push @{$EXPORT_TAGS{"part_cache_type_t"}}, qw($PART_CACHE_TYPE_DISK);

$_part_cache_type_t_VALUES{"PART_CACHE_TYPE_DISK"} = $PART_CACHE_TYPE_DISK;

push @EXPORT_OK, qw($PART_CACHE_TYPE_MEMORY);
push @{$EXPORT_TAGS{"part_cache_type_t"}}, qw($PART_CACHE_TYPE_MEMORY);

$_part_cache_type_t_VALUES{"PART_CACHE_TYPE_MEMORY"} = $PART_CACHE_TYPE_MEMORY;

#copy symbols in part_cache_type_t to getconf
push @{$EXPORT_TAGS{"getconf"}},  @{$EXPORT_TAGS{"part_cache_type_t"}};

$LIMIT_SAMEHOST="SAMEHOST-SAMEHOST-SAMEHOST";
$LIMIT_SERVER="SERVER-SERVER-SERVER";

push @EXPORT_OK, qw(getconf getconf_seen getconf_linenum
    getconf_byname getconf_byname_strs
    getconf_list);
push @{$EXPORT_TAGS{"getconf"}}, qw(getconf getconf_seen getconf_linenum
    getconf_byname getconf_byname_strs
    getconf_list);

push @EXPORT_OK, qw(lookup_tapetype tapetype_getconf tapetype_name
    tapetype_seen tapetype_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_tapetype tapetype_getconf tapetype_name
    tapetype_seen tapetype_seen);

push @EXPORT_OK, qw(lookup_dumptype dumptype_getconf dumptype_name
    dumptype_seen dumptype_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_dumptype dumptype_getconf dumptype_name
    dumptype_seen dumptype_seen);

push @EXPORT_OK, qw(lookup_interface interface_getconf interface_name
    interface_seen interface_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_interface interface_getconf interface_name
    interface_seen interface_seen);

push @EXPORT_OK, qw(lookup_holdingdisk holdingdisk_getconf holdingdisk_name
    getconf_holdingdisks
    holdingdisk_seen holdingdisk_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_holdingdisk holdingdisk_getconf holdingdisk_name
    getconf_holdingdisks
    holdingdisk_seen holdingdisk_seen);

push @EXPORT_OK, qw(lookup_application application_getconf application_name
    application_seen application_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_application application_getconf application_name
    application_seen application_seen);

push @EXPORT_OK, qw(lookup_pp_script pp_script_getconf pp_script_name
    pp_script_seen pp_script_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_pp_script pp_script_getconf pp_script_name
    pp_script_seen pp_script_seen);

push @EXPORT_OK, qw(lookup_device_config device_config_getconf device_config_name
    device_config_seen device_config_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_device_config device_config_getconf device_config_name
    device_config_seen device_config_seen);

push @EXPORT_OK, qw(lookup_changer_config changer_config_getconf changer_config_name
    changer_config_seen changer_config_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_changer_config changer_config_getconf changer_config_name
    changer_config_seen changer_config_seen);

push @EXPORT_OK, qw(lookup_interactivity interactivity_getconf interactivity_name
    interactivity_seen interactivity_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_interactivity interactivity_getconf interactivity_name
    interactivity_seen interactivity_seen);

push @EXPORT_OK, qw(lookup_taperscan taperscan_getconf taperscan_name
    taperscan_seen taperscan_seen);
push @{$EXPORT_TAGS{"getconf"}}, qw(lookup_taperscan taperscan_getconf taperscan_name
    taperscan_seen taperscan_seen);

# only those keys with a value of '1' should be shown; the
# others are deprecated
our %subsection_names = (
    "tapetype" => 1,
    "dumptype" => 1,
    "interface" => 1,
    "holdingdisk" => 1,
    "application" => 1,
    "script" => 1,
    "application-tool" => 0,
    "script-tool" => 0,
    "device" => 1,
    "changer" => 1,
);

push @EXPORT_OK, qw(%subsection_names);
push @{$EXPORT_TAGS{"getconf"}}, qw(%subsection_names);

push @EXPORT_OK, qw(getconf_unit_divisor

    $debug_amandad $debug_recovery $debug_amidxtaped $debug_amindexd $debug_amrecover
    $debug_auth $debug_event $debug_holding $debug_protocol
    $debug_planner $debug_driver $debug_dumper $debug_chunker
    $debug_taper $debug_selfcheck $debug_sendsize $debug_sendbackup);
push @{$EXPORT_TAGS{"getconf"}}, qw(getconf_unit_divisor

    $debug_amandad $debug_recovery $debug_amidxtaped $debug_amindexd $debug_amrecover
    $debug_auth $debug_event $debug_holding $debug_protocol
    $debug_planner $debug_driver $debug_dumper $debug_chunker
    $debug_taper $debug_selfcheck $debug_sendsize $debug_sendbackup);

push @EXPORT_OK, qw(cfgerr_level_t_to_string);
push @{$EXPORT_TAGS{"cfgerr_level_t"}}, qw(cfgerr_level_t_to_string);

my %_cfgerr_level_t_VALUES;
#Convert an enum value to a single string
sub cfgerr_level_t_to_string {
    my ($enumval) = @_;

    for my $k (keys %_cfgerr_level_t_VALUES) {
	my $v = $_cfgerr_level_t_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($CFGERR_OK);
push @{$EXPORT_TAGS{"cfgerr_level_t"}}, qw($CFGERR_OK);

$_cfgerr_level_t_VALUES{"CFGERR_OK"} = $CFGERR_OK;

push @EXPORT_OK, qw($CFGERR_WARNINGS);
push @{$EXPORT_TAGS{"cfgerr_level_t"}}, qw($CFGERR_WARNINGS);

$_cfgerr_level_t_VALUES{"CFGERR_WARNINGS"} = $CFGERR_WARNINGS;

push @EXPORT_OK, qw($CFGERR_ERRORS);
push @{$EXPORT_TAGS{"cfgerr_level_t"}}, qw($CFGERR_ERRORS);

$_cfgerr_level_t_VALUES{"CFGERR_ERRORS"} = $CFGERR_ERRORS;

#copy symbols in cfgerr_level_t to init
push @{$EXPORT_TAGS{"init"}},  @{$EXPORT_TAGS{"cfgerr_level_t"}};

push @EXPORT_OK, qw(config_init_flags_to_strings);
push @{$EXPORT_TAGS{"config_init_flags"}}, qw(config_init_flags_to_strings);

my %_config_init_flags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub config_init_flags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_config_init_flags_VALUES) {
	my $v = $_config_init_flags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($CONFIG_INIT_EXPLICIT_NAME);
push @{$EXPORT_TAGS{"config_init_flags"}}, qw($CONFIG_INIT_EXPLICIT_NAME);

$_config_init_flags_VALUES{"CONFIG_INIT_EXPLICIT_NAME"} = $CONFIG_INIT_EXPLICIT_NAME;

push @EXPORT_OK, qw($CONFIG_INIT_USE_CWD);
push @{$EXPORT_TAGS{"config_init_flags"}}, qw($CONFIG_INIT_USE_CWD);

$_config_init_flags_VALUES{"CONFIG_INIT_USE_CWD"} = $CONFIG_INIT_USE_CWD;

push @EXPORT_OK, qw($CONFIG_INIT_CLIENT);
push @{$EXPORT_TAGS{"config_init_flags"}}, qw($CONFIG_INIT_CLIENT);

$_config_init_flags_VALUES{"CONFIG_INIT_CLIENT"} = $CONFIG_INIT_CLIENT;

push @EXPORT_OK, qw($CONFIG_INIT_OVERLAY);
push @{$EXPORT_TAGS{"config_init_flags"}}, qw($CONFIG_INIT_OVERLAY);

$_config_init_flags_VALUES{"CONFIG_INIT_OVERLAY"} = $CONFIG_INIT_OVERLAY;

#copy symbols in config_init_flags to init
push @{$EXPORT_TAGS{"init"}},  @{$EXPORT_TAGS{"config_init_flags"}};

push @EXPORT_OK, qw(config_init config_uninit get_config_options
    get_config_name get_config_dir get_config_filename
    config_print_errors config_clear_errors config_errors
    new_config_overrides free_config_overrides add_config_override
    add_config_override_opt set_config_overrides);
push @{$EXPORT_TAGS{"init"}}, qw(config_init config_uninit get_config_options
    get_config_name get_config_dir get_config_filename
    config_print_errors config_clear_errors config_errors
    new_config_overrides free_config_overrides add_config_override
    add_config_override_opt set_config_overrides);

push @EXPORT_OK, qw(dump_configuration config_dir_relative taperalgo2str find_multiplier);


sub string_to_boolean {
    my ($str) = @_;
    my $ret = C_string_to_boolean($str);
    return undef unless $ret >= 0;
    return $ret;
}


push @EXPORT_OK, qw(string_to_boolean);

push @EXPORT_OK, qw(amandaify_property_name);
1;
