#ifndef CORE_H
#define CORE_H

#include <gtk/gtk.h>
#ifdef HAVE_EDV2
# include <endeavour2.h>
#endif
#include "guiutils.h"
#include "cfg.h"
#include "win.h"


typedef struct _core_struct     core_struct;


/*
 *	Core:
 */
struct _core_struct {

	/* Configuration List */
	cfg_item_struct	*cfg_list;

#ifdef HAVE_EDV2
	/* Endeavour Mark II context */
	edv_context_struct	*edv_ctx;
#endif

	/* Pixmaps */
	GdkPixmap	*scan_item_pixmap;
	GdkBitmap	*scan_item_mask;
	GdkPixmap	*file_infected_pixmap;
	GdkBitmap	*file_infected_mask;
        GdkPixmap       *folder_closed_pixmap;
        GdkBitmap       *folder_closed_mask;
        GdkPixmap       *folder_opened_pixmap;
        GdkBitmap       *folder_opened_mask;
        GdkPixmap       *db_item_pixmap;
        GdkBitmap       *db_item_mask;

	/* Cursors */
	GdkCursor	*busy_cur,
			*passive_busy_cur;

	gboolean	close_all_windows;

	/* Windows Lists */
	GList		*win;

	gchar		*prog_name,		/* Program file name */
			*prog_path,		/* Full path to program */
			*prog_data_dir;		/* Program data directory */

	/* Command Line GUI Overrides */
        gchar		*title;
        GdkGeometryFlags geometry_flags;
        GdkRectangle	*geometry;
        gboolean	iconic;

};
#define CORE(p)		((core_struct *)(p))


extern win_struct *MainNewAVScan(core_struct *core, gint argc, gchar **argv); 


#endif	/* CORE_H */
